/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.http.impl.engine.client.PoolId;
import org.apache.pekko.http.impl.engine.client.PoolMaster;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.impl.settings.HostConnectionPoolSetup;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.Http$HttpConnectionTerminated$;
import org.apache.pekko.http.scaladsl.Http$HttpServerTerminated$;
import org.apache.pekko.http.scaladsl.Http$IncomingConnection$;
import org.apache.pekko.http.scaladsl.Http$OutgoingConnection$;
import org.apache.pekko.http.scaladsl.Http$ServerBinding$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Http {
    public static /* synthetic */ Extension apply(ActorSystem actorSystem) {
        return Http$.MODULE$.apply(actorSystem);
    }

    public static HttpExt apply(ActorSystem actorSystem) {
        return Http$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Http$.MODULE$.apply(classicActorSystemProvider);
    }

    public static HttpExt apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Http$.MODULE$.apply(classicActorSystemProvider);
    }

    @InternalApi
    public static Attributes cancellationStrategyAttributeForDelay(FiniteDuration finiteDuration) {
        return Http$.MODULE$.cancellationStrategyAttributeForDelay(finiteDuration);
    }

    public static HttpExt createExtension(ExtendedActorSystem extendedActorSystem) {
        return Http$.MODULE$.createExtension(extendedActorSystem);
    }

    public static boolean equals(Object object) {
        return Http$.MODULE$.equals(object);
    }

    public static Extension get(ActorSystem actorSystem) {
        return Http$.MODULE$.get(actorSystem);
    }

    public static Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Http$.MODULE$.get(classicActorSystemProvider);
    }

    public static int hashCode() {
        return Http$.MODULE$.hashCode();
    }

    public static ExtensionId<? extends Extension> lookup() {
        return Http$.MODULE$.lookup();
    }

    @InternalApi
    public static Attributes prepareAttributes(ServerSettings serverSettings, Tcp.IncomingConnection incomingConnection) {
        return Http$.MODULE$.prepareAttributes(serverSettings, incomingConnection);
    }

    @DoNotInherit
    public static abstract class HostConnectionPool
    implements Product {
        public abstract HostConnectionPoolSetup setup();

        public abstract Future<Done> shutdown();

        public org.apache.pekko.http.javadsl.HostConnectionPool toJava() {
            return new org.apache.pekko.http.javadsl.HostConnectionPool(this){
                private final /* synthetic */ HostConnectionPool $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public HostConnectionPoolSetup setup() {
                    return this.$outer.setup();
                }

                public CompletionStage shutdown() {
                    Future future = FutureConverters$.MODULE$.FutureOps(this.$outer.shutdown());
                    return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
                }
            };
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int n) {
            if (n == 0) {
                return this.setup();
            }
            throw new IllegalArgumentException();
        }

        public boolean canEqual(Object that) {
            return that instanceof HostConnectionPool;
        }
    }

    @InternalApi
    public static final class HostConnectionPoolImpl
    extends HostConnectionPool {
        private final PoolId poolId;
        private final PoolMaster master;

        public HostConnectionPoolImpl(PoolId poolId, PoolMaster master) {
            this.poolId = poolId;
            this.master = master;
        }

        public PoolId poolId() {
            return this.poolId;
        }

        @Override
        public HostConnectionPoolSetup setup() {
            return this.poolId().hcps();
        }

        @Override
        public Future<Done> shutdown() {
            return this.master.shutdown(this.poolId());
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof HostConnectionPoolImpl) {
                HostConnectionPoolImpl i = (HostConnectionPoolImpl)object;
                PoolId poolId = i.poolId();
                PoolId poolId2 = this.poolId();
                if (!(poolId != null ? !((Object)poolId).equals(poolId2) : poolId2 != null)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static abstract class HttpConnectionTerminated
    extends HttpTerminated {
        public static int ordinal(HttpConnectionTerminated httpConnectionTerminated) {
            return Http$HttpConnectionTerminated$.MODULE$.ordinal(httpConnectionTerminated);
        }
    }

    public static abstract class HttpServerTerminated
    extends HttpTerminated {
        public static int ordinal(HttpServerTerminated httpServerTerminated) {
            return Http$HttpServerTerminated$.MODULE$.ordinal(httpServerTerminated);
        }
    }

    @DoNotInherit
    public static abstract class HttpTerminated
    extends org.apache.pekko.http.javadsl.HttpTerminated {
    }

    public static final class IncomingConnection
    implements Product,
    Serializable {
        private final InetSocketAddress localAddress;
        private final InetSocketAddress remoteAddress;
        private final Flow _flow;

        public static IncomingConnection apply(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, Flow<HttpResponse, HttpRequest, ServerTerminator> flow) {
            return Http$IncomingConnection$.MODULE$.apply(inetSocketAddress, inetSocketAddress2, flow);
        }

        public static IncomingConnection fromProduct(Product product) {
            return Http$IncomingConnection$.MODULE$.fromProduct(product);
        }

        public static IncomingConnection unapply(IncomingConnection incomingConnection) {
            return Http$IncomingConnection$.MODULE$.unapply(incomingConnection);
        }

        public IncomingConnection(InetSocketAddress localAddress, InetSocketAddress remoteAddress, Flow<HttpResponse, HttpRequest, ServerTerminator> _flow) {
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
            this._flow = _flow;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IncomingConnection)) return false;
            IncomingConnection incomingConnection = (IncomingConnection)object;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = incomingConnection.localAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            InetSocketAddress inetSocketAddress3 = this.remoteAddress();
            InetSocketAddress inetSocketAddress4 = incomingConnection.remoteAddress();
            if (inetSocketAddress3 == null) {
                if (inetSocketAddress4 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress3).equals(inetSocketAddress4)) return false;
            Flow<HttpResponse, HttpRequest, ServerTerminator> flow = this._flow();
            Flow<HttpResponse, HttpRequest, ServerTerminator> flow2 = incomingConnection._flow();
            if (flow == null) {
                if (flow2 == null) return true;
                return false;
            } else {
                if (!flow.equals(flow2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IncomingConnection;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "IncomingConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "localAddress";
                }
                case 1: {
                    return "remoteAddress";
                }
                case 2: {
                    return "_flow";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        public InetSocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        public Flow<HttpResponse, HttpRequest, ServerTerminator> _flow() {
            return this._flow;
        }

        public Flow<HttpResponse, HttpRequest, NotUsed> flow() {
            return this._flow().mapMaterializedValue(Http$::org$apache$pekko$http$scaladsl$Http$IncomingConnection$$_$flow$$anonfun$1);
        }

        public <Mat> Mat handleWith(Flow<HttpRequest, HttpResponse, Mat> handler, Materializer fm) {
            return (Mat)this.flow().joinMat(handler, Keep$.MODULE$.right()).run(fm);
        }

        public void handleWithSyncHandler(Function1<HttpRequest, HttpResponse> handler, Materializer fm) {
            this.handleWith((Flow)Flow$.MODULE$.apply().map(handler), fm);
        }

        public void handleWithAsyncHandler(Function1<HttpRequest, Future<HttpResponse>> handler, int parallelism, Materializer fm) {
            this.handleWith((Flow)Flow$.MODULE$.apply().mapAsync(parallelism, handler), fm);
        }

        public int handleWithAsyncHandler$default$2() {
            return 1;
        }

        public IncomingConnection copy(InetSocketAddress localAddress, InetSocketAddress remoteAddress, Flow<HttpResponse, HttpRequest, ServerTerminator> _flow) {
            return new IncomingConnection(localAddress, remoteAddress, _flow);
        }

        public InetSocketAddress copy$default$1() {
            return this.localAddress();
        }

        public InetSocketAddress copy$default$2() {
            return this.remoteAddress();
        }

        public Flow<HttpResponse, HttpRequest, ServerTerminator> copy$default$3() {
            return this._flow();
        }

        public InetSocketAddress _1() {
            return this.localAddress();
        }

        public InetSocketAddress _2() {
            return this.remoteAddress();
        }

        public Flow<HttpResponse, HttpRequest, ServerTerminator> _3() {
            return this._flow();
        }
    }

    public static final class OutgoingConnection
    implements Product,
    Serializable {
        private final InetSocketAddress localAddress;
        private final InetSocketAddress remoteAddress;

        public static OutgoingConnection apply(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            return Http$OutgoingConnection$.MODULE$.apply(inetSocketAddress, inetSocketAddress2);
        }

        public static OutgoingConnection fromProduct(Product product) {
            return Http$OutgoingConnection$.MODULE$.fromProduct(product);
        }

        public static OutgoingConnection unapply(OutgoingConnection outgoingConnection) {
            return Http$OutgoingConnection$.MODULE$.unapply(outgoingConnection);
        }

        public OutgoingConnection(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OutgoingConnection)) return false;
            OutgoingConnection outgoingConnection = (OutgoingConnection)object;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = outgoingConnection.localAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            InetSocketAddress inetSocketAddress3 = this.remoteAddress();
            InetSocketAddress inetSocketAddress4 = outgoingConnection.remoteAddress();
            if (inetSocketAddress3 == null) {
                if (inetSocketAddress4 == null) return true;
                return false;
            } else {
                if (!((Object)inetSocketAddress3).equals(inetSocketAddress4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OutgoingConnection;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OutgoingConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localAddress";
            }
            if (1 == n2) {
                return "remoteAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        public InetSocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        public OutgoingConnection copy(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
            return new OutgoingConnection(localAddress, remoteAddress);
        }

        public InetSocketAddress copy$default$1() {
            return this.localAddress();
        }

        public InetSocketAddress copy$default$2() {
            return this.remoteAddress();
        }

        public InetSocketAddress _1() {
            return this.localAddress();
        }

        public InetSocketAddress _2() {
            return this.remoteAddress();
        }
    }

    public static final class ServerBinding
    implements Product,
    Serializable {
        private final InetSocketAddress localAddress;
        private final Function0 unbindAction;
        private final Function1 terminateAction;
        private final Promise<Deadline> _whenTerminationSignalIssued;
        private final Promise<HttpTerminated> _whenTerminated;

        public static ServerBinding apply(InetSocketAddress inetSocketAddress, Function0<Future<BoxedUnit>> function0, Function1<FiniteDuration, Future<HttpTerminated>> function1) {
            return Http$ServerBinding$.MODULE$.apply(inetSocketAddress, function0, function1);
        }

        public static ServerBinding unapply(ServerBinding serverBinding) {
            return Http$ServerBinding$.MODULE$.unapply(serverBinding);
        }

        public ServerBinding(InetSocketAddress localAddress, Function0<Future<BoxedUnit>> unbindAction, Function1<FiniteDuration, Future<HttpTerminated>> terminateAction) {
            this.localAddress = localAddress;
            this.unbindAction = unbindAction;
            this.terminateAction = terminateAction;
            this._whenTerminationSignalIssued = Promise$.MODULE$.apply();
            this._whenTerminated = Promise$.MODULE$.apply();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ServerBinding)) return false;
            ServerBinding serverBinding = (ServerBinding)object;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = serverBinding.localAddress();
            if (inetSocketAddress != null) {
                if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
                return true;
            }
            if (inetSocketAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ServerBinding;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ServerBinding";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        private Function0<Future<BoxedUnit>> unbindAction() {
            return this.unbindAction;
        }

        private Function1<FiniteDuration, Future<HttpTerminated>> terminateAction() {
            return this.terminateAction;
        }

        public Future<Done> unbind() {
            return ((Future)this.unbindAction().apply()).map(Http$::org$apache$pekko$http$scaladsl$Http$ServerBinding$$_$unbind$$anonfun$1, ExecutionContexts$.MODULE$.parasitic());
        }

        public Future<HttpTerminated> terminate(FiniteDuration hardDeadline) {
            Predef$.MODULE$.require(hardDeadline.$greater((Object)Duration$.MODULE$.Zero()), () -> Http$.org$apache$pekko$http$scaladsl$Http$ServerBinding$$_$terminate$$anonfun$1(hardDeadline));
            this._whenTerminationSignalIssued.trySuccess((Object)hardDeadline.fromNow());
            Future terminated = ((Future)this.unbindAction().apply()).flatMap((Function1 & Serializable)_$10 -> (Future)this.terminateAction().apply((Object)hardDeadline), ExecutionContexts$.MODULE$.parasitic());
            this._whenTerminated.completeWith(terminated);
            return this.whenTerminated();
        }

        public Future<Deadline> whenTerminationSignalIssued() {
            return this._whenTerminationSignalIssued.future();
        }

        public Future<HttpTerminated> whenTerminated() {
            return this._whenTerminated.future();
        }

        public ServerBinding addToCoordinatedShutdown(FiniteDuration hardTerminationDeadline, ClassicActorSystemProvider system) {
            CoordinatedShutdown shutdown = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(system);
            shutdown.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), new StringBuilder(12).append("http-unbind-").append(this.localAddress()).toString(), (Function0 & Serializable)() -> this.unbind());
            shutdown.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone(), new StringBuilder(15).append("http-terminate-").append(this.localAddress()).toString(), (Function0 & Serializable)() -> this.terminate(hardTerminationDeadline).map(Http$::org$apache$pekko$http$scaladsl$Http$ServerBinding$$_$addToCoordinatedShutdown$$anonfun$2$$anonfun$1, ExecutionContexts$.MODULE$.parasitic()));
            return this;
        }

        public ServerBinding copy(InetSocketAddress localAddress, Function0<Future<BoxedUnit>> unbindAction, Function1<FiniteDuration, Future<HttpTerminated>> terminateAction) {
            return new ServerBinding(localAddress, unbindAction, terminateAction);
        }

        public InetSocketAddress copy$default$1() {
            return this.localAddress();
        }

        public InetSocketAddress _1() {
            return this.localAddress();
        }
    }
}

