/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model.http2;

import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.scaladsl.model.http2.Http2Exception;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

@ApiMayChange
public class PeerClosedStreamException
extends Http2Exception
implements NoStackTrace {
    private final int streamId;
    private final String errorCode;
    private final int numericErrorCode;

    public PeerClosedStreamException(int streamId, String errorCode, int numericErrorCode) {
        this.streamId = streamId;
        this.errorCode = errorCode;
        this.numericErrorCode = numericErrorCode;
        super(StringOps$.MODULE$.format$extension("Stream with ID [%d] was closed by peer with code %s(0x%02x)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)streamId), errorCode, BoxesRunTime.boxToInteger((int)numericErrorCode)})));
        NoStackTrace.$init$((NoStackTrace)this);
    }

    public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
        return super.fillInStackTrace();
    }

    public int streamId() {
        return this.streamId;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public int numericErrorCode() {
        return this.numericErrorCode;
    }

    public PeerClosedStreamException(int streamId, Http2Protocol.ErrorCode errorCode) {
        this(streamId, errorCode.toString(), errorCode.id());
    }
}

