/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.languagelibrary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.nlogo.api.ExtensionException;
import org.nlogo.languagelibrary.TargetLanguageErrorException;
import org.nlogo.swing.Button;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.MenuItem$;
import org.nlogo.swing.PopupMenu;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.TextArea;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.java8.JFunction0;

public class ShellWindow
extends JFrame
implements ThemeSync {
    private Option<Function1<String, String>> evalStringified = None$.MODULE$;
    public Seq<String> org$nlogo$languagelibrary$ShellWindow$$cmdHistory = (Seq)((SeqOps)Nil$.MODULE$);
    public int org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex = -1;
    public final JSplitPane org$nlogo$languagelibrary$ShellWindow$$consolePanel = new JSplitPane(0);
    private final TextArea output = new TextArea(0, 0, "");
    private final TextArea input = new TextArea(0, 0, "");
    private final ScrollPane sp1 = new ScrollPane((Component)this.output(), 22, ScrollPane$.MODULE$.$lessinit$greater$default$3());
    private final ScrollPane sp2 = new ScrollPane((Component)this.input(), 22, ScrollPane$.MODULE$.$lessinit$greater$default$3());
    private final JPanel bottomContainer = new Transparent(){
        {
            Transparent.$init$((Transparent)this);
        }
    };
    private final Button runButton = new Button("Run", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.org$nlogo$languagelibrary$ShellWindow$$runCode());
    private final Button clearCodeAreaButton = new Button("Clear Code", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.input().setText(""));
    private final JPanel topContainer = new Transparent(){
        {
            Transparent.$init$((Transparent)this);
        }
    };
    private final Button clearHistoryAreaButton = new Button("Clear History", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.output().setText(""));
    private final PopupMenu outputContextMenu = new PopupMenu("Edit");
    private final PopupMenu inputContextMenu = new PopupMenu("Edit");

    public ShellWindow() {
        this.outputContextMenu.add((JMenuItem)new MenuItem((Action)new AbstractAction(this){
            private final /* synthetic */ ShellWindow $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super("Copy Selected Text");
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.output().copy();
            }
        }, MenuItem$.MODULE$.$lessinit$greater$default$2()));
        this.outputContextMenu.add((JMenuItem)new MenuItem((Action)new AbstractAction(this){
            private final /* synthetic */ ShellWindow $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super("Clear Text");
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.output().setText("");
            }
        }, MenuItem$.MODULE$.$lessinit$greater$default$2()));
        this.inputContextMenu.add((JMenuItem)new MenuItem((Action)new AbstractAction(this){
            private final /* synthetic */ ShellWindow $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super("Copy Selected Text");
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.input().copy();
            }
        }, MenuItem$.MODULE$.$lessinit$greater$default$2()));
        this.inputContextMenu.add((JMenuItem)new MenuItem((Action)new AbstractAction(this){
            private final /* synthetic */ ShellWindow $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super("Clear Text");
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.input().setText("");
            }
        }, MenuItem$.MODULE$.$lessinit$greater$default$2()));
        this.output().setText("Usage:\n\nWrite commands in the lower area and hit Ctrl-Enter to submit them.\nUse page up/down to recall previously submitted commands.\n\n");
        this.initPanels();
    }

    public TextArea output() {
        return this.output;
    }

    public TextArea input() {
        return this.input;
    }

    public JPanel bottomContainer() {
        return this.bottomContainer;
    }

    public Button runButton() {
        return this.runButton;
    }

    public Button clearCodeAreaButton() {
        return this.clearCodeAreaButton;
    }

    public JPanel topContainer() {
        return this.topContainer;
    }

    public Button clearHistoryAreaButton() {
        return this.clearHistoryAreaButton;
    }

    public void setEvalStringified(Option<Function1<String, String>> _evalStringified) {
        this.evalStringified = _evalStringified;
    }

    public Option<Function1<String, String>> getEvalStringified() {
        return this.evalStringified;
    }

    public Seq<String> getCmdHistory() {
        return this.org$nlogo$languagelibrary$ShellWindow$$cmdHistory;
    }

    private void initPanels() {
        this.input().addKeyListener((KeyListener)new KeyAdapter(this){
            private final /* synthetic */ ShellWindow $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void keyPressed(KeyEvent ke) {
                if (ke.isControlDown() && ke.getKeyCode() == 10) {
                    this.$outer.org$nlogo$languagelibrary$ShellWindow$$runCode();
                    return;
                }
                if (ke.getKeyCode() == 33 && this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex < this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistory.size() - 1) {
                    ++this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex;
                    this.$outer.input().setText((String)this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistory.apply(this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex));
                    this.$outer.input().setCaretPosition(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.$outer.input().getText())));
                    return;
                }
                if (ke.getKeyCode() == 34 && this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex > -1) {
                    --this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex;
                    if (this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex == -1) {
                        this.$outer.input().setText("");
                        return;
                    }
                    this.$outer.input().setText((String)this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistory.apply(this.$outer.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex));
                    this.$outer.input().setCaretPosition(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.$outer.input().getText())));
                    return;
                }
            }
        });
        this.org$nlogo$languagelibrary$ShellWindow$$consolePanel.setTopComponent((Component)this.sp1);
        this.org$nlogo$languagelibrary$ShellWindow$$consolePanel.setBottomComponent((Component)this.sp2);
        this.topContainer().setLayout(new BorderLayout());
        this.topContainer().add((Component)this.clearHistoryAreaButton(), "East");
        this.bottomContainer().setLayout(new BorderLayout());
        this.bottomContainer().add((Component)this.clearCodeAreaButton(), "West");
        this.bottomContainer().add((Component)this.runButton(), "East");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.org$nlogo$languagelibrary$ShellWindow$$consolePanel, "Center");
        this.getContentPane().add((Component)this.bottomContainer(), "Last");
        this.getContentPane().add((Component)this.topContainer(), "First");
        this.setMinimumSize(new Dimension(400, 400));
        this.setSize(new Dimension(555, 650));
        this.output().setEditable(false);
        this.org$nlogo$languagelibrary$ShellWindow$$consolePanel.setDividerLocation((int)((double)this.getHeight() * 0.65));
        this.addComponentListener(new ComponentAdapter(this){
            private final /* synthetic */ ShellWindow $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void componentResized(ComponentEvent evt) {
                super.componentResized(evt);
                this.$outer.org$nlogo$languagelibrary$ShellWindow$$consolePanel.setDividerLocation((int)((double)this.$outer.getHeight() * 0.65));
            }
        });
        this.output().setComponentPopupMenu((JPopupMenu)this.outputContextMenu);
        this.input().setComponentPopupMenu((JPopupMenu)this.inputContextMenu);
        this.input().setTabSize(2);
        this.output().setTabSize(2);
    }

    public void org$nlogo$languagelibrary$ShellWindow$$runCode() {
        block5: {
            String cmd = this.input().getText().trim();
            this.org$nlogo$languagelibrary$ShellWindow$$cmdHistory = (Seq)((SeqOps)this.org$nlogo$languagelibrary$ShellWindow$$cmdHistory.filter((Function1 & Serializable)_$1 -> {
                String string = _$1;
                String string2 = cmd;
                return string == null ? string2 != null : !string.equals(string2);
            })).$plus$colon((Object)cmd);
            this.org$nlogo$languagelibrary$ShellWindow$$cmdHistoryIndex = -1;
            this.input().setText("");
            this.input().setCaretPosition(0);
            this.input().requestFocus();
            this.output().append(">> " + cmd + "\n");
            try {
                Option<Function1<String, String>> option = this.evalStringified;
                if (option instanceof Some) {
                    Function1 f = (Function1)((Some)option).value();
                    this.output().append((String)f.apply((Object)cmd) + "\n");
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    this.output().append("This extension has not been properly initialized yet.\n");
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (ExtensionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof TargetLanguageErrorException) {
                    TargetLanguageErrorException t = (TargetLanguageErrorException)throwable;
                    this.output().append(t.getLongMessage());
                }
                throw e;
            }
        }
    }

    public void syncTheme() {
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.sp1.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.sp2.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.output().syncTheme();
        this.input().syncTheme();
        this.runButton().syncTheme();
        this.clearCodeAreaButton().syncTheme();
        this.clearHistoryAreaButton().syncTheme();
        this.outputContextMenu.syncTheme();
        this.inputContextMenu.syncTheme();
    }
}

