/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.languagelibrary;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.Socket;
import org.json4s.jackson.JsonMethods;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Workspace;
import org.nlogo.core.Syntax$;
import org.nlogo.languagelibrary.Logger$;
import org.nlogo.languagelibrary.Subprocess;
import org.nlogo.languagelibrary.Subprocess$InTypes$;
import org.nlogo.languagelibrary.Subprocess$OutTypes$;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Subprocess$
implements Serializable {
    public static final Subprocess$OutTypes$ OutTypes;
    public static final Subprocess$InTypes$ InTypes;
    private static final int convertibleTypesSyntax;
    public static final Subprocess$ MODULE$;

    private Subprocess$() {
    }

    static {
        MODULE$ = new Subprocess$();
        convertibleTypesSyntax = Syntax$.MODULE$.AgentType() | Syntax$.MODULE$.AgentsetType() | Syntax$.MODULE$.ReadableType();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Subprocess$.class);
    }

    public int convertibleTypesSyntax() {
        return convertibleTypesSyntax;
    }

    public Subprocess start(Workspace ws, Seq<String> processStartCmd, Seq<String> processStartArgs, String extensionName, String extensionLongName, Option<Object> suppliedPort, Option<JsonMethods> customMapper) {
        Logger$.MODULE$.current().logOne("Subprocess.start()");
        File workingDirectory = this.getWorkingDirectory(ws);
        Process proc = new ProcessBuilder(CollectionConverters$.MODULE$.SeqHasAsJava(this.createSystemCommandTokens((Seq<String>)((Seq)processStartCmd.$plus$plus(processStartArgs)))).asJava()).directory(workingDirectory).start();
        int port = this.choosePort(suppliedPort, proc);
        Socket socket = this.makeSocketConnection(proc, port);
        if (!proc.isAlive()) {
            throw this.earlyFail(proc, "Process terminated early.");
        }
        return new Subprocess(ws, proc, socket, extensionName, extensionLongName, customMapper);
    }

    public Option<Object> start$default$6() {
        return None$.MODULE$;
    }

    public Option<JsonMethods> start$default$7() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public Seq<File> path() {
        basePath = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PATH", (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$19(), ()Ljava/lang/String;)());
        os = System.getProperty("os.name").toLowerCase();
        if (!os.contains("mac")) ** GOTO lbl-1000
        v0 = basePath;
        var4_3 = "/usr/bin:/bin:/usr/sbin:/sbin";
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            v1 = (String)this.getSysCmdOutput((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/bin/bash", "-l", "-c", "echo $PATH"})).head() + basePath;
        } else lbl-1000:
        // 2 sources

        {
            v1 = basePath;
        }
        unsplitPath = v1;
        var6_5 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(unsplitPath), File.pathSeparatorChar));
        var5_6 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(var6_5, (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, path$$anonfun$1(java.lang.String ), (Ljava/lang/String;)Ljava/io/File;)(), ClassTag$.MODULE$.apply(File.class)));
        return ArraySeq$.MODULE$.unsafeWrapArray(ArrayOps$.MODULE$.filter$extension(var5_6, (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, path$$anonfun$2(java.io.File ), (Ljava/io/File;)Ljava/lang/Boolean;)()));
    }

    private int choosePort(Option<Object> suppliedPort, Process proc) {
        return BoxesRunTime.unboxToInt((Object)suppliedPort.getOrElse(() -> Subprocess$.choosePort$$anonfun$1(proc)));
    }

    private <A> int extractPortFromProc(Process proc, BufferedReader pbInput) {
        int n;
        String portLine = pbInput.readLine();
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(portLine));
        }
        catch (NumberFormatException numberFormatException) {
            throw this.earlyFail(proc, "Process did not provide expected output. Expected a valid port number but got:\n" + portLine);
        }
        int portLineInt = n;
        if (portLineInt <= 0 || portLineInt > 65535) {
            throw this.earlyFail(proc, "Process did not provide expected output. Expected a valid port number but got:\n" + portLine);
        }
        return portLineInt;
    }

    private File getWorkingDirectory(Workspace ws) {
        File prefix = new File(((AbstractWorkspace)ws).fileManager().prefix());
        if (prefix.exists()) {
            return prefix;
        }
        return new File(System.getProperty("user.home"));
    }

    private Socket makeSocketConnection(Process proc, int port) {
        Socket socket = null;
        while (socket == null && proc.isAlive()) {
            try {
                socket = new Socket("localhost", port);
            }
            catch (IOException iOException) {
            }
            catch (SecurityException e) {
                throw new ExtensionException((Exception)e);
            }
        }
        return socket;
    }

    private Nothing$ earlyFail(Process proc, String prefix) {
        Object object;
        String stdout = this.readAllReady(new InputStreamReader(proc.getInputStream()));
        String stderr = this.readAllReady(new InputStreamReader(proc.getErrorStream()));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)stderr, (Object)stdout);
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if ("".equals(string)) {
                String s = string2;
                object = s;
            } else {
                String s = string;
                if ("".equals(string2)) {
                    object = s;
                } else {
                    String e = string;
                    String o = string2;
                    object = "Error output:\n" + e + "\n\nOutput:\n" + o;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        String msg = object;
        throw new ExtensionException(prefix + "\n" + msg);
    }

    private String readAllReady(Reader in) {
        StringBuilder sb = new StringBuilder();
        while (in.ready()) {
            sb.append((char)in.read());
        }
        return sb.toString();
    }

    private Seq<String> createSystemCommandTokens(Seq<String> args) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return (Seq)new .colon.colon((Object)"/bin/bash", (List)new .colon.colon((Object)"-l", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)((IterableOnceOps)args.map((Function1 & Serializable)a -> "'" + a + "'")).mkString(" "), (List)Nil$.MODULE$))));
        }
        return args;
    }

    private List<String> getSysCmdOutput(Seq<String> cmd) {
        Process proc = new ProcessBuilder((String[])Arrays$.MODULE$.seqToArray(cmd, String.class)).redirectError(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE).start();
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        return package$.MODULE$.Iterator().continually(() -> Subprocess$.getSysCmdOutput$$anonfun$1(in)).takeWhile((Function1 & Serializable)_$2 -> _$2 != null).toList();
    }

    private static final String $anonfun$19() {
        return "";
    }

    private static final /* synthetic */ File path$$anonfun$1(String _$1) {
        return new File(_$1);
    }

    private static final /* synthetic */ boolean path$$anonfun$2(File f) {
        return f.isDirectory();
    }

    private static final int choosePort$$anonfun$1(Process proc$1) {
        BufferedReader pbInput = new BufferedReader(new InputStreamReader(proc$1.getInputStream()));
        return MODULE$.extractPortFromProc(proc$1, pbInput);
    }

    private static final String getSysCmdOutput$$anonfun$1(BufferedReader in$1) {
        return in$1.readLine();
    }
}

