/*
 * Decompiled with CFR 0.152.
 */
package bsearch.fx;

import bsearch.fx.MainController;
import bsearch.util.GeneralUtils;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class MainGUI
extends Application {
    public static void main(String[] args) {
        MainGUI.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        try {
            FXMLLoader loader = new FXMLLoader(GeneralUtils.getResource("BSearchMain.fxml").toURI().toURL());
            Parent root = (Parent)loader.load();
            Scene scene = new Scene(root);
            primaryStage.setScene(scene);
            primaryStage.setTitle("Untitled" + MainGUI.getWindowTitleSuffix());
            Platform.setImplicitExit((boolean)false);
            final MainController controller = (MainController)loader.getController();
            primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    if (!controller.checkDiscardOkay()) {
                        event.consume();
                    } else {
                        Platform.exit();
                        System.exit(0);
                    }
                }
            });
            primaryStage.show();
            Image icon = new Image(GeneralUtils.getResource("icon_behaviorsearch.png").toURI().toString());
            primaryStage.getIcons().add((Object)icon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String getWindowTitleSuffix() {
        return " - BehaviorSearch " + GeneralUtils.getVersionString();
    }
}

