/*
 * Decompiled with CFR 0.152.
 */
package bsearch.nlogolink;

import bsearch.nlogolink.NetLogoLinkException;
import java.io.IOException;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.ChooserConstraint;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.api.ValueConstraint;
import org.nlogo.core.CompilerException;
import org.nlogo.headless.HeadlessWorkspace;

public class Utils {
    public static final long MIN_EXACT_NETLOGO_INT = -9007199254740992L;
    public static final long MAX_EXACT_NETLOGO_INT = 0x20000000000000L;
    private static HeadlessWorkspace emptyWorkspace;

    public static Object evaluateNetLogoReporterInEmptyWorkspace(String reporterString, Boolean is3d) throws NetLogoLinkException {
        if (emptyWorkspace == null) {
            emptyWorkspace = HeadlessWorkspace.newInstance((boolean)is3d);
        } else if (emptyWorkspace.is3d() != is3d.booleanValue()) {
            try {
                emptyWorkspace.dispose();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            emptyWorkspace = HeadlessWorkspace.newInstance((boolean)is3d);
        }
        try {
            return emptyWorkspace.report(reporterString);
        }
        catch (Exception ex) {
            throw new NetLogoLinkException(ex.getMessage());
        }
    }

    public static HeadlessWorkspace createWorkspace(Boolean is3d) {
        System.setProperty("org.nlogo.preferHeadless", "true");
        HeadlessWorkspace workspace = HeadlessWorkspace.newInstance((boolean)is3d);
        return workspace;
    }

    public static void fullyShutDownNetLogoLink() throws InterruptedException {
        emptyWorkspace.dispose();
    }

    public static String getDefaultConstraintsText(String modelFileName) throws NetLogoLinkException {
        HeadlessWorkspace workspace = Utils.createWorkspace(modelFileName.endsWith(".nlogo3d") || modelFileName.endsWith(".nlogox3d"));
        try {
            workspace.open(modelFileName, false);
        }
        catch (IOException e) {
            throw new NetLogoLinkException("I/O Error trying to open model file '" + modelFileName + "'\n " + e.toString(), e);
        }
        catch (CompilerException e) {
            throw new NetLogoLinkException("Model file '" + modelFileName + "' didn't compile: " + e.toString(), e);
        }
        catch (LogoException e) {
            throw new NetLogoLinkException("Unexpected error loading model: " + e.toString(), e);
        }
        StringBuilder sb = new StringBuilder();
        int numVars = workspace.world().observer().variables().length;
        for (int i = 0; i < numVars; ++i) {
            ValueConstraint con = workspace.world().observer().constraint(i);
            if (con == null) continue;
            String name = workspace.world().observerOwnsNameAt(i);
            sb.append("[\"");
            sb.append(name.toLowerCase());
            sb.append("\" ");
            StringBuilder sb2 = new StringBuilder();
            if (con instanceof SliderConstraint) {
                SliderConstraint scon = (SliderConstraint)con;
                double min = (Double)scon.minimum().get();
                double incr = (Double)scon.increment().get();
                double max = (Double)scon.maximum().get();
                String strIncr = Dump.logoObject((Object)incr, (boolean)true, (boolean)false);
                if (min != StrictMath.floor(min) && incr != StrictMath.floor(incr) && StrictMath.abs((max - min) / incr) > 100.0) {
                    strIncr = "\"C\"";
                }
                sb2.append("[");
                sb2.append(Dump.logoObject((Object)min, (boolean)true, (boolean)false));
                sb2.append(" ");
                sb2.append(strIncr);
                sb2.append(" ");
                sb2.append(Dump.logoObject((Object)max, (boolean)true, (boolean)false));
                sb2.append("]");
            } else if (con instanceof ChooserConstraint) {
                ChooserConstraint ccon = (ChooserConstraint)con;
                for (Object obj : ccon.acceptedValues().javaIterable()) {
                    sb2.append(Dump.logoObject(obj, (boolean)true, (boolean)false));
                    sb2.append(" ");
                }
                sb2.setLength(sb2.length() - 1);
            } else if (con instanceof BooleanConstraint) {
                sb2.append(Dump.logoObject((Object)Boolean.TRUE, (boolean)true, (boolean)false));
                sb2.append(" ");
                sb2.append(Dump.logoObject((Object)Boolean.FALSE, (boolean)true, (boolean)false));
            } else {
                sb2.append(Dump.logoObject((Object)con.defaultValue(), (boolean)true, (boolean)false));
            }
            sb.append((CharSequence)sb2);
            sb.append("]\n");
        }
        try {
            workspace.dispose();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sb.toString();
    }
}

