/*
 * Decompiled with CFR 0.152.
 */
package bsearch.representations;

import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.DoubleContinuousSpec;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.nlogo.api.MersenneTwisterFast;

public class RealHypercubeChromosome
implements Chromosome {
    private double[] dVals;
    private SearchSpace searchSpace;

    private RealHypercubeChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
        this.searchSpace = searchSpace;
        List<ParameterSpec> paramSpecs = searchSpace.getParamSpecs();
        this.dVals = new double[paramSpecs.size()];
        for (int i = 0; i < this.dVals.length; ++i) {
            this.dVals[i] = rng.nextDouble();
        }
    }

    private RealHypercubeChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
        this.searchSpace = searchSpace;
        List<ParameterSpec> paramSpecs = searchSpace.getParamSpecs();
        if (paramSpecs.size() != paramSettings.size()) {
            throw new IllegalStateException("# of parameter settings does not match search space parameter specifications.");
        }
        this.dVals = new double[paramSpecs.size()];
        for (int i = 0; i < this.dVals.length; ++i) {
            ParameterSpec paramSpec = paramSpecs.get(i);
            Object val = paramSettings.get(paramSpec.getParameterName());
            if (paramSpec instanceof DoubleContinuousSpec) {
                DoubleContinuousSpec dspec = (DoubleContinuousSpec)paramSpec;
                double paramVal = (Double)val;
                this.dVals[i] = (paramVal - dspec.getMin()) / (dspec.getMax() - dspec.getMin());
                continue;
            }
            long choice = paramSpec.getChoiceIndexFromValue(val, paramSpec.choiceCount());
            this.dVals[i] = (double)choice / (double)paramSpec.choiceCount();
        }
    }

    private RealHypercubeChromosome(double[] dVals, SearchSpace searchSpace) {
        this.dVals = (double[])dVals.clone();
        this.searchSpace = searchSpace;
    }

    @Override
    public LinkedHashMap<String, Object> getParamSettings() {
        LinkedHashMap<String, Object> paramSettings = new LinkedHashMap<String, Object>();
        int i = 0;
        for (ParameterSpec p : this.searchSpace.getParamSpecs()) {
            double dVal = this.dVals[i++];
            if (p.choiceCount() < 0) {
                if (p instanceof DoubleContinuousSpec) {
                    DoubleContinuousSpec dspec = (DoubleContinuousSpec)p;
                    double paramVal = dspec.enforceValidRange(dVal * (dspec.getMax() - dspec.getMin()) + dspec.getMin());
                    paramSettings.put(p.getParameterName(), paramVal);
                    continue;
                }
                throw new IllegalStateException("Unknown real-valued parameter specification - this type of Chromosomal representation can't handle it.");
            }
            long choice = (long)StrictMath.floor(dVal * (double)p.choiceCount());
            Object paramVal = p.getValueFromChoice(choice, p.choiceCount());
            paramSettings.put(p.getParameterName(), paramVal);
        }
        return paramSettings;
    }

    @Override
    public RealHypercubeChromosome clone() {
        return new RealHypercubeChromosome(this.dVals, this.searchSpace);
    }

    @Override
    public RealHypercubeChromosome mutate(double mutRate, MersenneTwisterFast rng) {
        RealHypercubeChromosome rhc = this.clone();
        for (int i = 0; i < this.dVals.length; ++i) {
            if (!(rng.nextDouble() < mutRate)) continue;
            double newVal = this.dVals[i] + 0.1 * rng.nextGaussian();
            if (newVal < 0.0 || newVal >= 1.0) {
                newVal -= StrictMath.floor(newVal);
            }
            rhc.dVals[i] = newVal;
        }
        return rhc;
    }

    @Override
    public Chromosome[] crossoverWith(Chromosome other, MersenneTwisterFast rng) {
        if (!(other instanceof RealHypercubeChromosome)) {
            throw new IllegalStateException("Can't crossover different types of Chromosomes.");
        }
        RealHypercubeChromosome parent0 = this;
        RealHypercubeChromosome parent1 = (RealHypercubeChromosome)other;
        Chromosome[] children = new RealHypercubeChromosome[]{parent0.clone(), parent1.clone()};
        int len = parent1.dVals.length - 1;
        int splitPoint = len > 0 ? 1 + rng.nextInt(len) : 0;
        for (int i = 0; i < len; ++i) {
            if (i < splitPoint) continue;
            ((RealHypercubeChromosome)children[0]).dVals[i] = parent1.dVals[i];
            ((RealHypercubeChromosome)children[1]).dVals[i] = parent0.dVals[i];
        }
        return children;
    }

    @Override
    public SearchSpace getSearchSpace() {
        return this.searchSpace;
    }

    public boolean equals(Object other) {
        if (other instanceof RealHypercubeChromosome) {
            RealHypercubeChromosome dc = (RealHypercubeChromosome)other;
            return Arrays.equals(this.dVals, dc.dVals);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        double[] dArray = this.dVals;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray[i];
            hashCode = hashCode * 2 + d.hashCode();
        }
        return hashCode;
    }

    public static class Factory
    implements ChromosomeFactory {
        @Override
        public Chromosome createChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
            return new RealHypercubeChromosome(searchSpace, rng);
        }

        @Override
        public Chromosome createChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
            return new RealHypercubeChromosome(searchSpace, paramSettings);
        }

        @Override
        public String getHTMLHelpText() {
            return "<strong>RealHypercubeChromosome</strong> In this encoding, every parameter (numeric or not) is represented by a <I>real-valued</I> continuous variable.  This encoding exists mainly to facilitate the (future) use of algorithms that assume a continuous numeric space (such as Particle Swarm Optimization), and allow them to be applied even when some of the model parameters are not numeric.";
        }
    }
}

