/*
 * Decompiled with CFR 0.152.
 */
package bsearch.space;

import bsearch.space.ParameterSpec;
import java.util.ArrayList;
import java.util.List;

public class SearchSpace {
    private final ArrayList<ParameterSpec> paramSpecs = new ArrayList();

    public SearchSpace(List<String> paramSpecStrings, Boolean is3d) {
        for (String spec : paramSpecStrings) {
            if (spec.trim().length() <= 0) continue;
            this.addParamSpec(ParameterSpec.fromString(spec, is3d));
        }
    }

    public List<ParameterSpec> getParamSpecs() {
        return this.paramSpecs;
    }

    private void addParamSpec(ParameterSpec pspec) {
        this.paramSpecs.add(pspec);
    }

    public long size() {
        long size = 1L;
        for (ParameterSpec p : this.paramSpecs) {
            long n = p.choiceCount();
            if (n < 0L) {
                return -1L;
            }
            size *= n;
        }
        return size;
    }

    public String sizeText() {
        long size = 1L;
        int continuousCount = 0;
        for (ParameterSpec p : this.paramSpecs) {
            long n = p.choiceCount();
            if (n < 0L) {
                ++continuousCount;
                continue;
            }
            size *= n;
        }
        Object text = Long.toString(size);
        if (continuousCount > 0) {
            text = (String)text + "* R^" + continuousCount;
        }
        return text;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ParameterSpec p : this.paramSpecs) {
            sb.append(p.toString() + "\n");
        }
        return sb.toString();
    }
}

