/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled2;

import java.io.Serializable;
import java.util.Arrays;
import org.parboiled2.CharPredicate$;
import org.parboiled2.CharPredicate$ApplyMagnet$;
import org.parboiled2.CharPredicate$General$;
import org.parboiled2.CharPredicate$MaskBased$;
import scala.Char$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class CharPredicate {
    public static CharPredicate All() {
        return CharPredicate$.MODULE$.All();
    }

    public static CharPredicate Alpha() {
        return CharPredicate$.MODULE$.Alpha();
    }

    public static CharPredicate AlphaNum() {
        return CharPredicate$.MODULE$.AlphaNum();
    }

    public static CharPredicate Digit() {
        return CharPredicate$.MODULE$.Digit();
    }

    public static CharPredicate Digit19() {
        return CharPredicate$.MODULE$.Digit19();
    }

    public static CharPredicate Empty() {
        return CharPredicate$.MODULE$.Empty();
    }

    public static CharPredicate HexDigit() {
        return CharPredicate$.MODULE$.HexDigit();
    }

    public static CharPredicate HexLetter() {
        return CharPredicate$.MODULE$.HexLetter();
    }

    public static CharPredicate LowerAlpha() {
        return CharPredicate$.MODULE$.LowerAlpha();
    }

    public static CharPredicate LowerHexLetter() {
        return CharPredicate$.MODULE$.LowerHexLetter();
    }

    public static CharPredicate Printable() {
        return CharPredicate$.MODULE$.Printable();
    }

    public static CharPredicate UpperAlpha() {
        return CharPredicate$.MODULE$.UpperAlpha();
    }

    public static CharPredicate UpperHexLetter() {
        return CharPredicate$.MODULE$.UpperHexLetter();
    }

    public static CharPredicate Visible() {
        return CharPredicate$.MODULE$.Visible();
    }

    public static CharPredicate from(Function1<Object, Object> function1) {
        return CharPredicate$.MODULE$.from(function1);
    }

    public abstract boolean apply(char var1);

    public boolean isMaskBased() {
        return this instanceof MaskBased;
    }

    public MaskBased asMaskBased() {
        CharPredicate charPredicate = this;
        if (charPredicate instanceof MaskBased) {
            MaskBased x = (MaskBased)charPredicate;
            return x;
        }
        throw scala.sys.package$.MODULE$.error("CharPredicate is not MaskBased");
    }

    public abstract CharPredicate $plus$plus(CharPredicate var1);

    public abstract CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> var1);

    public abstract CharPredicate $minus$minus(CharPredicate var1);

    public abstract CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> var1);

    public CharPredicate $plus$plus(char c) {
        return this.$plus$plus((scala.collection.immutable.Seq<Object>)package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    public CharPredicate $minus$minus(char c) {
        return this.$minus$minus((scala.collection.immutable.Seq<Object>)package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    public CharPredicate $plus$plus(String chars) {
        return this.$plus$plus((scala.collection.immutable.Seq<Object>)Predef$.MODULE$.wrapString(chars).toIndexedSeq());
    }

    public CharPredicate $minus$minus(String chars) {
        return this.$minus$minus((scala.collection.immutable.Seq<Object>)Predef$.MODULE$.wrapString(chars).toIndexedSeq());
    }

    public abstract CharPredicate intersect(CharPredicate var1);

    public CharPredicate negated() {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        CharPredicate charPredicate3 = charPredicate;
        if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
            return CharPredicate$.MODULE$.All();
        }
        CharPredicate charPredicate4 = CharPredicate$.MODULE$.All();
        CharPredicate charPredicate5 = charPredicate;
        if (!(charPredicate4 != null ? !charPredicate4.equals(charPredicate5) : charPredicate5 != null)) {
            return CharPredicate$.MODULE$.Empty();
        }
        CharPredicate x = charPredicate;
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> CharPredicate.negated$$anonfun$1(x, BoxesRunTime.unboxToChar((Object)c)));
    }

    public boolean matchesAny(String string) {
        return this.rec$1(string, 0);
    }

    public boolean matchesAll(String string) {
        return this.rec$2(string, 0);
    }

    public int indexOfFirstMatch(String string) {
        return this.rec$3(string, 0);
    }

    public int indexOfFirstMismatch(String string) {
        return this.rec$4(string, 0);
    }

    public Option<Object> firstMatch(String string) {
        int n = this.indexOfFirstMatch(string);
        if (-1 == n) {
            return None$.MODULE$;
        }
        int ix = n;
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)string.charAt(ix)));
    }

    public Option<Object> firstMismatch(String string) {
        int n = this.indexOfFirstMismatch(string);
        if (-1 == n) {
            return None$.MODULE$;
        }
        int ix = n;
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)string.charAt(ix)));
    }

    public CharPredicate or(CharPredicate that) {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        if (!(charPredicate != null ? !charPredicate.equals(charPredicate2) : charPredicate2 != null)) {
            return that;
        }
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.or$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
    }

    public CharPredicate and(CharPredicate that) {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        if (!(charPredicate != null ? !charPredicate.equals(charPredicate2) : charPredicate2 != null)) {
            return CharPredicate$.MODULE$.Empty();
        }
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.and$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
    }

    public CharPredicate andNot(CharPredicate that) {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        if (!(charPredicate != null ? !charPredicate.equals(charPredicate2) : charPredicate2 != null)) {
            return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> CharPredicate.andNot$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
        }
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.andNot$$anonfun$2(that, BoxesRunTime.unboxToChar((Object)c)));
    }

    private static final /* synthetic */ boolean negated$$anonfun$1(CharPredicate x$1, char c) {
        return !x$1.apply(c);
    }

    private final boolean rec$1(String string$1, int ix) {
        while (ix != string$1.length()) {
            if (this.apply(string$1.charAt(ix))) {
                return true;
            }
            ++ix;
        }
        return false;
    }

    private final boolean rec$2(String string$2, int ix) {
        while (ix != string$2.length()) {
            if (!this.apply(string$2.charAt(ix))) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    private final int rec$3(String string$3, int ix) {
        while (ix != string$3.length()) {
            if (this.apply(string$3.charAt(ix))) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    private final int rec$4(String string$4, int ix) {
        while (true) {
            if (ix == string$4.length()) {
                return -1;
            }
            if (!this.apply(string$4.charAt(ix))) break;
            ++ix;
        }
        return ix;
    }

    private final /* synthetic */ boolean or$$anonfun$1(CharPredicate that$1, char c) {
        return this.apply(c) || that$1.apply(c);
    }

    private final /* synthetic */ boolean and$$anonfun$1(CharPredicate that$2, char c) {
        return this.apply(c) && that$2.apply(c);
    }

    private static final /* synthetic */ boolean andNot$$anonfun$1(CharPredicate that$3, char c) {
        return !that$3.apply(c);
    }

    private final /* synthetic */ boolean andNot$$anonfun$2(CharPredicate that$4, char c) {
        return this.apply(c) && !that$4.apply(c);
    }

    public static class ApplyMagnet {
        private final CharPredicate predicate;

        public static ApplyMagnet fromChar(char c) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromChar(c);
        }

        public static ApplyMagnet fromCharArray(char[] cArray) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromCharArray(cArray);
        }

        public static ApplyMagnet fromChars(scala.collection.immutable.Seq<Object> seq) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromChars(seq);
        }

        public static ApplyMagnet fromPredicate(CharPredicate charPredicate) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromPredicate(charPredicate);
        }

        public static ApplyMagnet fromPredicate(Function1<Object, Object> function1) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromPredicate(function1);
        }

        public static ApplyMagnet fromString(String string) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromString(string);
        }

        public ApplyMagnet(CharPredicate predicate) {
            this.predicate = predicate;
        }

        public CharPredicate predicate() {
            return this.predicate;
        }
    }

    public static class ArrayBased
    extends CharPredicate {
        private final char[] chars;

        public ArrayBased(char[] chars) {
            this.chars = chars;
            Arrays.sort(chars);
        }

        private char[] chars() {
            return this.chars;
        }

        @Override
        public boolean apply(char c) {
            return Arrays.binarySearch(this.chars(), c) >= 0;
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof ArrayBased) {
                ArrayBased x = (ArrayBased)charPredicate;
                Object object = Predef$.MODULE$.charArrayOps(x.chars());
                return this.$plus$plus((scala.collection.immutable.Seq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(object));
            }
            return this.or(that);
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                Object object = Predef$.MODULE$.charArrayOps(super.chars());
                return new ArrayBased((char[])ArrayOps$.MODULE$.$plus$plus$extension(object, other.toArray(ClassTag$.MODULE$.apply(Character.TYPE)), ClassTag$.MODULE$.apply(Character.TYPE)));
            }
            return this;
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof ArrayBased) {
                ArrayBased x = (ArrayBased)charPredicate;
                Object object = Predef$.MODULE$.charArrayOps(x.chars());
                return this.$minus$minus((scala.collection.immutable.Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object));
            }
            return this.andNot(that);
        }

        @Override
        public ArrayBased $minus$minus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                char[] otherChars = (char[])other.toArray(ClassTag$.MODULE$.apply(Character.TYPE));
                Object object = Predef$.MODULE$.charArrayOps(this.chars());
                return new ArrayBased((char[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$2 -> this.$minus$minus$$anonfun$2(otherChars, BoxesRunTime.unboxToChar((Object)_$2))));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            if (charPredicate instanceof ArrayBased) {
                ArrayBased x = (ArrayBased)charPredicate;
                Object object = Predef$.MODULE$.charArrayOps(this.chars());
                return new ArrayBased((char[])ArrayOps$.MODULE$.intersect$extension(object, (Seq)Predef$.MODULE$.wrapCharArray(x.chars())));
            }
            return this.and(that);
        }

        public String toString() {
            return new StringBuilder(36).append("CharPredicate.ArrayBased(").append(new String(this.chars())).append(')').toString();
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$2(char[] otherChars$1, char _$2) {
            return Arrays.binarySearch(otherChars$1, _$2) < 0;
        }
    }

    public static class General
    extends CharPredicate
    implements Product,
    Serializable {
        private final Function1 predicate;

        public static General fromProduct(Product product) {
            return CharPredicate$General$.MODULE$.fromProduct(product);
        }

        public static General unapply(General general) {
            return CharPredicate$General$.MODULE$.unapply(general);
        }

        public General(Function1<Object, Object> predicate) {
            this.predicate = predicate;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof General)) return false;
            General general = (General)object;
            Function1<Object, Object> function1 = this.predicate();
            Function1<Object, Object> function12 = general.predicate();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!general.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof General;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "General";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "predicate";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Object, Object> predicate() {
            return this.predicate;
        }

        @Override
        public boolean apply(char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c)));
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof General) {
                Function1<Object, Object> function1;
                General general = CharPredicate$General$.MODULE$.unapply((General)charPredicate);
                Function1<Object, Object> thatPredicate = function1 = general._1();
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$plus$plus$$anonfun$2(thatPredicate, BoxesRunTime.unboxToChar((Object)c)));
            }
            return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$plus$plus$$anonfun$3(that, BoxesRunTime.unboxToChar((Object)c)));
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> chars) {
            if (chars.nonEmpty()) {
                ArrayBased abp = new ArrayBased((char[])chars.toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$plus$plus$$anonfun$4(abp, BoxesRunTime.unboxToChar((Object)c)));
            }
            return this;
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof General) {
                Function1<Object, Object> function1;
                General general = CharPredicate$General$.MODULE$.unapply((General)charPredicate);
                Function1<Object, Object> thatPredicate = function1 = general._1();
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$minus$minus$$anonfun$3(thatPredicate, BoxesRunTime.unboxToChar((Object)c)));
            }
            return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$minus$minus$$anonfun$4(that, BoxesRunTime.unboxToChar((Object)c)));
        }

        @Override
        public CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> chars) {
            if (chars.nonEmpty()) {
                ArrayBased abp = new ArrayBased((char[])chars.toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$minus$minus$$anonfun$5(abp, BoxesRunTime.unboxToChar((Object)c)));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            if (charPredicate instanceof General) {
                Function1<Object, Object> function1;
                General general = CharPredicate$General$.MODULE$.unapply((General)charPredicate);
                Function1<Object, Object> thatPredicate = function1 = general._1();
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.intersect$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
            }
            return this.and(that);
        }

        public String toString() {
            return new StringBuilder(22).append("CharPredicate.General@").append(System.identityHashCode(this)).toString();
        }

        public General copy(Function1<Object, Object> predicate) {
            return new General(predicate);
        }

        public Function1<Object, Object> copy$default$1() {
            return this.predicate();
        }

        public Function1<Object, Object> _1() {
            return this.predicate();
        }

        private final /* synthetic */ boolean $plus$plus$$anonfun$2(Function1 thatPredicate$1, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) || BoxesRunTime.unboxToBoolean((Object)thatPredicate$1.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
        }

        private final /* synthetic */ boolean $plus$plus$$anonfun$3(CharPredicate that$5, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) || that$5.apply(c);
        }

        private final /* synthetic */ boolean $plus$plus$$anonfun$4(ArrayBased abp$1, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) || abp$1.apply(c);
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$3(Function1 thatPredicate$2, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && !BoxesRunTime.unboxToBoolean((Object)thatPredicate$2.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$4(CharPredicate that$6, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && !that$6.apply(c);
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$5(ArrayBased abp$2, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && !abp$2.apply(c);
        }

        private final /* synthetic */ boolean intersect$$anonfun$1(CharPredicate that$7, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && that$7.apply(c);
        }
    }

    public static class MaskBased
    extends CharPredicate
    implements Product,
    Serializable {
        private final long lowMask;
        private final long highMask;

        public static MaskBased fromProduct(Product product) {
            return CharPredicate$MaskBased$.MODULE$.fromProduct(product);
        }

        public static MaskBased unapply(MaskBased maskBased) {
            return CharPredicate$MaskBased$.MODULE$.unapply(maskBased);
        }

        public MaskBased(long lowMask, long highMask) {
            this.lowMask = lowMask;
            this.highMask = highMask;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lowMask()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.highMask()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MaskBased)) return false;
            MaskBased maskBased = (MaskBased)object;
            if (this.lowMask() != maskBased.lowMask()) return false;
            if (this.highMask() != maskBased.highMask()) return false;
            if (!maskBased.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MaskBased;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MaskBased";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lowMask";
            }
            if (1 == n2) {
                return "highMask";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long lowMask() {
            return this.lowMask;
        }

        public long highMask() {
            return this.highMask;
        }

        @Override
        public boolean apply(char c) {
            long mask = c < '@' ? this.lowMask() : this.highMask();
            return (1L << Char$.MODULE$.char2int(c) & (long)(c - 128 >> 31) & mask) != 0L;
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            MaskBased maskBased = this;
            CharPredicate charPredicate4 = CharPredicate$.MODULE$.Empty();
            if (!(maskBased != null ? !((Object)maskBased).equals(charPredicate4) : charPredicate4 != null)) {
                return that;
            }
            if (charPredicate instanceof MaskBased) {
                MaskBased maskBased2 = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                long l = maskBased2._1();
                long l2 = maskBased2._2();
                long low = l;
                long high = l2;
                return CharPredicate$MaskBased$.MODULE$.apply(this.lowMask() | low, this.highMask() | high);
            }
            return this.or(that);
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> chars) {
            return (CharPredicate)chars.foldLeft((Object)this, (Function2 & Serializable)(x$1, x$2) -> this.$plus$plus$$anonfun$1(chars, (CharPredicate)x$1, BoxesRunTime.unboxToChar((Object)x$2)));
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            MaskBased maskBased = this;
            CharPredicate charPredicate4 = CharPredicate$.MODULE$.Empty();
            if (!(maskBased != null ? !((Object)maskBased).equals(charPredicate4) : charPredicate4 != null)) {
                return this;
            }
            if (charPredicate instanceof MaskBased) {
                MaskBased maskBased2 = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                long l = maskBased2._1();
                long l2 = maskBased2._2();
                long low = l;
                long high = l2;
                return CharPredicate$MaskBased$.MODULE$.apply(this.lowMask() & (low ^ 0xFFFFFFFFFFFFFFFFL), this.highMask() & (high ^ 0xFFFFFFFFFFFFFFFFL));
            }
            return this.andNot(that);
        }

        @Override
        public CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> chars) {
            MaskBased maskBased = this;
            CharPredicate charPredicate = CharPredicate$.MODULE$.Empty();
            if (maskBased == null ? charPredicate != null : !((Object)maskBased).equals(charPredicate)) {
                return (CharPredicate)chars.foldLeft((Object)this, (Function2 & Serializable)(x$1, x$2) -> this.$minus$minus$$anonfun$1(chars, (CharPredicate)x$1, BoxesRunTime.unboxToChar((Object)x$2)));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            MaskBased maskBased = this;
            CharPredicate charPredicate4 = CharPredicate$.MODULE$.Empty();
            if (!(maskBased != null ? !((Object)maskBased).equals(charPredicate4) : charPredicate4 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            if (charPredicate instanceof MaskBased) {
                MaskBased maskBased2 = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                long l = maskBased2._1();
                long l2 = maskBased2._2();
                long low = l;
                long high = l2;
                return CharPredicate$MaskBased$.MODULE$.apply(this.lowMask() & low, this.highMask() & high);
            }
            return this.and(that);
        }

        public int size() {
            return Long.bitCount(this.lowMask()) + Long.bitCount(this.highMask());
        }

        public char[] toArray() {
            char[] array = new char[this.size()];
            this.getChars(array, 0);
            return array;
        }

        public void getChars(char[] array, int startIx) {
            this.rec$6(array, this.highMask(), 64, Long.numberOfTrailingZeros(this.highMask()), this.rec$6(array, this.lowMask(), 0, Long.numberOfTrailingZeros(this.lowMask()), startIx));
        }

        public String toString() {
            return new StringBuilder(35).append("CharPredicate.MaskBased(").append(new String(this.toArray())).append(')').toString();
        }

        public MaskBased copy(long lowMask, long highMask) {
            return new MaskBased(lowMask, highMask);
        }

        public long copy$default$1() {
            return this.lowMask();
        }

        public long copy$default$2() {
            return this.highMask();
        }

        public long _1() {
            return this.lowMask();
        }

        public long _2() {
            return this.highMask();
        }

        private final /* synthetic */ CharPredicate $plus$plus$$anonfun$1(scala.collection.immutable.Seq chars$2, CharPredicate x$1, char x$2) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
            if (tuple2 != null) {
                CharPredicate charPredicate = (CharPredicate)tuple2._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
                if (charPredicate instanceof MaskBased) {
                    char c2 = c;
                    if (CharPredicate$.MODULE$.org$parboiled2$CharPredicate$$$unmaskable(c2)) {
                        return new ArrayBased((char[])chars$2.toArray(ClassTag$.MODULE$.apply(Character.TYPE))).$plus$plus(new ArrayBased(this.toArray()));
                    }
                    MaskBased maskBased = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                    long l = maskBased._1();
                    long l2 = maskBased._2();
                    long low = l;
                    long high = l2;
                    char c3 = c;
                    if (c3 < '@') {
                        return CharPredicate$MaskBased$.MODULE$.apply(low | 1L << Char$.MODULE$.char2int(c3), high);
                    }
                    long low2 = l;
                    long high2 = l2;
                    char c4 = c;
                    return CharPredicate$MaskBased$.MODULE$.apply(low2, high2 | 1L << Char$.MODULE$.char2int(c4));
                }
                CharPredicate x = charPredicate;
                return x;
            }
            throw new MatchError((Object)tuple2);
        }

        private final /* synthetic */ CharPredicate $minus$minus$$anonfun$1(scala.collection.immutable.Seq chars$3, CharPredicate x$1, char x$2) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
            if (tuple2 != null) {
                CharPredicate charPredicate = (CharPredicate)tuple2._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
                if (charPredicate instanceof MaskBased) {
                    char c2 = c;
                    if (CharPredicate$.MODULE$.org$parboiled2$CharPredicate$$$unmaskable(c2)) {
                        return this.andNot(new ArrayBased((char[])chars$3.toArray(ClassTag$.MODULE$.apply(Character.TYPE))));
                    }
                    MaskBased maskBased = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                    long l = maskBased._1();
                    long l2 = maskBased._2();
                    long low = l;
                    long high = l2;
                    char c3 = c;
                    if (c3 < '@') {
                        return CharPredicate$MaskBased$.MODULE$.apply(low & (1L << Char$.MODULE$.char2int(c3) ^ 0xFFFFFFFFFFFFFFFFL), high);
                    }
                    long low2 = l;
                    long high2 = l2;
                    char c4 = c;
                    return CharPredicate$MaskBased$.MODULE$.apply(low2, high2 & (1L << Char$.MODULE$.char2int(c4) ^ 0xFFFFFFFFFFFFFFFFL));
                }
                CharPredicate x = charPredicate;
                return x;
            }
            throw new MatchError((Object)tuple2);
        }

        private final int rec$6(char[] array$1, long mask, int offset, int bit, int ix) {
            while (bit < 64 && ix < array$1.length) {
                if ((mask & 1L << bit) > 0L) {
                    array$1[ix] = (char)(offset + bit);
                    int n = bit + 1;
                    int n2 = ix + 1;
                    bit = n;
                    ix = n2;
                    continue;
                }
                ++bit;
            }
            return ix;
        }
    }

    public static class RangeBased
    extends CharPredicate {
        private final NumericRange range;

        public RangeBased(NumericRange<Object> range) {
            this.range = range;
        }

        private NumericRange<Object> range() {
            return this.range;
        }

        @Override
        public boolean apply(char c) {
            return this.range().contains((Object)BoxesRunTime.boxToCharacter((char)c));
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            return this.or(that);
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                return this.$plus$plus(CharPredicate$.MODULE$.apply((scala.collection.immutable.Seq<ApplyMagnet>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApplyMagnet[]{CharPredicate$ApplyMagnet$.MODULE$.fromChars(other)})));
            }
            return this;
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            return this.andNot(that);
        }

        @Override
        public CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                return this.$minus$minus(CharPredicate$.MODULE$.apply((scala.collection.immutable.Seq<ApplyMagnet>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApplyMagnet[]{CharPredicate$ApplyMagnet$.MODULE$.fromChars(other)})));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            return this.and(that);
        }

        public String toString() {
            return new StringBuilder(43).append("CharPredicate.RangeBased(start = ").append(this.range().start()).append(", end = ").append(this.range().end()).append(", ").append(new StringBuilder(22).append("step = ").append((int)BoxesRunTime.unboxToChar((Object)this.range().step())).append(", inclusive = ").append(this.range().isInclusive()).append(")").toString()).toString();
        }
    }
}

