/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled2;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.parboiled2.ParserInput$;
import org.parboiled2.ParserInput$ByteArrayBasedParserInput$;
import org.parboiled2.ParserInput$CharArrayBasedParserInput$;
import org.parboiled2.package$;

public interface ParserInput {
    public static ByteArrayBasedParserInput Empty() {
        return ParserInput$.MODULE$.Empty();
    }

    public static ByteArrayBasedParserInput apply(byte[] byArray) {
        return ParserInput$.MODULE$.apply(byArray);
    }

    public static ByteArrayBasedParserInput apply(byte[] byArray, int n) {
        return ParserInput$.MODULE$.apply(byArray, n);
    }

    public static CharArrayBasedParserInput apply(char[] cArray) {
        return ParserInput$.MODULE$.apply(cArray);
    }

    public static CharArrayBasedParserInput apply(char[] cArray, int n) {
        return ParserInput$.MODULE$.apply(cArray, n);
    }

    public static StringBasedParserInput apply(String string) {
        return ParserInput$.MODULE$.apply(string);
    }

    public char charAt(int var1);

    public int length();

    public String sliceString(int var1, int var2);

    public char[] sliceCharArray(int var1, int var2);

    public String getLine(int var1);

    public static class ByteArrayBasedParserInput
    extends DefaultParserInput {
        private final byte[] bytes;
        private final int length;

        public static int $lessinit$greater$default$2() {
            return ParserInput$ByteArrayBasedParserInput$.MODULE$.$lessinit$greater$default$2();
        }

        public ByteArrayBasedParserInput(byte[] bytes, int endIndex) {
            this.bytes = bytes;
            this.length = endIndex <= 0 || endIndex > bytes.length ? bytes.length : endIndex;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int ix) {
            return (char)(this.bytes[ix] & 0xFF);
        }

        @Override
        public String sliceString(int start, int end) {
            return new String(this.bytes, start, scala.math.package$.MODULE$.max(end - start, 0), package$.MODULE$.ISO$minus8859$minus1());
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            return package$.MODULE$.ISO$minus8859$minus1().decode(ByteBuffer.wrap(Arrays.copyOfRange(this.bytes, start, end))).array();
        }
    }

    public static class CharArrayBasedParserInput
    extends DefaultParserInput {
        private final char[] chars;
        private final int length;

        public static int $lessinit$greater$default$2() {
            return ParserInput$CharArrayBasedParserInput$.MODULE$.$lessinit$greater$default$2();
        }

        public CharArrayBasedParserInput(char[] chars, int endIndex) {
            this.chars = chars;
            this.length = endIndex <= 0 || endIndex > chars.length ? chars.length : endIndex;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int ix) {
            return this.chars[ix];
        }

        @Override
        public String sliceString(int start, int end) {
            return new String(this.chars, start, scala.math.package$.MODULE$.max(end - start, 0));
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            return Arrays.copyOfRange(this.chars, start, end);
        }
    }

    public static abstract class DefaultParserInput
    implements ParserInput {
        @Override
        public String getLine(int line) {
            return this.rec$1(line, 0, 0, 1);
        }

        private final String rec$1(int line$1, int ix, int lineStartIx, int lineNr) {
            while (ix < this.length()) {
                if (this.charAt(ix) == '\n') {
                    if (lineNr < line$1) {
                        int n = ix + 1;
                        int n2 = ix + 1;
                        int n3 = lineNr + 1;
                        ix = n;
                        lineStartIx = n2;
                        lineNr = n3;
                        continue;
                    }
                    return this.sliceString(lineStartIx, ix);
                }
                ++ix;
            }
            if (lineNr == line$1) {
                return this.sliceString(lineStartIx, ix);
            }
            return "";
        }
    }

    public static class StringBasedParserInput
    extends DefaultParserInput {
        private final String string;

        public StringBasedParserInput(String string) {
            this.string = string;
        }

        @Override
        public char charAt(int ix) {
            return this.string.charAt(ix);
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public String sliceString(int start, int end) {
            return this.string.substring(start, scala.math.package$.MODULE$.min(end, this.string.length()));
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            char[] chars = new char[end - start];
            this.string.getChars(start, end, chars, 0);
            return chars;
        }
    }
}

