/*
 * Decompiled with CFR 0.152.
 */
package view25d.prims;

import org.nlogo.api.AgentException;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.api.World;
import org.nlogo.app.App$;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import view25d.View25DExtension$;
import view25d.view.PatchView;
import view25d.view.PatchViewGUI;
import view25d.view.PatchViewHeadless;

public class MakePatchView
implements Command {
    public Syntax getSyntax() {
        List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.ReporterType()), (List)Nil$.MODULE$));
        Option option = Syntax$.MODULE$.commandSyntax$default$2();
        Option option2 = Syntax$.MODULE$.commandSyntax$default$3();
        Option option3 = Syntax$.MODULE$.commandSyntax$default$5();
        boolean bl = Syntax$.MODULE$.commandSyntax$default$6();
        boolean bl2 = Syntax$.MODULE$.commandSyntax$default$7();
        return Syntax$.MODULE$.commandSyntax(list, option, option2, "O---", option3, bl, bl2);
    }

    public void perform(Argument[] args, Context context) {
        String title = args[0].getString().trim();
        if (title.isEmpty()) {
            throw new ExtensionException("Window title cannot be empty.\nThis is the identifier for your window");
        }
        AnonymousReporter patchReporter = args[1].getReporter();
        try {
            patchReporter.report(context, new Object[]{App$.MODULE$.app().workspace().world().getPatchAt(0.0, 0.0)});
        }
        catch (AgentException e) {
            throw new ExtensionException("Error in accessing patches. " + e);
        }
        catch (Throwable t) {
            throw new ExtensionException("Error in processing your reporter. " + t);
        }
        context.workspace().updateUI();
        PatchView newPatchView = (PatchView)context.workspace().waitForResult((ReporterRunnable)new InitPatchView(context, title, patchReporter));
        if (newPatchView != null) {
            View25DExtension$.MODULE$.storePatchWindowWithTitle(title, newPatchView);
            return;
        }
    }

    public class InitPatchView
    implements ReporterRunnable<PatchView> {
        private final Context context;
        private final String title;
        private final AnonymousReporter patchReporter;

        public InitPatchView(Context context, String title, AnonymousReporter patchReporter) {
            this.context = context;
            this.title = title;
            this.patchReporter = patchReporter;
        }

        public PatchView run() {
            try {
                PatchView manualPatchView = !this.context.workspace().isHeadless() ? new PatchViewGUI(this.title, this.patchReporter) : new PatchViewHeadless(this.title, this.patchReporter);
                World world = this.context.world();
                manualPatchView.setupForRendering(world.worldWidth(), world.worldHeight(), world.minPxcor(), world.maxPxcor(), world.minPycor(), world.maxPycor());
                manualPatchView.manuallyRefreshReporterView(this.context);
                manualPatchView.setVisible(true);
                return manualPatchView;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }
}

