/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GL2;
import org.nlogo.api.Constants$;
import scala.Predef$;
import scala.runtime.RichInt$;
import view25d.view.VarviewWindow;

public class Observer {
    private double x;
    private double y;
    private double z;
    private double heading;
    private double pitch;
    private double rotx;
    private double roty;
    private double rotz;

    public Observer(double xs, double ys, double zs) {
        this.x = xs;
        this.y = ys;
        this.z = zs;
        this.heading = 0.0;
        this.pitch = 90.0;
        this.rotx = 0.0;
        this.roty = 0.0;
        this.rotz = 0.0;
    }

    public double heading() {
        return this.heading;
    }

    public void heading_$eq(double x$1) {
        this.heading = x$1;
    }

    public double pitch() {
        return this.pitch;
    }

    public void pitch_$eq(double x$1) {
        this.pitch = x$1;
    }

    public double rotx() {
        return this.rotx;
    }

    public void rotx_$eq(double x$1) {
        this.rotx = x$1;
    }

    public double roty() {
        return this.roty;
    }

    public void roty_$eq(double x$1) {
        this.roty = x$1;
    }

    public double rotz() {
        return this.rotz;
    }

    public void rotz_$eq(double x$1) {
        this.rotz = x$1;
    }

    public void goHome(VarviewWindow world) {
        this.x = (double)world.minPxcor() + (double)(world.maxPxcor() - world.minPxcor()) / 2.0;
        this.y = (double)world.minPycor() + (double)(world.maxPycor() - world.minPycor()) / 2.0;
        this.z = (double)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(world.worldWidth()), world.worldHeight()) * 1.5;
        this.heading_$eq(0.0);
        this.pitch_$eq(90.0);
        this.rotx_$eq(this.x);
        this.roty_$eq(this.y);
        this.rotz_$eq(0.0);
    }

    public void applyPerspective(GL2 gl) {
        gl.glRotated(90.0, -1.0, 0.0, 0.0);
        gl.glRotated(this.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(this.pitch(), Math.cos(Math.toRadians(this.heading())), -Math.sin(Math.toRadians(this.heading())), 0.0);
        gl.glTranslated(-this.x, -this.y, -this.z);
    }

    public void applyNormal(GL2 gl) {
        gl.glRotated(-this.heading(), this.x, this.y, this.z);
        gl.glRotated(this.pitch() - (double)90, this.y, -this.x, 0.0);
    }

    public void updatePerspectiveAngles(double delthetax, double delthetay) {
        this.orbitRight(delthetax);
        this.orbitUp(delthetay);
    }

    private void orbitRight(double delta) {
        this.heading_$eq(this.heading() + delta);
        if (this.heading() > (double)360) {
            this.heading_$eq(this.heading() - (double)360);
        } else if (this.heading() < 0.0) {
            this.heading_$eq(this.heading() + (double)360);
        }
        double dxy = this.dist() * Math.cos(Math.toRadians(this.pitch()));
        this.x = this.rotx() - dxy * Math.sin(Math.toRadians(this.heading()));
        this.y = this.roty() - dxy * Math.cos(Math.toRadians(this.heading()));
    }

    private void orbitUp(double delta) {
        double newPitch = this.pitch() - delta;
        double dxy = this.dist() * Math.cos(Math.toRadians(newPitch));
        double zn = this.dist() * Math.sin(Math.toRadians(newPitch));
        if (zn + this.rotz() > -this.dist() / 4.0 && newPitch < (double)90) {
            this.x = this.rotx() - dxy * Math.sin(Math.toRadians(this.heading()));
            this.y = this.roty() - dxy * Math.cos(Math.toRadians(this.heading()));
            this.z = this.rotz() + zn;
            this.pitch_$eq(newPitch);
            return;
        }
    }

    public void shift(double deltax, double deltay) {
        double sinH = Math.sin(Math.toRadians(this.heading()));
        double cosH = Math.cos(Math.toRadians(this.heading()));
        this.objectiveShift(-(cosH * deltax + sinH * deltay) * 0.1, (sinH * deltax - cosH * deltay) * 0.1);
    }

    public void objectiveShift(double delx, double dely) {
        this.x += delx;
        this.y += dely;
        this.rotx_$eq(this.rotx() + delx);
        this.roty_$eq(this.roty() + dely);
    }

    public void zoomToDistance(double distance) {
        double ratio = distance / this.dist();
        this.x = this.rotx() + ratio * (this.x - this.rotx());
        this.y = this.roty() + ratio * (this.y - this.roty());
        this.z = this.rotz() + ratio * (this.z - this.rotz());
    }

    public void zoomby(double deltavert) {
        if (deltavert < this.dist()) {
            this.x += deltavert * this.dx();
            this.y += deltavert * this.dy();
            this.z -= deltavert * this.dz();
            return;
        }
    }

    public double dist() {
        return Math.sqrt((this.rotx() - this.x) * (this.rotx() - this.x) + (this.roty() - this.y) * (this.roty() - this.y) + (this.rotz() - this.z) * (this.rotz() - this.z));
    }

    private double dx() {
        double value = Math.cos(Math.toRadians(this.pitch())) * Math.sin(Math.toRadians(this.heading()));
        if (Math.abs(value) < Constants$.MODULE$.Infinitesimal()) {
            return 0.0;
        }
        return value;
    }

    private double dy() {
        double value = Math.cos(Math.toRadians(this.pitch())) * Math.cos(Math.toRadians(this.heading()));
        if (Math.abs(value) < Constants$.MODULE$.Infinitesimal()) {
            return 0.0;
        }
        return value;
    }

    private double dz() {
        double value = Math.sin(Math.toRadians(this.pitch()));
        if (Math.abs(value) < Constants$.MODULE$.Infinitesimal()) {
            return 0.0;
        }
        return value;
    }
}

