/*
 * Decompiled with CFR 0.152.
 */
package view25d.view.gl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.glu.GLUquadric;
import java.awt.Color;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import view25d.view.MouseableGLWindow;
import view25d.view.PatchValue;
import view25d.view.PatchViewGUI;
import view25d.view.gl.Compilables$;

public class PatchGL
extends MouseableGLWindow {
    private final PatchViewGUI viewer;
    private int patchTileListHandle;
    private int patchThickTileListHandle;
    private int patchStickListHandle;
    private int sphereDotListHandle;
    private int altThickPatchHandle;
    private int axisHeadHandle;
    private int patchDiskTileHandle;
    private int patchSkyscraperHandle;
    private int pinHeadListHandle;
    private GLUquadric quadric;

    public PatchGL(PatchViewGUI viewer) {
        this.viewer = viewer;
        super(viewer);
        this.patchTileListHandle = 0;
        this.patchThickTileListHandle = 0;
        this.patchStickListHandle = 0;
        this.sphereDotListHandle = 0;
        this.altThickPatchHandle = 0;
        this.axisHeadHandle = 0;
        this.patchDiskTileHandle = 0;
        this.patchSkyscraperHandle = 0;
        this.pinHeadListHandle = 0;
        this.quadric = null;
    }

    public GLUquadric quadric() {
        return this.quadric;
    }

    public void quadric_$eq(GLUquadric x$1) {
        this.quadric = x$1;
    }

    @Override
    public void setupCompiledDisplayLists(GL2 gl) {
        this.patchTileListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchTileListHandle, 4864);
        Compilables$.MODULE$.PatchTile(gl);
        gl.glEndList();
        this.patchStickListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchStickListHandle, 4864);
        Compilables$.MODULE$.PatchStickTile(gl, 10);
        gl.glEndList();
        this.patchThickTileListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchThickTileListHandle, 4864);
        Compilables$.MODULE$.ThickPatchTile(gl, 0.4f, 0.2f);
        gl.glEndList();
        this.sphereDotListHandle = gl.glGenLists(1);
        GLUquadric quadr = this.glu().gluNewQuadric();
        this.glu().gluQuadricDrawStyle(quadr, 100012);
        this.glu().gluQuadricNormals(quadr, 100000);
        float radius = 0.4f;
        int slices = 16;
        gl.glNewList(this.sphereDotListHandle, 4864);
        Compilables$.MODULE$.PinHead(gl, this.glu(), quadr, radius, slices);
        gl.glEndList();
        this.altThickPatchHandle = gl.glGenLists(1);
        gl.glNewList(this.altThickPatchHandle, 4864);
        Compilables$.MODULE$.ThickPatchTile(gl, 0.4f, 0.15f);
        Compilables$.MODULE$.PinHead(gl, this.glu(), quadr, 0.3f, slices);
        gl.glEndList();
        this.patchSkyscraperHandle = gl.glGenLists(1);
        gl.glNewList(this.patchSkyscraperHandle, 4864);
        Compilables$.MODULE$.box(gl, 0.4f, 1.0f);
        gl.glEndList();
        this.axisHeadHandle = gl.glGenLists(1);
        gl.glNewList(this.axisHeadHandle, 4864);
        Compilables$.MODULE$.AxisHead(gl, this.glu(), quadr, 1.3, slices);
        gl.glEndList();
        this.patchDiskTileHandle = gl.glGenLists(1);
        gl.glNewList(this.patchDiskTileHandle, 4864);
        Compilables$.MODULE$.DiskPatchTile(gl, this.glu(), quadr, 0.4, slices);
        gl.glEndList();
        this.pinHeadListHandle = gl.glGenLists(1);
        gl.glNewList(this.pinHeadListHandle, 4864);
        Compilables$.MODULE$.PinHead(gl, this.glu(), quadr, 0.6f, slices);
        gl.glEndList();
        this.nlGLU().setQuadric(quadr);
        this.compileShapes(gl, this.compiledShapes(), false);
        this.glu().gluDeleteQuadric(quadr);
    }

    public void display(GLAutoDrawable drawable) {
        GL2 gl = (GL2)drawable.getGL();
        if (this.areShapesStale()) {
            this.compileShapes(gl, this.compiledShapes(), false);
            this.setDeletedShapesToDefaultShape(this.compiledShapes());
            this.areShapesStale_$eq(false);
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glClear(16640);
        gl.glLineWidth(1.0f);
        this.setColorAndStandardMaterial(gl, 0.0f, 0.1f, 0.9f);
        gl.glPushMatrix();
        this.observer().applyPerspective(gl);
        if (this.viewer.viewOptions().tangents()) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldHeight()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                gl.glPushMatrix();
                gl.glTranslated(Int$.MODULE$.int2double(i + this.viewer.minPxcor()), Int$.MODULE$.int2double(j + this.viewer.minPycor()), -0.01);
                gl.glCallList(this.patchTileListHandle);
                gl.glPopMatrix();
            }));
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldHeight()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            gl.glPushMatrix();
            PatchValue pv = this.viewer.reporterValueMatrix()[i][j];
            double v = this.viewer.zScale() * pv.reporterValue();
            Color c = pv.color();
            gl.glTranslated(Int$.MODULE$.int2double(i + this.viewer.minPxcor()), Int$.MODULE$.int2double(j + this.viewer.minPycor()), v);
            if (this.viewer.viewOptions().sticks()) {
                this.setColorAndStandardMaterial(gl, 0.6f, 0.6f, 0.6f);
                gl.glLineWidth(0.1f);
                gl.glBegin(1);
                gl.glVertex3i(0, 0, 0);
                gl.glVertex3d(0.0, 0.0, -v);
                gl.glEnd();
            }
            this.setColorAndStandardMaterial(gl, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            if (this.viewer.viewOptions().tangents()) {
                if (j > 0 && j < this.viewer.worldHeight() - 1) {
                    double slopey = (this.viewer.reporterValueMatrix()[i][j + 1].reporterValue() - this.viewer.reporterValueMatrix()[i][j - 1].reporterValue()) * this.viewer.zScale() / 2.0;
                    double beta = 180.0 * Math.atan(slopey) / Math.PI;
                    gl.glRotated(beta, 1.0, 0.0, 0.0);
                }
                if (i > 0 && i < this.viewer.worldWidth() - 1) {
                    double slopex = (this.viewer.reporterValueMatrix()[i + 1][j].reporterValue() - this.viewer.reporterValueMatrix()[i - 1][j].reporterValue()) * this.viewer.zScale() / 2.0;
                    double alpha = 180.0 * Math.atan(slopex) / Math.PI;
                    gl.glRotated(-alpha, 0.0, 1.0, 0.0);
                }
                gl.glCallList(this.pinHeadListHandle);
            } else {
                gl.glTranslated(0.0, 0.0, -v);
                gl.glScaled(1.0, 1.0, v);
                gl.glCallList(this.patchSkyscraperHandle);
            }
            gl.glPopMatrix();
        }));
        if (this.viewer.viewOptions().structures()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.viewer.turtleValues());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)tv -> {
                gl.glPushMatrix();
                try {
                    this.setColorAndStandardMaterial(gl, (float)tv.color().getRed() / 255.0f, (float)tv.color().getGreen() / 255.0f, (float)tv.color().getBlue() / 255.0f);
                    double zval = this.viewer.zScale() * tv.reporterValue();
                    if (zval < 0.0) {
                        gl.glTranslated(tv.xcor(), tv.ycor(), zval - 0.045);
                    } else {
                        gl.glTranslated(tv.xcor(), tv.ycor(), zval + 0.045);
                    }
                    gl.glScaled(tv.size(), tv.size(), tv.size());
                    gl.glScaled(3.0, 3.0, 3.0);
                    gl.glRotated(-tv.heading(), 0.0, 0.0, 1.0);
                    gl.glCallList(BoxesRunTime.unboxToInt((Object)this.compiledShapes().apply((Object)tv.shape())));
                }
                catch (ConcurrentModificationException cme) {
                    cme.printStackTrace();
                    throw cme;
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    throw npe;
                }
                gl.glPopMatrix();
            });
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.viewer.linkValues());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)lv -> {
                double zval1 = 0.0;
                double zval2 = 0.0;
                if (this.viewer.viewOptions().linksAreThreeD()) {
                    zval1 = this.viewer.zScale() * lv.zcor1();
                    zval2 = this.viewer.zScale() * lv.zcor2();
                }
                Color c = lv.color();
                this.setColorAndStandardMaterial(gl, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
                gl.glLineWidth((float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(lv.thickness()), 0.1));
                gl.glBegin(1);
                gl.glVertex3d(lv.xcor1(), lv.ycor1(), zval1);
                gl.glVertex3d(lv.xcor2(), lv.ycor2(), zval2);
                gl.glEnd();
            });
        }
        this.drawAxesIfDragging(gl, this.axisHeadHandle);
        gl.glPopMatrix();
    }
}

