/*
 * Decompiled with CFR 0.152.
 */
package view25d.view.gl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.glu.GLUquadric;
import java.awt.Color;
import java.io.Serializable;
import org.nlogo.api.Color$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import view25d.view.MouseableGLWindow;
import view25d.view.TurtleViewGUI;
import view25d.view.gl.Compilables$;

public class TurtleGL
extends MouseableGLWindow {
    private final TurtleViewGUI viewer;
    private int patchTileListHandle;
    private int stemSkyscraperHandle;
    private int pinHeadListHandle;
    private int axisHeadHandle;
    private GLUquadric quadric;

    public TurtleGL(TurtleViewGUI viewer) {
        this.viewer = viewer;
        super(viewer);
        this.patchTileListHandle = 0;
        this.stemSkyscraperHandle = 0;
        this.pinHeadListHandle = 0;
        this.axisHeadHandle = 0;
        this.quadric = null;
    }

    public int patchTileListHandle() {
        return this.patchTileListHandle;
    }

    public void patchTileListHandle_$eq(int x$1) {
        this.patchTileListHandle = x$1;
    }

    public int stemSkyscraperHandle() {
        return this.stemSkyscraperHandle;
    }

    public void stemSkyscraperHandle_$eq(int x$1) {
        this.stemSkyscraperHandle = x$1;
    }

    public int pinHeadListHandle() {
        return this.pinHeadListHandle;
    }

    public void pinHeadListHandle_$eq(int x$1) {
        this.pinHeadListHandle = x$1;
    }

    public int axisHeadHandle() {
        return this.axisHeadHandle;
    }

    public void axisHeadHandle_$eq(int x$1) {
        this.axisHeadHandle = x$1;
    }

    public GLUquadric quadric() {
        return this.quadric;
    }

    public void quadric_$eq(GLUquadric x$1) {
        this.quadric = x$1;
    }

    @Override
    public void setupCompiledDisplayLists(GL2 gl) {
        this.patchTileListHandle_$eq(gl.glGenLists(1));
        gl.glNewList(this.patchTileListHandle(), 4864);
        Compilables$.MODULE$.PatchTile(gl);
        gl.glEndList();
        this.quadric_$eq(this.glu().gluNewQuadric());
        this.glu().gluQuadricDrawStyle(this.quadric(), 100012);
        this.glu().gluQuadricNormals(this.quadric(), 100000);
        this.nlGLU().setQuadric(this.quadric());
        this.stemSkyscraperHandle_$eq(gl.glGenLists(1));
        gl.glNewList(this.stemSkyscraperHandle(), 4864);
        Compilables$.MODULE$.ThickStem(gl, this.glu(), this.quadric(), 1.0, 6);
        gl.glEndList();
        this.pinHeadListHandle_$eq(gl.glGenLists(1));
        int slices = 16;
        gl.glNewList(this.pinHeadListHandle(), 4864);
        Compilables$.MODULE$.PinHead(gl, this.glu(), this.quadric(), 0.4f, slices);
        gl.glEndList();
        this.compileShapes(gl, this.compiledShapes(), false);
        this.axisHeadHandle_$eq(gl.glGenLists(1));
        gl.glNewList(this.axisHeadHandle(), 4864);
        Compilables$.MODULE$.AxisHead(gl, this.glu(), this.quadric(), 1.3, slices);
        gl.glEndList();
    }

    public void display(GLAutoDrawable drawable) {
        GL2 gl = (GL2)drawable.getGL();
        if (this.areShapesStale()) {
            this.compileShapes(gl, this.compiledShapes(), false);
            this.setDeletedShapesToDefaultShape(this.compiledShapes());
            this.areShapesStale_$eq(false);
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glClear(16640);
        gl.glLineWidth(1.0f);
        gl.glPushMatrix();
        this.observer().applyPerspective(gl);
        if (this.viewer.viewOptions().usePColor()) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldHeight()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                gl.glPushMatrix();
                gl.glTranslated(Int$.MODULE$.int2double(i + this.viewer.minPxcor()), Int$.MODULE$.int2double(j + this.viewer.minPycor()), 0.0);
                Color c = this.viewer.patchColorMatrix()[i][j];
                this.setColorAndStandardMaterial(gl, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
                gl.glCallList(this.patchTileListHandle());
                gl.glPopMatrix();
            }));
        } else {
            this.setColorAndStandardMaterial(gl, 0.1f, 0.1f, 1.0f);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.viewer.worldHeight()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                gl.glPushMatrix();
                gl.glTranslated(Int$.MODULE$.int2double(i + this.viewer.minPxcor()), Int$.MODULE$.int2double(j + this.viewer.minPycor()), 0.0);
                gl.glCallList(this.patchTileListHandle());
                gl.glPopMatrix();
            }));
        }
        double stemThickness = this.viewer.viewOptions().getStemThickness();
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.viewer.turtleReporterValues());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)tv -> {
            gl.glPushMatrix();
            double zval = this.viewer.zScale() * tv.reporterValue();
            gl.glTranslated(tv.xcor(), tv.ycor(), zval);
            Color c = Color$.MODULE$.getColor((Object)BoxesRunTime.boxToDouble((double)tv.stemColor()));
            this.setColorAndStandardMaterial(gl, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            if (stemThickness == 0.0) {
                gl.glLineWidth(0.1f);
                gl.glBegin(1);
                gl.glVertex3i(0, 0, 0);
                gl.glVertex3d(0.0, 0.0, -zval);
                gl.glEnd();
            } else {
                gl.glPushMatrix();
                gl.glTranslated(0.0, 0.0, -zval);
                gl.glScaled(stemThickness, stemThickness, zval);
                gl.glCallList(this.stemSkyscraperHandle());
                gl.glPopMatrix();
            }
            if (this.viewer.viewOptions().showSize()) {
                gl.glScaled(tv.size(), tv.size(), tv.size());
            }
            if (this.viewer.viewOptions().showColor()) {
                this.setColorAndStandardMaterial(gl, (float)tv.color().getRed() / 255.0f, (float)tv.color().getGreen() / 255.0f, (float)tv.color().getBlue() / 255.0f);
            } else {
                this.setColorAndStandardMaterial(gl, 0.8f, 0.8f, 0.45f);
            }
            if (this.viewer.viewOptions().showShape()) {
                this.observer().applyNormal(gl);
                if (stemThickness > 0.0) {
                    gl.glTranslated(0.0, 0.0, stemThickness / (double)2);
                }
                gl.glScaled(3.0, 3.0, 3.0);
                gl.glCallList(BoxesRunTime.unboxToInt((Object)this.compiledShapes().apply((Object)tv.shape())));
            } else {
                gl.glCallList(this.pinHeadListHandle());
            }
            gl.glPopMatrix();
        });
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.viewer.linkValues());
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)lv -> {
            double zval1 = 0.0;
            double zval2 = 0.0;
            if (this.viewer.viewOptions().linksAreThreeD()) {
                zval1 = this.viewer.zScale() * lv.zcor1();
                zval2 = this.viewer.zScale() * lv.zcor2();
            }
            Color c = lv.color();
            this.setColorAndStandardMaterial(gl, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            gl.glLineWidth((float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(lv.thickness()), 0.1));
            gl.glBegin(1);
            gl.glVertex3d(lv.xcor1(), lv.ycor1(), zval1);
            gl.glVertex3d(lv.xcor2(), lv.ycor2(), zval2);
            gl.glEnd();
        });
        this.drawAxesIfDragging(gl, this.axisHeadHandle());
        gl.glPopMatrix();
    }
}

