/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ls;

import java.awt.EventQueue;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Version$;
import org.nlogo.api.Workspace;
import org.nlogo.ls.AuxRNG$;
import org.nlogo.ls.Evaluator;
import org.nlogo.ls.LevelSpace;
import org.nlogo.ls.LevelSpace$;
import org.nlogo.ls.Notifying;
import org.nlogo.ls.RNG;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public abstract class ChildModel {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ChildModel.class.getDeclaredField("usesLevelSpace$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ChildModel.class.getDeclaredField("evaluator$lzy1"));
    private final Workspace parentWorkspace;
    private final int modelID;
    private volatile Object evaluator$lzy1;
    private Option<String> _name;
    private volatile Object usesLevelSpace$lzy1;
    private final String modelsLoadingKey;
    private final String noGeneratorKey;
    private final String oldNoGeneratorKey;

    public ChildModel(Workspace parentWorkspace, int modelID) {
        this.parentWorkspace = parentWorkspace;
        this.modelID = modelID;
        this._name = None$.MODULE$;
        this.modelsLoadingKey = "org.nlogo.ls.modelsLoading";
        this.noGeneratorKey = "org.nlogo.noGenerator";
        this.oldNoGeneratorKey = "org.nlogo.ls.oldNoGenerator";
    }

    public Workspace parentWorkspace() {
        return this.parentWorkspace;
    }

    public int modelID() {
        return this.modelID;
    }

    public Evaluator evaluator() {
        Object object = this.evaluator$lzy1;
        if (object instanceof Evaluator) {
            return (Evaluator)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Evaluator)this.evaluator$lzyINIT1();
    }

    private Object evaluator$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.evaluator$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Evaluator evaluator = null;
                    try {
                        evaluator = new Evaluator(this.modelID(), this.name(), this.workspace(), (AbstractWorkspaceScala)this.parentWorkspace());
                        object2 = evaluator == null ? LazyVals.NullValue$.MODULE$ : evaluator;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.evaluator$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return evaluator;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void name_$eq(String newName) {
        this._name = Some$.MODULE$.apply((Object)newName);
        this.updateFrameTitle();
    }

    public String name() {
        return (String)this._name.getOrElse(this::name$$anonfun$1);
    }

    public Notifying<BoxedUnit> ask(String code, Seq<Tuple2<String, Object>> lets, Seq<Object> args, RNG rng) {
        return this.evaluator().command(code, lets, args, rng, true);
    }

    public Notifying<Object> of(String code, Seq<Tuple2<String, Object>> lets, Seq<Object> args, RNG rng) {
        return this.evaluator().report(code, lets, args, rng, true);
    }

    public void kill() {
        Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.kill$$anonfun$1();
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
        CommandRunnable disposeRunnable = new CommandRunnable(this){
            private final /* synthetic */ ChildModel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.frame().foreach((Function1)((JProcedure1 & Serializable)ChildModel::org$nlogo$ls$ChildModel$$anon$1$$_$run$$anonfun$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$nlogo$ls$ChildModel$$anon$1$$_$run$$anonfun$1(javax.swing.JFrame )}, serializedLambda);
            }
        };
        if (EventQueue.isDispatchThread()) {
            disposeRunnable.run();
            return;
        }
        this.parentWorkspace().waitFor(disposeRunnable);
    }

    public void halt() {
        this.workspace().halt();
    }

    public String path() {
        return this.workspace().getModelPath();
    }

    public void updateFrameTitle() {
        this.frame().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.setTitle(this.frameTitle()));
    }

    public String frameTitle() {
        return this.name() + " (LevelSpace model #" + this.modelID() + ")";
    }

    public abstract Option<JFrame> frame();

    public abstract void setSpeed(double var1);

    public abstract AbstractWorkspaceScala workspace();

    public boolean usesLevelSpace() {
        Object object = this.usesLevelSpace$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.usesLevelSpace$lzyINIT1());
    }

    private Object usesLevelSpace$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.usesLevelSpace$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(this.workspace().getExtensionManager().loadedExtensions()).asScala().exists((Function1 & Serializable)_$3 -> {
                            String string = _$3.getClass().toString();
                            String string2 = LevelSpace.class.toString();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.usesLevelSpace$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void show() {
        this.frame().foreach((Function1)(JProcedure1 & Serializable)f -> this.onEDT((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            ChildModel.show$$anonfun$1$$anonfun$1(f);
            return BoxedUnit.UNIT;
        }));
    }

    public void hide() {
        this.frame().foreach((Function1)(JProcedure1 & Serializable)f -> this.onEDT((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            ChildModel.hide$$anonfun$1$$anonfun$1(f);
            return BoxedUnit.UNIT;
        }));
    }

    public void showAll() {
        this.show();
        if (this.usesLevelSpace()) {
            this.ask("ls:show-all ls:models", (Seq<Tuple2<String, Object>>)((Seq)((SeqOps)Nil$.MODULE$)), (Seq<Object>)((Seq)((SeqOps)Nil$.MODULE$)), AuxRNG$.MODULE$).waitFor();
            return;
        }
    }

    public void hideAll() {
        this.hide();
        if (this.usesLevelSpace()) {
            this.ask("ls:hide-all ls:models", (Seq<Tuple2<String, Object>>)((Seq)((SeqOps)Nil$.MODULE$)), (Seq<Object>)((Seq)((SeqOps)Nil$.MODULE$)), AuxRNG$.MODULE$).waitFor();
            return;
        }
    }

    public void seedRNG(RNG rng, long seed) {
        if (this.usesLevelSpace()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"seed");
            this.ask("ls:random-seed seed", (Seq<Tuple2<String, Object>>)((Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToDouble((double)seed)), (List)Nil$.MODULE$))), (Seq<Object>)((Seq)((SeqOps)Nil$.MODULE$)), rng).waitFor();
            return;
        }
        rng.apply((Workspace)this.workspace()).setSeed(seed);
    }

    public void onEDT(Function0<BoxedUnit> f) {
        if (!LevelSpace$.MODULE$.isHeadless()) {
            if (SwingUtilities.isEventDispatchThread()) {
                f.apply$mcV$sp();
                return;
            }
            SwingUtilities.invokeLater(() -> f.apply$mcV$sp());
            return;
        }
    }

    public void openModelWithoutGenerator(Function1<String, BoxedUnit> opener, String modelPath) {
        Version$ version$ = Version$.MODULE$;
        synchronized (version$) {
            Integer modelsLoading = Integer.getInteger(this.modelsLoadingKey, 0);
            if (Predef$.MODULE$.Integer2int(modelsLoading) <= 0) {
                System.setProperty(this.oldNoGeneratorKey, System.getProperty(this.noGeneratorKey, "false"));
            }
            System.setProperty(this.modelsLoadingKey, BoxesRunTime.boxToInteger((int)(Predef$.MODULE$.Integer2int(modelsLoading) + 1)).toString());
            System.setProperty(this.noGeneratorKey, "true");
        }
        try {
            try {
                opener.apply((Object)modelPath);
            }
            catch (IllegalStateException e) {
                throw new ExtensionException(modelPath + " is from an incompatible version of NetLogo. Try opening it in NetLogo to convert it.", (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Version$ version$2 = Version$.MODULE$;
            synchronized (version$2) {
                int modelsLeft = Predef$.MODULE$.Integer2int(Integer.getInteger(this.modelsLoadingKey)) - 1;
                if (modelsLeft == 0) {
                    System.setProperty(this.noGeneratorKey, System.getProperty(this.oldNoGeneratorKey));
                }
                System.setProperty(this.modelsLoadingKey, BoxesRunTime.boxToInteger((int)modelsLeft).toString());
            }
            throw throwable;
        }
        Version$ version$3 = Version$.MODULE$;
        synchronized (version$3) {
            int modelsLeft = Predef$.MODULE$.Integer2int(Integer.getInteger(this.modelsLoadingKey)) - 1;
            if (modelsLeft == 0) {
                System.setProperty(this.noGeneratorKey, System.getProperty(this.oldNoGeneratorKey));
            }
            System.setProperty(this.modelsLoadingKey, BoxesRunTime.boxToInteger((int)modelsLeft).toString());
        }
    }

    private final String name$$anonfun$1() {
        return this.workspace().getModelFileName();
    }

    private final void kill$$anonfun$1() {
        this.workspace().dispose();
    }

    public static final /* synthetic */ void org$nlogo$ls$ChildModel$$anon$1$$_$run$$anonfun$1(JFrame _$1) {
        _$1.dispose();
    }

    private static final void show$$anonfun$1$$anonfun$1(JFrame f$1) {
        f$1.setVisible(true);
    }

    private static final void hide$$anonfun$1$$anonfun$1(JFrame f$2) {
        f$2.setVisible(false);
    }
}

