/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ls;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.api.Workspace;
import org.nlogo.core.AgentKind;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Nobody$;
import org.nlogo.ls.AuxRNG$;
import org.nlogo.ls.ErrorUtils$;
import org.nlogo.ls.FakeNotifier;
import org.nlogo.ls.LocalRNG$;
import org.nlogo.ls.MainRNG$;
import org.nlogo.ls.Notifying;
import org.nlogo.ls.NotifyingJob;
import org.nlogo.ls.PlotRNG$;
import org.nlogo.ls.RNG;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import org.nlogo.prim._constboolean;
import org.nlogo.prim._constdouble;
import org.nlogo.prim._constlist;
import org.nlogo.prim._conststring;
import org.nlogo.prim._nobody;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;

public class Evaluator {
    private final int modelID;
    private final String name;
    private final AbstractWorkspaceScala ws;
    private final AbstractWorkspaceScala parentWS;
    private final SimpleJobOwner mainOwner;
    private final SimpleJobOwner auxOwner;
    private final SimpleJobOwner plotOwner;
    private final Procedure commandRunnerProc;
    private final Procedure reporterRunnerProc;
    private final LoadingCache<String, Reporter> lambdaCache;
    private final String fullCodePrefix;
    private final String fullCodeMap;
    private final String fullCodeSuffix1;
    private final String fullCodeSuffix2;
    private final int sbInitCap;

    public Evaluator(int modelID, String name, AbstractWorkspaceScala ws, AbstractWorkspaceScala parentWS) {
        this.modelID = modelID;
        this.name = name;
        this.ws = ws;
        this.parentWS = parentWS;
        this.mainOwner = new SimpleJobOwner(name, MainRNG$.MODULE$.apply((Workspace)ws), (AgentKind)AgentKind.Observer$.MODULE$);
        this.auxOwner = new SimpleJobOwner(name, AuxRNG$.MODULE$.apply((Workspace)ws), (AgentKind)AgentKind.Observer$.MODULE$);
        this.plotOwner = new SimpleJobOwner(name, PlotRNG$.MODULE$.apply((Workspace)ws), (AgentKind)AgentKind.Observer$.MODULE$);
        this.commandRunnerProc = ws.compileCommands("run []");
        this.reporterRunnerProc = ws.compileReporter("runresult [ 0 ]");
        this.lambdaCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Reporter>(this){
            private final /* synthetic */ Evaluator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Reporter load(String code) {
                return this.$outer.org$nlogo$ls$Evaluator$$compileProcedureReporter(code);
            }
        });
        this.fullCodePrefix = "[[__lsargs ";
        this.fullCodeMap = "]-> ";
        this.fullCodeSuffix1 = "[";
        this.fullCodeSuffix2 = "]__lsargs]";
        this.sbInitCap = this.fullCodePrefix.length() + this.fullCodeMap.length() + this.fullCodeSuffix1.length() + this.fullCodeSuffix2.length();
    }

    public SimpleJobOwner mainOwner() {
        return this.mainOwner;
    }

    public SimpleJobOwner auxOwner() {
        return this.auxOwner;
    }

    public SimpleJobOwner plotOwner() {
        return this.plotOwner;
    }

    public SimpleJobOwner owner(RNG rng) {
        RNG rNG = rng;
        if (MainRNG$.MODULE$.equals(rNG)) {
            return this.mainOwner();
        }
        if (AuxRNG$.MODULE$.equals(rNG)) {
            return this.auxOwner();
        }
        if (PlotRNG$.MODULE$.equals(rNG)) {
            return this.plotOwner();
        }
        if (LocalRNG$.MODULE$.equals(rNG)) {
            return new SimpleJobOwner(this.name, LocalRNG$.MODULE$.apply((Workspace)this.ws), (AgentKind)AgentKind.Observer$.MODULE$);
        }
        throw new MatchError((Object)rNG);
    }

    public Notifying<BoxedUnit> command(String code, Seq<Tuple2<String, Object>> lets2, Seq<Object> args, RNG rng, boolean parallel) {
        return this.run(code, lets2, args, "__apply", rng, parallel, (Function3<Reporter, LogoList, Seq<Tuple2<String, Object>>, Procedure>)(Function3 & Serializable)(task, lsArgs, lets) -> this.commandRunner((Reporter)task, (LogoList)lsArgs, (Seq<Tuple2<String, Object>>)lets)).map((JProcedure1 & Serializable)result -> this.ignore(result));
    }

    public Notifying<Object> report(String code, Seq<Tuple2<String, Object>> lets2, Seq<Object> args, RNG rng, boolean parallel) {
        return this.run(code, lets2, args, "__apply-result", rng, parallel, (Function3<Reporter, LogoList, Seq<Tuple2<String, Object>>, Procedure>)(Function3 & Serializable)(task, lsArgs, lets) -> this.reporterRunner((Reporter)task, (LogoList)lsArgs, (Seq<Tuple2<String, Object>>)lets)).map((Function1 & Serializable)result -> this.checkResult(result));
    }

    public Notifying<Object> run(String code, Seq<Tuple2<String, Object>> lets, Seq<Object> args, String apply, RNG rng, boolean parallel, Function3<Reporter, LogoList, Seq<Tuple2<String, Object>>, Procedure> runner) {
        return (Notifying)ErrorUtils$.MODULE$.handle(this.modelID, this.name, () -> this.run$$anonfun$1(code, lets, apply, runner, args, rng, parallel));
    }

    private void ignore(Object result) {
    }

    private Object checkResult(Object result2) {
        Object object = result2;
        if (object instanceof Agent || object instanceof AgentSet) {
            throw ErrorUtils$.MODULE$.wrap(this.modelID, this.name, "You cannot report agents or agentsets from LevelSpace models.");
        }
        if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            l.foreach((Function1 & Serializable)result -> this.checkResult(result));
            return l;
        }
        Object x = object;
        return x;
    }

    private Reporter getLambda(String code) {
        Reporter reporter;
        try {
            reporter = (Reporter)this.lambdaCache.get((Object)code);
        }
        catch (Exception ex) {
            throw ex.getCause();
        }
        return reporter;
    }

    public Reporter org$nlogo$ls$Evaluator$$compileProcedureReporter(String code) {
        return this.ws.compileReporter((String)code).code()[0].args[0];
    }

    private Reporter makeConstantReporter(Object value) {
        _constboolean _constboolean2;
        Object object = value;
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            _constboolean2 = new _constboolean(b);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            _constboolean2 = new _constdouble(d);
        } else if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            _constboolean2 = new _constlist(l);
        } else if (object instanceof String) {
            String s = (String)object;
            _constboolean2 = new _conststring(s);
        } else if (Nobody$.MODULE$.equals(object)) {
            _constboolean2 = new _nobody();
        } else {
            throw new IllegalArgumentException(value.getClass().getName());
        }
        return (Reporter)_constboolean2;
    }

    private Reporter[] makeArgumentArray(Reporter task, LogoList lsArgs, Seq<Tuple2<String, Object>> lets) {
        Reporter[] a = new Reporter[2 + lets.size()];
        a[0] = task;
        a[1] = this.makeConstantReporter(lsArgs);
        IntRef i = IntRef.create((int)2);
        lets.foreach((Function1)(JProcedure1 & Serializable)l -> {
            a$1[i$1.elem] = this.makeConstantReporter(l._2());
            ++i$1.elem;
        });
        return a;
    }

    private Procedure reporterRunner(Reporter task, LogoList lsArgs, Seq<Tuple2<String, Object>> lets) {
        this.reporterRunnerProc.code()[0].args[0].args = this.makeArgumentArray(task, lsArgs, lets);
        return this.reporterRunnerProc;
    }

    private Procedure commandRunner(Reporter task, LogoList lsArgs, Seq<Tuple2<String, Object>> lets) {
        this.commandRunnerProc.code()[0].args = this.makeArgumentArray(task, lsArgs, lets);
        return this.commandRunnerProc;
    }

    private final Notifying run$$anonfun$1(String code$1, Seq lets$1, String apply$1, Function3 runner$1, Seq args$1, RNG rng$1, boolean parallel$1) {
        Notifying<Object> notifying;
        StringBuilder fullCodeBuilder = new StringBuilder(this.sbInitCap + code$1.length(), this.fullCodePrefix);
        lets$1.foreach((Function1 & Serializable)l -> fullCodeBuilder.append((String)l._1()).append(' '));
        fullCodeBuilder.append(this.fullCodeMap).append(apply$1).append(this.fullCodeSuffix1).append(code$1).append(this.fullCodeSuffix2);
        String fullCode = fullCodeBuilder.toString();
        Procedure proc = (Procedure)runner$1.apply((Object)this.getLambda(fullCode), (Object)LogoList$.MODULE$.fromVector(args$1.toVector()), (Object)lets$1);
        SimpleJobOwner o = this.owner(rng$1);
        if (parallel$1) {
            NotifyingJob job = new NotifyingJob(this.parentWS.world(), this.ws, (JobOwner)o, this.ws.world().observers(), proc);
            this.ws.jobManager.addJob((Job)job, false);
            notifying = job;
        } else {
            ExclusiveJob j = new ExclusiveJob((JobOwner)o, this.ws.world().observers(), proc, 0, null, (org.nlogo.nvm.Workspace)this.ws, o.random());
            j.run();
            notifying = new FakeNotifier<Object>(j.result);
        }
        Notifying<Object> job = notifying;
        return job.map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Exception) {
                Exception ex = (Exception)object;
                throw ErrorUtils$.MODULE$.wrap(this.modelID, this.name, ex);
            }
            Object r = object;
            return r;
        });
    }
}

