/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ls.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ModelType;
import org.nlogo.api.Version;
import org.nlogo.api.Version$;
import org.nlogo.app.App$;
import org.nlogo.app.TabManager;
import org.nlogo.app.codetab.CodeTab;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.CompilerException;
import org.nlogo.core.LiteralParser;
import org.nlogo.core.Model$;
import org.nlogo.fileformat.FileFormat$;
import org.nlogo.fileformat.NLogoAnyLoader;
import org.nlogo.ls.gui.LevelSpaceMenu$;
import org.nlogo.ls.gui.ModelCodeTab;
import org.nlogo.ls.gui.ModelManager;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.PresentationCompilerInterface;
import org.nlogo.swing.FileDialog$;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.workspace.AbstractWorkspaceScala;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.ModelTracker;
import org.nlogo.workspace.ModelsLibrary$;
import org.nlogo.workspace.SaveModel;
import org.nlogo.workspace.SaveModel$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public interface LevelSpaceMenu {

    public static class NewModelAction
    extends NewTabAction {
        public NewModelAction(String name, ModelManager modelManager) {
            super(name, modelManager);
        }

        @Override
        public Option<String> filePath() {
            GUIWorkspace ws = App$.MODULE$.app().workspace();
            NLogoAnyLoader loader = FileFormat$.MODULE$.standardAnyLoader(false, (LiteralParser)ws.compiler().utilities(), FileFormat$.MODULE$.standardAnyLoader$default$3());
            SaveModel.Controller controller = new SaveModel.Controller(){

                public Option chooseFilePath(ModelType modelType) {
                    None$ none$;
                    try {
                        String userEntry = FileDialog$.MODULE$.showFiles((Frame)App$.MODULE$.app().frame(), "Select a path for new Model...", 1);
                        String fileName = userEntry.endsWith(".nlogo") || userEntry.endsWith(".nlogox") ? userEntry : userEntry + ".nlogox";
                        Path path = Paths.get(fileName, new String[0]);
                        if (Files.exists(path, new LinkOption[0])) {
                            String fileAlreadyExists = "The file " + fileName + " already exists. Please choose a different name";
                            throw new ExtensionException(fileAlreadyExists);
                        }
                        none$ = Some$.MODULE$.apply((Object)path.toUri());
                    }
                    catch (UserCancelException e) {
                        Exceptions$.MODULE$.ignore((Throwable)e);
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }

                public boolean shouldSaveModelOfDifferingVersion(String version) {
                    return true;
                }

                public void warnInvalidFileFormat(String format) {
                }
            };
            ModelTracker modelTracker = new ModelTracker(){
                private FileManager fileManager;
                private String modelDir;
                private String _modelFileName;
                private ModelType org$nlogo$workspace$ModelTracker$$_modelType;
                {
                    ModelTracker.$init$((ModelTracker)this);
                    Statics.releaseFence();
                }

                public FileManager fileManager() {
                    return this.fileManager;
                }

                public String modelDir() {
                    return this.modelDir;
                }

                public String _modelFileName() {
                    return this._modelFileName;
                }

                public ModelType org$nlogo$workspace$ModelTracker$$_modelType() {
                    return this.org$nlogo$workspace$ModelTracker$$_modelType;
                }

                public void modelDir_$eq(String x$1) {
                    this.modelDir = x$1;
                }

                public void _modelFileName_$eq(String x$1) {
                    this._modelFileName = x$1;
                }

                public void org$nlogo$workspace$ModelTracker$$_modelType_$eq(ModelType x$1) {
                    this.org$nlogo$workspace$ModelTracker$$_modelType = x$1;
                }

                public void org$nlogo$workspace$ModelTracker$_setter_$fileManager_$eq(FileManager x$0) {
                    this.fileManager = x$0;
                }

                public PresentationCompilerInterface compiler() {
                    return App$.MODULE$.app().workspace().compiler();
                }

                public ExtensionManager getExtensionManager() {
                    return App$.MODULE$.app().workspace().getExtensionManager();
                }
            };
            return SaveModel$.MODULE$.apply(Model$.MODULE$.apply(Model$.MODULE$.$lessinit$greater$default$1(), Model$.MODULE$.$lessinit$greater$default$2(), Model$.MODULE$.$lessinit$greater$default$3(), Model$.MODULE$.$lessinit$greater$default$4(), Model$.MODULE$.$lessinit$greater$default$5(), Model$.MODULE$.$lessinit$greater$default$6(), Model$.MODULE$.$lessinit$greater$default$7(), Model$.MODULE$.$lessinit$greater$default$8(), Model$.MODULE$.$lessinit$greater$default$9()), (AbstractModelLoader)loader, controller, modelTracker, (Version)Version$.MODULE$).flatMap(LevelSpaceMenu$::org$nlogo$ls$gui$LevelSpaceMenu$NewModelAction$$_$filePath$$anonfun$1);
        }
    }

    public static abstract class NewTabAction
    extends AbstractAction {
        private final ModelManager modelManager;
        private final TabManager tabManager;

        public NewTabAction(String name, ModelManager modelManager) {
            this.modelManager = modelManager;
            super(name);
            this.tabManager = App$.MODULE$.app().tabManager();
        }

        public TabManager tabManager() {
            return this.tabManager;
        }

        public abstract Option<String> filePath();

        public Option<CodeTab> actingTab() {
            return this.filePath().flatMap((Function1 & Serializable)path -> this.locateExistingTab((String)path).orElse(() -> this.actingTab$$anonfun$1$$anonfun$1(path)));
        }

        private Option<CodeTab> locateExistingTab(String path) {
            return this.modelManager.existingTab(path);
        }

        private Option<CodeTab> createNewTab(String path) {
            return this.modelManager.registerTab(path, (Function1<AbstractWorkspaceScala, ModelCodeTab>)(Function1 & Serializable)workspace -> {
                ModelCodeTab tab = new ModelCodeTab((AbstractWorkspaceScala)workspace, this.tabManager(), this.modelManager);
                this.tabManager().addTab((Component)((Object)tab), tab.tabName());
                return tab;
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.actingTab().foreach((Function1)(JProcedure1 & Serializable)tab -> this.tabManager().setSelectedTab(tab));
        }

        private final Option actingTab$$anonfun$1$$anonfun$1(String path$1) {
            return this.createNewTab(path$1);
        }
    }

    public static class OpenModelAction
    extends NewTabAction {
        private final String fileName;

        public OpenModelAction(String fileName, ModelManager modelManager) {
            this.fileName = fileName;
            super(fileName, modelManager);
        }

        @Override
        public Option<String> filePath() {
            return Some$.MODULE$.apply((Object)this.fileName);
        }
    }

    public static class SelectModelAction
    extends NewTabAction {
        public SelectModelAction(String name, ModelManager modelManager) {
            super(name, modelManager);
        }

        @Override
        public Option<String> filePath() {
            return this.selectFile();
        }

        @Override
        public Option<CodeTab> actingTab() {
            Option<CodeTab> option;
            try {
                option = super.actingTab();
            }
            catch (CompilerException e) {
                throw new ExtensionException(this.filePath() + " did not compile properly. There is probably something wrong " + ("with its code. Exception said " + e.getMessage()));
            }
            catch (IOException e) {
                throw new ExtensionException("There was no model file at the path: \"" + this.filePath() + "\"");
            }
            return option;
        }

        private Option<String> selectFile() {
            return this.showLoadSelection().flatMap((Function1 & Serializable)path -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])ModelsLibrary$.MODULE$.getModelPaths());
                if (ArrayOps$.MODULE$.contains$extension(object, path)) {
                    this.showLibraryModelErrorMessage();
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(path);
            });
        }

        private Option<String> showLoadSelection() {
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)FileDialog$.MODULE$.showFiles((Frame)App$.MODULE$.app().frame(), "Load a LevelSpace Model...", 0));
            }
            catch (UserCancelException e) {
                Exceptions$.MODULE$.ignore((Throwable)e);
                none$ = None$.MODULE$;
            }
            return none$;
        }

        private void showLibraryModelErrorMessage() {
            JOptionPane.showMessageDialog((Component)App$.MODULE$.app().frame(), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|The model you selected is a library model, which cannot be opened in a LevelSpace code tab.\n        |Please save the model elsewhere and try re-opening")));
        }
    }
}

