/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.package$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CompositeX509KeyManager
extends X509ExtendedKeyManager {
    private final Seq<X509KeyManager> keyManagers;
    private final NoDepsLogger logger;

    public CompositeX509KeyManager(LoggerFactory mkLogger, Seq<X509KeyManager> keyManagers) {
        this.keyManagers = keyManagers;
        this.logger = mkLogger.apply(this.getClass());
        this.logger.debug("CompositeX509KeyManager start: keyManagers = " + keyManagers);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        this.logger.debug("getClientAliases: keyType = " + keyType + ", issuers = " + this.issuersToString(issuers));
        ArrayBuffer clientAliases = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
            Object[] aliases = keyManager.getClientAliases(keyType, issuers);
            if (aliases != null) {
                clientAliases.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray(aliases));
            }
        });
        this.logger.debug("getCertificateChain: clientAliases = " + clientAliases);
        return (String[])this.nullIfEmpty(clientAliases.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String string;
        Object object = new Object();
        try {
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])keyType);
            this.logger.debug("chooseClientAlias: keyType = " + ArrayOps$.MODULE$.toSeq$extension(object2) + ", issuers = " + this.issuersToString(issuers) + ", socket = " + socket);
            this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
                String clientAlias = keyManager.chooseClientAlias(keyType, issuers, socket);
                if (clientAlias != null) {
                    this.logger.debug("chooseClientAlias: using clientAlias " + clientAlias + " with keyManager " + keyManager);
                    throw new NonLocalReturnControl(object, (Object)clientAlias);
                }
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        String string;
        Object object = new Object();
        try {
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])keyType);
            this.logger.debug("chooseEngineClientAlias: keyType = " + ArrayOps$.MODULE$.toSeq$extension(object2) + ", issuers = " + this.issuersToString(issuers) + ", engine = " + engine);
            this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
                X509ExtendedKeyManager extendedKeyManager;
                String clientAlias;
                X509KeyManager x509KeyManager = keyManager;
                if (x509KeyManager instanceof X509ExtendedKeyManager && (clientAlias = (extendedKeyManager = (X509ExtendedKeyManager)x509KeyManager).chooseEngineClientAlias(keyType, issuers, engine)) != null) {
                    this.logger.debug("chooseEngineClientAlias: using clientAlias " + clientAlias + " with keyManager " + extendedKeyManager);
                    throw new NonLocalReturnControl(object, (Object)clientAlias);
                }
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        String string;
        Object object = new Object();
        try {
            this.logger.debug("chooseEngineServerAlias: keyType = " + Predef$.MODULE$.wrapString(keyType).toSeq() + ", issuers = " + this.issuersToString(issuers) + ", engine = " + engine);
            this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
                X509ExtendedKeyManager extendedKeyManager;
                String clientAlias;
                X509KeyManager x509KeyManager = keyManager;
                if (x509KeyManager instanceof X509ExtendedKeyManager && (clientAlias = (extendedKeyManager = (X509ExtendedKeyManager)x509KeyManager).chooseEngineServerAlias(keyType, issuers, engine)) != null) {
                    this.logger.debug("chooseEngineServerAlias: using clientAlias " + clientAlias + " with keyManager " + extendedKeyManager);
                    throw new NonLocalReturnControl(object, (Object)clientAlias);
                }
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        this.logger.debug("getServerAliases: keyType = " + keyType + ", issuers = " + this.issuersToString(issuers));
        ArrayBuffer serverAliases = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
            Object[] aliases = keyManager.getServerAliases(keyType, issuers);
            if (aliases != null) {
                serverAliases.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray(aliases));
            }
        });
        this.logger.debug("getServerAliases: serverAliases = " + serverAliases);
        return (String[])this.nullIfEmpty(serverAliases.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String string;
        Object object = new Object();
        try {
            this.logger.debug("chooseServerAlias: keyType = " + keyType + ", issuers = " + this.issuersToString(issuers) + ", socket = " + socket);
            this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
                String serverAlias = keyManager.chooseServerAlias(keyType, issuers, socket);
                if (serverAlias != null) {
                    this.logger.debug("chooseServerAlias: using serverAlias " + serverAlias + " with keyManager " + keyManager);
                    throw new NonLocalReturnControl(object, (Object)serverAlias);
                }
            });
            string = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] x509CertificateArray;
        Object object = new Object();
        try {
            this.logger.debug("getCertificateChain: alias = " + alias);
            this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
                X509Certificate[] chain = keyManager.getCertificateChain(alias);
                if (chain != null && chain.length > 0) {
                    this.logger.debug("getCertificateChain: chain " + package$.MODULE$.debugChain(chain) + " with keyManager " + keyManager);
                    throw new NonLocalReturnControl(object, (Object)chain);
                }
            });
            x509CertificateArray = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                x509CertificateArray = (X509Certificate[])ex.value();
            }
            throw ex;
        }
        return x509CertificateArray;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey privateKey;
        Object object = new Object();
        try {
            this.logger.debug("getPrivateKey: alias = " + alias);
            this.withKeyManagers((Function1)(JProcedure1 & Serializable)keyManager -> {
                PrivateKey privateKey = keyManager.getPrivateKey(alias);
                if (privateKey != null) {
                    this.logger.debug("getPrivateKey: privateKey " + privateKey + " with keyManager " + keyManager);
                    throw new NonLocalReturnControl(object, (Object)privateKey);
                }
            });
            privateKey = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                privateKey = (PrivateKey)ex.value();
            }
            throw ex;
        }
        return privateKey;
    }

    private <T> Seq<CertificateException> withKeyManagers(Function1<X509KeyManager, T> block) {
        ArrayBuffer exceptionList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CertificateException[0]));
        this.keyManagers.foreach((Function1 & Serializable)keyManager -> CompositeX509KeyManager.liftedTree1$1(block, exceptionList, keyManager));
        return exceptionList.toSeq();
    }

    private <T> Object nullIfEmpty(Object array) {
        Object object = Predef$.MODULE$.genericArrayOps(array);
        return ArrayOps$.MODULE$.size$extension(object) == 0 ? null : array;
    }

    private String issuersToString(Principal[] issuers) {
        return issuers != null ? Predef$.MODULE$.wrapRefArray((Object[])issuers).mkString("[", ", ", "]") : null;
    }

    public String toString() {
        return "CompositeX509KeyManager(keyManagers = [" + this.keyManagers + "])";
    }

    private static final Object liftedTree1$1(Function1 block$2, ArrayBuffer exceptionList$2, X509KeyManager keyManager$1) {
        Object object;
        try {
            object = block$2.apply((Object)keyManager$1);
        }
        catch (CertificateException certEx) {
            object = exceptionList$2.append((Object)certEx);
        }
        return object;
    }
}

