/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.package$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public interface TraceLogger {
    public boolean isLogEnabled(String var1, Map<String, Object> var2);

    public static Object tracer$(TraceLogger $this, String methodName, Map parameters, Function0 function, LoggerFactory loggerFactory) {
        return $this.tracer(methodName, (Map<String, Object>)parameters, function, loggerFactory);
    }

    default public <T, E> T tracer(String methodName, Map<String, Object> parameters, Function0<T> function, LoggerFactory loggerFactory) {
        Object object;
        NoDepsLogger logger = loggerFactory.apply(this.getClass());
        String methodParams = parameters.mapValues((Function1 & Serializable)value -> this.mapValue(value)).mkString(",");
        boolean enabled = this.isLogEnabled(methodName, parameters);
        if (enabled) {
            this.entry(logger, methodName, methodParams);
        }
        try {
            Object result = function.apply();
            if (enabled) {
                this.exit(logger, result, methodName, methodParams);
            }
            object = result;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                if (enabled) {
                    this.exception(logger, e, methodName, methodParams);
                }
                throw e;
            }
            throw throwable;
        }
        return (T)object;
    }

    private String mapValue(Object value) {
        String string;
        Object object = value;
        if (object instanceof X509Certificate[]) {
            X509Certificate[] v = (X509Certificate[])object;
            string = "Array(" + package$.MODULE$.debugChain(v).mkString(", ") + ")";
        } else if (object instanceof Principal[]) {
            Object[] v = (Principal[])object;
            string = "Array(" + Predef$.MODULE$.wrapRefArray(v).mkString(", ") + ")";
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object v = object;
            string = "Array(" + Predef$.MODULE$.genericWrapArray(v).mkString(", ") + ")";
        } else if (object instanceof Object) {
            Object v = object;
            string = v.toString();
        } else if (object == null) {
            string = null;
        } else {
            throw new MatchError(object);
        }
        return string;
    }

    private void entry(NoDepsLogger logger, String methodName, String methodParams) {
        logger.warn("entry: " + methodName + "(" + methodParams + ")");
    }

    private <R> R exit(NoDepsLogger logger, R result, String methodName, String methodParams) {
        logger.warn("exit: " + methodName + "(" + methodParams + ") = " + this.mapValue(result));
        return result;
    }

    private void exit(NoDepsLogger logger, String methodName, String methodParams) {
        logger.warn("exit: " + methodName + "(" + methodParams + ")");
    }

    private void exception(NoDepsLogger logger, Throwable e, String methodName, String methodParams) {
        logger.error("exception: " + methodName + "(" + methodParams + ")", e);
    }
}

