/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class TracingSSLEngine
extends SSLEngine
implements TraceLogger {
    private final Function0<SSLEngine> engine;
    private final SSLDebugConfig debug;
    private final LoggerFactory loggerFactory;

    public TracingSSLEngine(Function0 engine, SSLDebugConfig debug, LoggerFactory loggerFactory) {
        this.engine = engine;
        this.debug = debug;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"srcs");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)srcs);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"offset");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)offset));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)length));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"dst");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)dst);
        return (SSLEngineResult)this.tracer("wrap", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).wrap(srcs, offset, length, dst), this.loggerFactory);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"src");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)src);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"dsts");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)dsts);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"offset");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)offset));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BoxesRunTime.boxToInteger((int)length));
        return (SSLEngineResult)this.tracer("wrap", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).unwrap(src, dsts, offset, length), this.loggerFactory);
    }

    @Override
    public Runnable getDelegatedTask() {
        return (Runnable)this.tracer("getDelegatedTask", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getDelegatedTask(), this.loggerFactory);
    }

    @Override
    public void closeInbound() {
        this.tracer("closeInbound", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).closeInbound(), this.loggerFactory);
    }

    @Override
    public boolean isInboundDone() {
        return BoxesRunTime.unboxToBoolean((Object)this.tracer("isInboundDone", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).isInboundDone(), this.loggerFactory));
    }

    @Override
    public void closeOutbound() {
        this.tracer("isInboundDone", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).closeOutbound(), this.loggerFactory);
    }

    @Override
    public boolean isOutboundDone() {
        return BoxesRunTime.unboxToBoolean((Object)this.tracer("isOutboundDone", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).isOutboundDone(), this.loggerFactory));
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return (String[])this.tracer("getSupportedCipherSuites", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getSupportedCipherSuites(), this.loggerFactory);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return (String[])this.tracer("getEnabledCipherSuites", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getEnabledCipherSuites(), this.loggerFactory);
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"suites");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)suites);
        this.tracer("setEnabledCipherSuites", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).setEnabledCipherSuites(suites), this.loggerFactory);
    }

    @Override
    public String[] getSupportedProtocols() {
        return (String[])this.tracer("getSupportedProtocols", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getSupportedProtocols(), this.loggerFactory);
    }

    @Override
    public String[] getEnabledProtocols() {
        return (String[])this.tracer("getEnabledProtocols", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getEnabledProtocols(), this.loggerFactory);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"protocols");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)protocols);
        this.tracer("setEnabledProtocols", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).setEnabledProtocols(protocols), this.loggerFactory);
    }

    @Override
    public SSLSession getSession() {
        return (SSLSession)this.tracer("getSession", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getSession(), this.loggerFactory);
    }

    @Override
    public void beginHandshake() {
        this.tracer("beginHandshake", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).beginHandshake(), this.loggerFactory);
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return (SSLEngineResult.HandshakeStatus)((Object)this.tracer("getHandshakeStatus", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getHandshakeStatus(), this.loggerFactory));
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"clientMode");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)clientMode));
        this.tracer("setUseClientMode", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).setUseClientMode(clientMode), this.loggerFactory);
    }

    @Override
    public boolean getUseClientMode() {
        return BoxesRunTime.unboxToBoolean((Object)this.tracer("getUseClientMode", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getUseClientMode(), this.loggerFactory));
    }

    @Override
    public void setNeedClientAuth(boolean needClientAuth) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"needClientAuth");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)needClientAuth));
        this.tracer("setNeedClientAuth", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).setNeedClientAuth(needClientAuth), this.loggerFactory);
    }

    @Override
    public boolean getNeedClientAuth() {
        return BoxesRunTime.unboxToBoolean((Object)this.tracer("getNeedClientAuth", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getNeedClientAuth(), this.loggerFactory));
    }

    @Override
    public void setWantClientAuth(boolean wantClientAuth) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"wantClientAuth");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)wantClientAuth));
        this.tracer("setWantClientAuth", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).setWantClientAuth(wantClientAuth), this.loggerFactory);
    }

    @Override
    public boolean getWantClientAuth() {
        return BoxesRunTime.unboxToBoolean((Object)this.tracer("getWantClientAuth", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getWantClientAuth(), this.loggerFactory));
    }

    @Override
    public void setEnableSessionCreation(boolean enableSessionCreation) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"enableSessionCreation");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)enableSessionCreation));
        this.tracer("setEnableSessionCreation", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLEngine)this.engine.apply()).setEnableSessionCreation(enableSessionCreation), this.loggerFactory);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return BoxesRunTime.unboxToBoolean((Object)this.tracer("getEnableSessionCreation", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLEngine)this.engine.apply()).getEnableSessionCreation(), this.loggerFactory));
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.ssl();
    }
}

