/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class TracingX509ExtendedKeyManager
extends X509ExtendedKeyManager
implements TraceLogger {
    private final Function0<X509ExtendedKeyManager> supplier;
    private final SSLDebugConfig debug;
    private final LoggerFactory loggerFactory;

    public TracingX509ExtendedKeyManager(Function0 supplier, SSLDebugConfig debug, LoggerFactory loggerFactory) {
        this.supplier = supplier;
        this.debug = debug;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyTypes");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyTypes);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"issuers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)issuers);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"engine");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)engine);
        return (String)this.tracer("chooseEngineClientAlias", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509ExtendedKeyManager)this.supplier.apply()).chooseEngineClientAlias(keyTypes, issuers, engine), this.loggerFactory);
    }

    @Override
    public String chooseEngineServerAlias(String keyTypes, Principal[] issuers, SSLEngine engine) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyTypes");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyTypes);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"issuers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)issuers);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"engine");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)engine);
        return (String)this.tracer("chooseEngineServerAlias", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509ExtendedKeyManager)this.supplier.apply()).chooseEngineServerAlias(keyTypes, issuers, engine), this.loggerFactory);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyType");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyType);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"issuers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)issuers);
        return (String[])this.tracer("getClientAliases", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509KeyManager)this.supplier.apply()).getClientAliases(keyType, issuers), this.loggerFactory);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyTypes");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyTypes);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"issuers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)issuers);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"socket");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)socket);
        return (String)this.tracer("chooseClientAlias", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509KeyManager)this.supplier.apply()).chooseClientAlias(keyTypes, issuers, socket), this.loggerFactory);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyType");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyType);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"issuers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)issuers);
        return (String[])this.tracer("getServerAliases", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509KeyManager)this.supplier.apply()).getServerAliases(keyType, issuers), this.loggerFactory);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyType");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyType);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"issuers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)issuers);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"socket");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)socket);
        return (String)this.tracer("chooseServerAlias", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509KeyManager)this.supplier.apply()).chooseServerAlias(keyType, issuers, socket), this.loggerFactory);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"alias");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)alias);
        return (X509Certificate[])this.tracer("getCertificateChain", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509KeyManager)this.supplier.apply()).getCertificateChain(alias), this.loggerFactory);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"alias");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)alias);
        return (PrivateKey)this.tracer("getPrivateKey", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> ((X509KeyManager)this.supplier.apply()).getPrivateKey(alias), this.loggerFactory);
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.keymanager();
    }
}

