/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.NoSuchElementException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.Dump$;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.NumberParser$;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.extensions.csv.CSVExtension$FileParserPrimitive$;
import org.nlogo.extensions.csv.CSVExtension$ParserPrimitive$;
import org.nlogo.extensions.csv.CSVExtension$ToFile$;
import org.nlogo.extensions.csv.CSVExtension$ToLine$;
import org.nlogo.extensions.csv.CSVExtension$ToString$;
import org.nlogo.nvm.ExtensionContext;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.Selectable$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

public class CSVExtension
extends DefaultClassManager {
    public final CSVExtension$ParserPrimitive$ ParserPrimitive$lzy1 = new CSVExtension$ParserPrimitive$(this);
    public final CSVExtension$FileParserPrimitive$ FileParserPrimitive$lzy1 = new CSVExtension$FileParserPrimitive$(this);
    public final CSVExtension$ToLine$ ToLine$lzy1 = new CSVExtension$ToLine$(this);
    public final CSVExtension$ToString$ ToString$lzy1 = new CSVExtension$ToString$(this);
    public final CSVExtension$ToFile$ ToFile$lzy1 = new CSVExtension$ToFile$(this);

    public CSVFormat csvFormat(Option<String> delimiter) {
        return (CSVFormat)Option$.MODULE$.option2Iterable(delimiter).foldLeft((Object)CSVFormat.DEFAULT, (Function2 & Serializable)(_$1, _$2) -> _$1.withDelimiter(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(_$2), 0)));
    }

    public Iterator<Iterator<String>> parse(String str, CSVFormat format) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(format.parse((Reader)new StringReader(str)).iterator()).asScala().map((Function1 & Serializable)_$3 -> CollectionConverters$.MODULE$.IteratorHasAsScala(_$3.iterator()).asScala());
    }

    public String write(Iterator<String> row, CSVFormat format) {
        return format.format((Object[])((String[])Arrays$.MODULE$.seqToArray(row.toSeq(), String.class)));
    }

    public Object parseValue(String entry) {
        return NumberParser$.MODULE$.parse(entry).getOrElse(() -> CSVExtension.parseValue$$anonfun$1(entry));
    }

    public <T> LogoList lift(Function1<T, Object> parseItem, Iterator<T> row) {
        return LogoList$.MODULE$.fromIterator(row.map(parseItem));
    }

    public final CSVExtension$ParserPrimitive$ ParserPrimitive() {
        return this.ParserPrimitive$lzy1;
    }

    public final CSVExtension$FileParserPrimitive$ FileParserPrimitive() {
        return this.FileParserPrimitive$lzy1;
    }

    public ParserPrimitive rowParser(Function1<String, Object> parseItem) {
        return this.ParserPrimitive().apply((Function1<Iterator<Iterator<String>>, LogoList>)(Function1 & Serializable)rows -> {
            LogoList logoList;
            try {
                logoList = this.lift(parseItem, (Iterator)rows.next());
            }
            catch (NoSuchElementException e) {
                logoList = LogoList$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{""}));
            }
            return logoList;
        });
    }

    public ParserPrimitive fullParser(Function1<String, Object> parseItem) {
        return this.ParserPrimitive().apply((Function1<Iterator<Iterator<String>>, LogoList>)(Function1 & Serializable)row2 -> this.lift((Function1 & Serializable)row -> this.lift((Function1)parseItem, (Iterator)row), (Iterator)row2));
    }

    public Iterator<Iterator<String>> toListOfRows(Function1<Object, String> dump, LogoList rows) {
        return rows.iterator().map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof LogoList) {
                LogoList l = (LogoList)object;
                return l.iterator().map(dump);
            }
            Object x = object;
            throw new ExtensionException("Expected a list of lists, but " + Dump$.MODULE$.logoObject(x) + " was one of the elements.");
        });
    }

    public final CSVExtension$ToLine$ ToLine() {
        return this.ToLine$lzy1;
    }

    public final CSVExtension$ToString$ ToString() {
        return this.ToString$lzy1;
    }

    public final CSVExtension$ToFile$ ToFile() {
        return this.ToFile$lzy1;
    }

    public void load(PrimitiveManager primManager) {
        JProcedure2 & Serializable add = (JProcedure2 & Serializable)(name, prim) -> primManager.addPrimitive(name, prim);
        add.apply((Object)"from-row", (Object)this.rowParser((Function1<String, Object>)(Function1 & Serializable)entry -> this.parseValue((String)entry)));
        add.apply((Object)"from-string", (Object)this.fullParser((Function1<String, Object>)(Function1 & Serializable)entry -> this.parseValue((String)entry)));
        add.apply((Object)"from-file", (Object)this.FileParserPrimitive().apply((Function1<Iterator<Iterator<String>>, LogoList>)(Function1 & Serializable)row2 -> this.lift((Function1 & Serializable)row -> this.lift((Function1 & Serializable)entry -> this.parseValue((String)entry), (Iterator)row), (Iterator)row2)));
        add.apply((Object)"to-row", (Object)this.ToLine().apply((Function1<Object, String>)(Function1 & Serializable)obj -> Dump$.MODULE$.logoObject(obj)));
        add.apply((Object)"to-string", (Object)this.ToString().apply((Function1<Object, String>)(Function1 & Serializable)obj -> Dump$.MODULE$.logoObject(obj)));
        add.apply((Object)"to-file", (Object)this.ToFile().apply((Function1<Object, String>)(Function1 & Serializable)obj -> Dump$.MODULE$.logoObject(obj)));
    }

    public <A, B> A using(B closeable, Function1<B, A> f) {
        Object object;
        try {
            object = f.apply(closeable);
        }
        finally {
            Selectable$.MODULE$.reflectiveSelectable(closeable).applyDynamic("close", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return (A)object;
    }

    private static final Comparable parseValue$$anonfun$1(String entry$1) {
        String string = entry$1.toUpperCase();
        if ("TRUE".equals(string)) {
            return Predef$.MODULE$.boolean2Boolean(true);
        }
        if ("FALSE".equals(string)) {
            return Predef$.MODULE$.boolean2Boolean(false);
        }
        return entry$1;
    }

    public static final /* synthetic */ String org$nlogo$extensions$csv$CSVExtension$ParserPrimitive$$_$report$$anonfun$1(Argument _$4) {
        return _$4.getString();
    }

    public static final /* synthetic */ String org$nlogo$extensions$csv$CSVExtension$FileParserPrimitive$$_$_$$anonfun$1(Argument _$5) {
        return _$5.getString();
    }

    public static final /* synthetic */ Iterator org$nlogo$extensions$csv$CSVExtension$FileParserPrimitive$$_$report$$anonfun$2$$anonfun$1(CSVRecord _$6) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(_$6.iterator()).asScala();
    }

    public static final /* synthetic */ String org$nlogo$extensions$csv$CSVExtension$ToLine$$_$report$$anonfun$3(Argument _$7) {
        return _$7.getString();
    }

    public static final /* synthetic */ String org$nlogo$extensions$csv$CSVExtension$ToString$$_$_$$anonfun$2(Argument _$8) {
        return _$8.getString();
    }

    public static final /* synthetic */ String org$nlogo$extensions$csv$CSVExtension$ToFile$$_$_$$anonfun$3(Argument _$10) {
        return _$10.getString();
    }

    public class FileParserPrimitive
    implements Reporter,
    Product,
    Serializable {
        private final Function1<Iterator<Iterator<String>>, LogoList> process;
        private final /* synthetic */ CSVExtension $outer;

        public FileParserPrimitive(CSVExtension $outer, Function1<Iterator<Iterator<String>>, LogoList> process) {
            this.process = process;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FileParserPrimitive)) return false;
            if (((FileParserPrimitive)object).org$nlogo$extensions$csv$CSVExtension$FileParserPrimitive$$$outer() != this.$outer) return false;
            FileParserPrimitive fileParserPrimitive = (FileParserPrimitive)object;
            Function1<Iterator<Iterator<String>>, LogoList> function1 = this.process();
            Function1<Iterator<Iterator<String>>, LogoList> function12 = fileParserPrimitive.process();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!fileParserPrimitive.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FileParserPrimitive;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FileParserPrimitive";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "process";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Iterator<Iterator<String>>, LogoList> process() {
            return this.process;
        }

        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)(Syntax$.MODULE$.StringType() | Syntax$.MODULE$.RepeatableType())), (List)Nil$.MODULE$);
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            int n = Syntax$.MODULE$.reporterSyntax$default$1();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n, n2, list, Syntax$.MODULE$.ListType(), (Option)some, option, bl, string, option2);
        }

        public Object report(Argument[] args, Context context) {
            Object a;
            String path = ((ExtensionContext)context).workspace().fileManager().attachPrefix(args[0].getString());
            CSVFormat parserFormat = this.$outer.csvFormat((Option<String>)((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).map(CSVExtension::org$nlogo$extensions$csv$CSVExtension$FileParserPrimitive$$_$_$$anonfun$1));
            try {
                a = this.$outer.using(new FileReader(new File(path)), (Function1 & Serializable)reader -> (LogoList)this.process().apply((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(parserFormat.parse((Reader)reader).iterator()).asScala().map(CSVExtension::org$nlogo$extensions$csv$CSVExtension$FileParserPrimitive$$_$report$$anonfun$2$$anonfun$1)));
            }
            catch (FileNotFoundException e) {
                throw new ExtensionException("Couldn't find file: " + path, (Exception)e);
            }
            catch (IOException e) {
                throw new ExtensionException("Couldn't open file: " + path, (Exception)e);
            }
            return a;
        }

        public FileParserPrimitive copy(Function1<Iterator<Iterator<String>>, LogoList> process) {
            return new FileParserPrimitive(this.$outer, process);
        }

        public Function1<Iterator<Iterator<String>>, LogoList> copy$default$1() {
            return this.process();
        }

        public Function1<Iterator<Iterator<String>>, LogoList> _1() {
            return this.process();
        }

        public final /* synthetic */ CSVExtension org$nlogo$extensions$csv$CSVExtension$FileParserPrimitive$$$outer() {
            return this.$outer;
        }
    }

    public class ParserPrimitive
    implements Reporter,
    Product,
    Serializable {
        private final Function1<Iterator<Iterator<String>>, LogoList> process;
        private final /* synthetic */ CSVExtension $outer;

        public ParserPrimitive(CSVExtension $outer, Function1<Iterator<Iterator<String>>, LogoList> process) {
            this.process = process;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParserPrimitive)) return false;
            if (((ParserPrimitive)object).org$nlogo$extensions$csv$CSVExtension$ParserPrimitive$$$outer() != this.$outer) return false;
            ParserPrimitive parserPrimitive = (ParserPrimitive)object;
            Function1<Iterator<Iterator<String>>, LogoList> function1 = this.process();
            Function1<Iterator<Iterator<String>>, LogoList> function12 = parserPrimitive.process();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!parserPrimitive.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParserPrimitive;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ParserPrimitive";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "process";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Iterator<Iterator<String>>, LogoList> process() {
            return this.process;
        }

        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)(Syntax$.MODULE$.StringType() | Syntax$.MODULE$.RepeatableType())), (List)Nil$.MODULE$);
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            int n = Syntax$.MODULE$.reporterSyntax$default$1();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n, n2, list, Syntax$.MODULE$.ListType(), (Option)some, option, bl, string, option2);
        }

        public Object report(Argument[] args, Context context) {
            return this.process().apply(this.$outer.parse(args[0].getString(), this.$outer.csvFormat((Option<String>)((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).map(CSVExtension::org$nlogo$extensions$csv$CSVExtension$ParserPrimitive$$_$report$$anonfun$1))));
        }

        public ParserPrimitive copy(Function1<Iterator<Iterator<String>>, LogoList> process) {
            return new ParserPrimitive(this.$outer, process);
        }

        public Function1<Iterator<Iterator<String>>, LogoList> copy$default$1() {
            return this.process();
        }

        public Function1<Iterator<Iterator<String>>, LogoList> _1() {
            return this.process();
        }

        public final /* synthetic */ CSVExtension org$nlogo$extensions$csv$CSVExtension$ParserPrimitive$$$outer() {
            return this.$outer;
        }
    }

    public class ToFile
    implements Command,
    Product,
    Serializable {
        private final Function1<Object, String> dump;
        private final /* synthetic */ CSVExtension $outer;

        public ToFile(CSVExtension $outer, Function1<Object, String> dump) {
            this.dump = dump;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ToFile)) return false;
            if (((ToFile)object).org$nlogo$extensions$csv$CSVExtension$ToFile$$$outer() != this.$outer) return false;
            ToFile toFile = (ToFile)object;
            Function1<Object, String> function1 = this.dump();
            Function1<Object, String> function12 = toFile.dump();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!toFile.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ToFile;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ToFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dump";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Object, String> dump() {
            return this.dump;
        }

        public Syntax getSyntax() {
            return Syntax$.MODULE$.commandSyntax((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.ListType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)(Syntax$.MODULE$.StringType() | Syntax$.MODULE$.RepeatableType())), (List)Nil$.MODULE$))), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Syntax$.MODULE$.commandSyntax$default$3(), Syntax$.MODULE$.commandSyntax$default$4(), Syntax$.MODULE$.commandSyntax$default$5(), Syntax$.MODULE$.commandSyntax$default$6(), Syntax$.MODULE$.commandSyntax$default$7());
        }

        public void perform(Argument[] args, Context context) {
            String path = ((ExtensionContext)context).workspace().fileManager().attachPrefix(args[0].getString());
            CSVFormat format = this.$outer.csvFormat((Option<String>)((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)2))).map(CSVExtension::org$nlogo$extensions$csv$CSVExtension$ToFile$$_$_$$anonfun$3));
            try {
                this.$outer.using(new PrintWriter(new File(path)), (JProcedure1 & Serializable)writer -> this.$outer.toListOfRows(this.dump(), args[1].getList()).foreach((Function1)(JProcedure1 & Serializable)r -> writer.println(this.$outer.write((Iterator<String>)r, format))));
            }
            catch (FileNotFoundException e) {
                throw new ExtensionException("Couldn't create file: " + path, (Exception)e);
            }
            catch (IOException e) {
                throw new ExtensionException("Couldn't write to file: " + path, (Exception)e);
            }
        }

        public ToFile copy(Function1<Object, String> dump) {
            return new ToFile(this.$outer, dump);
        }

        public Function1<Object, String> copy$default$1() {
            return this.dump();
        }

        public Function1<Object, String> _1() {
            return this.dump();
        }

        public final /* synthetic */ CSVExtension org$nlogo$extensions$csv$CSVExtension$ToFile$$$outer() {
            return this.$outer;
        }
    }

    public class ToLine
    implements Reporter,
    Product,
    Serializable {
        private final Function1<Object, String> dump;
        private final /* synthetic */ CSVExtension $outer;

        public ToLine(CSVExtension $outer, Function1<Object, String> dump) {
            this.dump = dump;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ToLine)) return false;
            if (((ToLine)object).org$nlogo$extensions$csv$CSVExtension$ToLine$$$outer() != this.$outer) return false;
            ToLine toLine = (ToLine)object;
            Function1<Object, String> function1 = this.dump();
            Function1<Object, String> function12 = toLine.dump();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!toLine.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ToLine;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ToLine";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dump";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Object, String> dump() {
            return this.dump;
        }

        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.ListType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)(Syntax$.MODULE$.StringType() | Syntax$.MODULE$.RepeatableType())), (List)Nil$.MODULE$));
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            int n = Syntax$.MODULE$.reporterSyntax$default$1();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n, n2, list, Syntax$.MODULE$.StringType(), (Option)some, option, bl, string, option2);
        }

        public Object report(Argument[] args, Context context) {
            return this.$outer.write((Iterator<String>)args[0].getList().iterator().map(this.dump()), this.$outer.csvFormat((Option<String>)((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).map(CSVExtension::org$nlogo$extensions$csv$CSVExtension$ToLine$$_$report$$anonfun$3)));
        }

        public ToLine copy(Function1<Object, String> dump) {
            return new ToLine(this.$outer, dump);
        }

        public Function1<Object, String> copy$default$1() {
            return this.dump();
        }

        public Function1<Object, String> _1() {
            return this.dump();
        }

        public final /* synthetic */ CSVExtension org$nlogo$extensions$csv$CSVExtension$ToLine$$$outer() {
            return this.$outer;
        }
    }

    public class ToString
    implements Reporter,
    Product,
    Serializable {
        private final Function1<Object, String> dump;
        private final /* synthetic */ CSVExtension $outer;

        public ToString(CSVExtension $outer, Function1<Object, String> dump) {
            this.dump = dump;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ToString)) return false;
            if (((ToString)object).org$nlogo$extensions$csv$CSVExtension$ToString$$$outer() != this.$outer) return false;
            ToString toString = (ToString)object;
            Function1<Object, String> function1 = this.dump();
            Function1<Object, String> function12 = toString.dump();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!toString.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ToString;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ToString";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dump";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Object, String> dump() {
            return this.dump;
        }

        public Syntax getSyntax() {
            List list = (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.ListType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)(Syntax$.MODULE$.StringType() | Syntax$.MODULE$.RepeatableType())), (List)Nil$.MODULE$));
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            int n = Syntax$.MODULE$.reporterSyntax$default$1();
            int n2 = Syntax$.MODULE$.reporterSyntax$default$2();
            Option option = Syntax$.MODULE$.reporterSyntax$default$6();
            boolean bl = Syntax$.MODULE$.reporterSyntax$default$7();
            String string = Syntax$.MODULE$.reporterSyntax$default$8();
            Option option2 = Syntax$.MODULE$.reporterSyntax$default$9();
            return Syntax$.MODULE$.reporterSyntax(n, n2, list, Syntax$.MODULE$.StringType(), (Option)some, option, bl, string, option2);
        }

        public Object report(Argument[] args, Context context) {
            CSVFormat format = this.$outer.csvFormat((Option<String>)((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).map(CSVExtension::org$nlogo$extensions$csv$CSVExtension$ToString$$_$_$$anonfun$2));
            return this.$outer.toListOfRows(this.dump(), args[0].getList()).map((Function1 & Serializable)_$9 -> this.$outer.write((Iterator<String>)_$9, format)).mkString("\n");
        }

        public ToString copy(Function1<Object, String> dump) {
            return new ToString(this.$outer, dump);
        }

        public Function1<Object, String> copy$default$1() {
            return this.dump();
        }

        public Function1<Object, String> _1() {
            return this.dump();
        }

        public final /* synthetic */ CSVExtension org$nlogo$extensions$csv$CSVExtension$ToString$$$outer() {
            return this.$outer;
        }
    }
}

