/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException;
import org.apache.pekko.stream.DelayOverflowStrategy;
import org.apache.pekko.stream.OverflowStrategies;
import org.apache.pekko.stream.OverflowStrategies$EmitEarly$;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.Buffer$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.Delay$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.scaladsl.DelayStrategy;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@InternalApi
public final class Delay<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    public final Function0<DelayStrategy<T>> org$apache$pekko$stream$impl$fusing$Delay$$delayStrategySupplier;
    public final DelayOverflowStrategy org$apache$pekko$stream$impl$fusing$Delay$$overflowStrategy;

    public Delay(Function0<DelayStrategy<T>> delayStrategySupplier, DelayOverflowStrategy overflowStrategy) {
        this.org$apache$pekko$stream$impl$fusing$Delay$$delayStrategySupplier = delayStrategySupplier;
        this.org$apache$pekko$stream$impl$fusing$Delay$$overflowStrategy = overflowStrategy;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.delay();
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(inheritedAttributes, this){
            private final int size;
            private final DelayStrategy delayStrategy;
            private final Buffer buffer;
            private final Function0 onPushWhenBufferFull;
            private final /* synthetic */ Delay $outer;
            {
                JFunction0.mcV.sp & Serializable intersect;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.size = ((Attributes.InputBuffer)inheritedAttributes$17.mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).max();
                this.delayStrategy = (DelayStrategy)$outer.org$apache$pekko$stream$impl$fusing$Delay$$delayStrategySupplier.apply();
                this.buffer = Buffer$.MODULE$.apply(this.size, inheritedAttributes$17);
                DelayOverflowStrategy delayOverflowStrategy = $outer.org$apache$pekko$stream$impl$fusing$Delay$$overflowStrategy;
                if (OverflowStrategies$EmitEarly$.MODULE$.equals(delayOverflowStrategy)) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        if (this.isAvailable($outer.out())) {
                            if (this.isTimerActive(Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$TimerName)) {
                                this.cancelTimer(Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$TimerName);
                            }
                            this.push($outer.out(), ((Tuple2)this.buffer.dequeue())._2());
                            this.grabAndPull();
                            this.completeIfReady();
                            return;
                        }
                        throw new IllegalStateException("Was configured to emitEarly and got element when out is not ready and buffer is full, should not be possible.");
                    };
                } else if (delayOverflowStrategy instanceof OverflowStrategies.DropHead) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        this.buffer.dropHead();
                        this.grabAndPull();
                    };
                } else if (delayOverflowStrategy instanceof OverflowStrategies.DropTail) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        this.buffer.dropTail();
                        this.grabAndPull();
                    };
                } else if (delayOverflowStrategy instanceof OverflowStrategies.DropNew) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        this.grab($outer.in());
                        if (this.shouldPull()) {
                            this.pull($outer.in());
                            return;
                        }
                    };
                } else if (delayOverflowStrategy instanceof OverflowStrategies.DropBuffer) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        this.buffer.clear();
                        this.grabAndPull();
                    };
                } else if (delayOverflowStrategy instanceof OverflowStrategies.Fail) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> this.failStage(new BufferOverflowException(new StringBuilder(56).append("Buffer overflow for delay operator (max capacity was: ").append(this.size).append(")!").toString()));
                } else if (delayOverflowStrategy instanceof OverflowStrategies.Backpressure) {
                    intersect = Delay::org$apache$pekko$stream$impl$fusing$Delay$$anon$36$$_$$lessinit$greater$$anonfun$22;
                } else {
                    throw new MatchError((Object)delayOverflowStrategy);
                }
                this.onPushWhenBufferFull = intersect;
                this.setHandler($outer.in(), this);
                this.setHandler($outer.out(), this);
            }

            public void onPush() {
                if (this.buffer.isFull()) {
                    this.onPushWhenBufferFull.apply$mcV$sp();
                    return;
                }
                this.grabAndPull();
                if (!this.isTimerActive(Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$TimerName)) {
                    long waitTime = this.nextElementWaitTime();
                    if (waitTime <= (long)Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$DelayPrecisionMS && this.isAvailable(this.$outer.out())) {
                        this.push(this.$outer.out(), ((Tuple2)this.buffer.dequeue())._2());
                        this.completeIfReady();
                        return;
                    }
                    this.scheduleOnce((Object)Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$TimerName, new package.DurationLong(package$.MODULE$.DurationLong(waitTime)).millis());
                    return;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean shouldPull() {
                if (this.buffer.used() < this.size) return true;
                if (!this.$outer.org$apache$pekko$stream$impl$fusing$Delay$$overflowStrategy.isBackpressure()) return true;
                DelayOverflowStrategy delayOverflowStrategy = this.$outer.org$apache$pekko$stream$impl$fusing$Delay$$overflowStrategy;
                OverflowStrategies$EmitEarly$ overflowStrategies$EmitEarly$ = OverflowStrategies$EmitEarly$.MODULE$;
                if (delayOverflowStrategy == null) {
                    if (overflowStrategies$EmitEarly$ != null) {
                        return false;
                    }
                } else if (!delayOverflowStrategy.equals(overflowStrategies$EmitEarly$)) return false;
                if (!this.isAvailable(this.$outer.out())) return false;
                return true;
            }

            private void grabAndPull() {
                T element = this.grab(this.$outer.in());
                this.buffer.enqueue(Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(System.nanoTime() + this.delayStrategy.nextDelay(element).toNanos())), element));
                if (this.shouldPull()) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.completeIfReady();
            }

            public void onPull() {
                if (!this.isTimerActive(Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$TimerName) && !this.buffer.isEmpty()) {
                    long waitTime = this.nextElementWaitTime();
                    if (waitTime <= (long)Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$DelayPrecisionMS) {
                        this.push(this.$outer.out(), ((Tuple2)this.buffer.dequeue())._2());
                    } else {
                        this.scheduleOnce((Object)Delay$.org$apache$pekko$stream$impl$fusing$Delay$$$TimerName, new package.DurationLong(package$.MODULE$.DurationLong(waitTime)).millis());
                    }
                }
                if (!this.isClosed(this.$outer.in()) && !this.hasBeenPulled(this.$outer.in()) && this.shouldPull()) {
                    this.pull(this.$outer.in());
                }
                this.completeIfReady();
            }

            public void completeIfReady() {
                if (this.isClosed(this.$outer.in()) && this.buffer.isEmpty()) {
                    this.completeStage();
                    return;
                }
            }

            private long nextElementWaitTime() {
                return TimeUnit.NANOSECONDS.toMillis(BoxesRunTime.unboxToLong((Object)((Tuple2)this.buffer.peek())._1()) - System.nanoTime());
            }

            public final void onTimer(Object key) {
                if (this.isAvailable(this.$outer.out())) {
                    this.push(this.$outer.out(), ((Tuple2)this.buffer.dequeue())._2());
                }
                this.completeIfReady();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$16(org.apache.pekko.stream.impl.fusing.Delay ), $init$$$anonfun$17(), $init$$$anonfun$18(), $init$$$anonfun$19(org.apache.pekko.stream.impl.fusing.Delay ), $init$$$anonfun$20(), $init$$$anonfun$21(), org$apache$pekko$stream$impl$fusing$Delay$$anon$36$$_$$lessinit$greater$$anonfun$22()}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "Delay";
    }

    public static final /* synthetic */ void org$apache$pekko$stream$impl$fusing$Delay$$anon$36$$_$$lessinit$greater$$anonfun$22() {
        throw new IllegalStateException("Delay buffer must never overflow in Backpressure mode");
    }
}

