/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.io.ByteStringParser$;
import org.apache.pekko.stream.impl.io.ByteStringParser$FinishedParser$;
import org.apache.pekko.stream.impl.io.ByteStringParser$ParseResult$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

@InternalApi
public abstract class ByteStringParser<T>
extends GraphStage<FlowShape<ByteString, T>> {
    public final Inlet<ByteString> org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn = Inlet$.MODULE$.apply("bytesIn");
    public final Outlet<T> org$apache$pekko$stream$impl$io$ByteStringParser$$objOut = Outlet$.MODULE$.apply("objOut");
    private final FlowShape shape = FlowShape$.MODULE$.apply(this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn, this.org$apache$pekko$stream$impl$io$ByteStringParser$$objOut);

    public static int CompactionThreshold() {
        return ByteStringParser$.MODULE$.CompactionThreshold();
    }

    public static Exception NeedMoreData() {
        return ByteStringParser$.MODULE$.NeedMoreData();
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("ByteStringParser");
    }

    @Override
    public final FlowShape<ByteString, T> shape() {
        return this.shape;
    }

    public static class ByteReader {
        private final ByteString input;
        private int off;

        public ByteReader(ByteString input) {
            this.input = input;
            this.off = 0;
        }

        public boolean hasRemaining() {
            return this.off < this.input.length();
        }

        public int remainingSize() {
            return this.input.length() - this.off;
        }

        public int currentOffset() {
            return this.off;
        }

        public ByteString remainingData() {
            return this.input.drop(this.off);
        }

        public ByteString fromStartToHere() {
            return this.input.take(this.off);
        }

        public ByteString take(int n) {
            if (this.off + n <= this.input.length()) {
                int o = this.off;
                this.off = o + n;
                return this.input.slice(o, this.off);
            }
            throw ByteStringParser$.MODULE$.NeedMoreData();
        }

        public ByteString takeAll() {
            ByteString ret = this.remainingData();
            this.off = this.input.size();
            return ret;
        }

        public int readByte() {
            if (this.off < this.input.length()) {
                byte x = this.input.apply(this.off);
                ++this.off;
                return x & 0xFF;
            }
            throw ByteStringParser$.MODULE$.NeedMoreData();
        }

        public int readShortLE() {
            return this.readByte() | this.readByte() << 8;
        }

        public int readIntLE() {
            return this.readShortLE() | this.readShortLE() << 16;
        }

        public long readLongLE() {
            return (long)this.readIntLE() & 0xFFFFFFFFL | ((long)this.readIntLE() & 0xFFFFFFFFL) << 32;
        }

        public int readShortBE() {
            return this.readByte() << 8 | this.readByte();
        }

        public int readIntBE() {
            return this.readShortBE() << 16 | this.readShortBE();
        }

        public long readLongBE() {
            return ((long)this.readIntBE() & 0xFFFFFFFFL) << 32 | (long)this.readIntBE() & 0xFFFFFFFFL;
        }

        public void skip(int numBytes) {
            if (this.off + numBytes <= this.input.length()) {
                this.off += numBytes;
                return;
            }
            throw ByteStringParser$.MODULE$.NeedMoreData();
        }

        public void skipZeroTerminatedString() {
            while (this.readByte() != 0) {
            }
        }
    }

    public static class ParseResult<T>
    implements Product,
    Serializable {
        private final Option result;
        private final ParseStep nextStep;
        private final boolean acceptUpstreamFinish;

        public static <T> ParseResult<T> apply(Option<T> option, ParseStep<T> parseStep, boolean bl) {
            return ByteStringParser$ParseResult$.MODULE$.apply(option, parseStep, bl);
        }

        public static ParseResult<?> fromProduct(Product product) {
            return ByteStringParser$ParseResult$.MODULE$.fromProduct(product);
        }

        public static <T> ParseResult<T> unapply(ParseResult<T> parseResult) {
            return ByteStringParser$ParseResult$.MODULE$.unapply(parseResult);
        }

        public static <T> boolean $lessinit$greater$default$3() {
            return ByteStringParser$ParseResult$.MODULE$.$lessinit$greater$default$3();
        }

        public ParseResult(Option<T> result, ParseStep<T> nextStep, boolean acceptUpstreamFinish) {
            this.result = result;
            this.nextStep = nextStep;
            this.acceptUpstreamFinish = acceptUpstreamFinish;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.result()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nextStep()));
            n = Statics.mix((int)n, (int)(this.acceptUpstreamFinish() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseResult)) return false;
            ParseResult parseResult = (ParseResult)object;
            if (this.acceptUpstreamFinish() != parseResult.acceptUpstreamFinish()) return false;
            Option<T> option = this.result();
            Option<T> option2 = parseResult.result();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            ParseStep<T> parseStep = this.nextStep();
            ParseStep<T> parseStep2 = parseResult.nextStep();
            if (parseStep == null) {
                if (parseStep2 != null) {
                    return false;
                }
            } else if (!parseStep.equals(parseStep2)) return false;
            if (!parseResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ParseResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "result";
                }
                case 1: {
                    return "nextStep";
                }
                case 2: {
                    return "acceptUpstreamFinish";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<T> result() {
            return this.result;
        }

        public ParseStep<T> nextStep() {
            return this.nextStep;
        }

        public boolean acceptUpstreamFinish() {
            return this.acceptUpstreamFinish;
        }

        public <T> ParseResult<T> copy(Option<T> result, ParseStep<T> nextStep, boolean acceptUpstreamFinish) {
            return new ParseResult<T>(result, nextStep, acceptUpstreamFinish);
        }

        public <T> Option<T> copy$default$1() {
            return this.result();
        }

        public <T> ParseStep<T> copy$default$2() {
            return this.nextStep();
        }

        public boolean copy$default$3() {
            return this.acceptUpstreamFinish();
        }

        public Option<T> _1() {
            return this.result();
        }

        public ParseStep<T> _2() {
            return this.nextStep();
        }

        public boolean _3() {
            return this.acceptUpstreamFinish();
        }
    }

    public static interface ParseStep<T> {
        public static boolean canWorkWithPartialData$(ParseStep $this) {
            return $this.canWorkWithPartialData();
        }

        default public boolean canWorkWithPartialData() {
            return false;
        }

        public ParseResult<T> parse(ByteReader var1);

        public static void onTruncation$(ParseStep $this) {
            $this.onTruncation();
        }

        default public void onTruncation() {
            throw new IllegalStateException("truncated data in ByteStringParser");
        }
    }

    public static class ParsingException
    extends RuntimeException {
        public ParsingException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public class ParsingLogic
    extends GraphStageLogic
    implements InHandler,
    OutHandler {
        private ByteString buffer;
        private ParseStep<T> current;
        private boolean acceptUpstreamFinish;
        private int untilCompact;

        public ParsingLogic() {
            if (ByteStringParser.this == null) {
                throw new NullPointerException();
            }
            super(ByteStringParser.this.shape());
            this.buffer = ByteString$.MODULE$.empty();
            this.current = ByteStringParser$FinishedParser$.MODULE$;
            this.acceptUpstreamFinish = true;
            this.untilCompact = ByteStringParser$.MODULE$.CompactionThreshold();
            this.setHandlers(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn, ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$objOut, this);
        }

        public final void startWith(ParseStep<T> step) {
            this.current = step;
        }

        public int recursionLimit() {
            return 1000;
        }

        private boolean doParseInner() {
            if (this.buffer.nonEmpty()) {
                boolean bl;
                ByteReader reader = new ByteReader(this.buffer);
                try {
                    ParseResult parseResult = this.current.parse(reader);
                    this.acceptUpstreamFinish = parseResult.acceptUpstreamFinish();
                    parseResult.result().foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.push(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$objOut, _$1));
                    ParseStep parseStep = parseResult.nextStep();
                    ByteStringParser$FinishedParser$ byteStringParser$FinishedParser$ = ByteStringParser$FinishedParser$.MODULE$;
                    if (!(parseStep != null ? !parseStep.equals(byteStringParser$FinishedParser$) : byteStringParser$FinishedParser$ != null)) {
                        this.completeStage();
                        bl = false;
                    } else {
                        this.buffer = reader.remainingData();
                        this.current = parseResult.nextStep();
                        bl = parseResult.result().isEmpty();
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    Exception exception = ByteStringParser$.MODULE$.NeedMoreData();
                    Throwable throwable3 = throwable2;
                    if (!(exception != null ? !exception.equals(throwable3) : throwable3 != null)) {
                        this.acceptUpstreamFinish = false;
                        if (this.current.canWorkWithPartialData()) {
                            this.buffer = reader.remainingData();
                        }
                        if (this.isClosed(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn)) {
                            this.current.onTruncation();
                        } else {
                            this.pull(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn);
                        }
                        bl = false;
                    }
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable4;
                        Throwable ex = throwable4 = (Throwable)option.get();
                        this.failStage(ex);
                        bl = false;
                    }
                    throw throwable;
                }
                return bl;
            }
            if (this.isClosed(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn)) {
                if (this.acceptUpstreamFinish) {
                    this.completeStage();
                } else {
                    this.current.onTruncation();
                }
            } else {
                this.pull(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn);
            }
            return false;
        }

        private void doParse(int remainingRecursions) {
            while (true) {
                if (remainingRecursions == 0) {
                    this.failStage(new IllegalStateException(new StringBuilder(199).append("Parsing logic didn't produce result after ").append(this.recursionLimit()).append(" steps. ").append("Aborting processing to avoid infinite cycles. In the unlikely case that the parsing logic ").append("needs more recursion, override ParsingLogic.recursionLimit.").toString()));
                    return;
                }
                boolean recurse = this.doParseInner();
                if (!recurse) break;
                --remainingRecursions;
            }
        }

        private int doParse$default$1() {
            return this.recursionLimit();
        }

        @Override
        public void onPull() {
            this.doParse(this.doParse$default$1());
        }

        @Override
        public void onPush() {
            this.buffer = this.buffer.$plus$plus(this.grab(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$bytesIn));
            --this.untilCompact;
            if (this.untilCompact == 0) {
                this.untilCompact = ByteStringParser$.MODULE$.CompactionThreshold();
                this.buffer = this.buffer.compact();
            }
            this.doParse(this.doParse$default$1());
        }

        @Override
        public void onUpstreamFinish() {
            if (this.isAvailable(ByteStringParser.this.org$apache$pekko$stream$impl$io$ByteStringParser$$objOut)) {
                this.doParse(this.doParse$default$1());
                return;
            }
            if (this.buffer.isEmpty()) {
                if (this.acceptUpstreamFinish) {
                    this.completeStage();
                    return;
                }
                this.current.onTruncation();
                return;
            }
        }

        public final /* synthetic */ ByteStringParser org$apache$pekko$stream$impl$io$ByteStringParser$ParsingLogic$$$outer() {
            return ByteStringParser.this;
        }
    }
}

