/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Close$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Data$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Failed$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Finished$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Initialized$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$ReadElementAcknowledgement$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.SeqOps;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public class InputStreamAdapter
extends InputStream {
    private final BlockingQueue<InputStreamSinkStage.StreamToAdapterMessage> sharedBuffer;
    private final Function1<InputStreamSinkStage.AdapterToStageMessage, BoxedUnit> sendToStage;
    private final FiniteDuration readTimeout;
    private boolean isInitialized;
    private final AtomicBoolean isActive;
    private boolean isStageAlive;
    private Option detachedChunk;

    public InputStreamAdapter(BlockingQueue<InputStreamSinkStage.StreamToAdapterMessage> sharedBuffer, Function1<InputStreamSinkStage.AdapterToStageMessage, BoxedUnit> sendToStage, FiniteDuration readTimeout) {
        this.sharedBuffer = sharedBuffer;
        this.sendToStage = sendToStage;
        this.readTimeout = readTimeout;
        this.isInitialized = false;
        this.isActive = new AtomicBoolean(true);
        this.isStageAlive = true;
        this.detachedChunk = None$.MODULE$;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public boolean isStageAlive() {
        return this.isStageAlive;
    }

    public void isStageAlive_$eq(boolean x$1) {
        this.isStageAlive = x$1;
    }

    public IOException subscriberClosedException() {
        return new IOException("Reactive stream is terminated, no reads are possible");
    }

    public Option<ByteString> detachedChunk() {
        return this.detachedChunk;
    }

    public void detachedChunk_$eq(Option<ByteString> x$1) {
        this.detachedChunk = x$1;
    }

    private <T> T executeIfNotClosed(Function0<T> f) throws IOException {
        if (this.isActive().get()) {
            this.waitIfNotInitialized();
            return (T)f.apply();
        }
        throw this.subscriberClosedException();
    }

    @Override
    public int read() throws IOException {
        byte[] a = new byte[1];
        int n = this.read(a, 0, 1);
        if (1 == n) {
            return a[0] & 0xFF;
        }
        if (-1 == n) {
            return -1;
        }
        int len = n;
        throw new IllegalStateException(new StringBuilder(17).append("Invalid length [").append(len).append("]").toString());
    }

    @Override
    public int read(byte[] a) throws IOException {
        return this.read(a, 0, a.length);
    }

    @Override
    public int read(byte[] a, int begin, int length) throws IOException {
        Predef$.MODULE$.require(a.length > 0, InputStreamAdapter::read$$anonfun$1);
        Predef$.MODULE$.require(begin >= 0, InputStreamAdapter::read$$anonfun$2);
        Predef$.MODULE$.require(length >= 0, InputStreamAdapter::read$$anonfun$3);
        Predef$.MODULE$.require(begin + length <= a.length, InputStreamAdapter::read$$anonfun$4);
        if (length == 0) {
            return 0;
        }
        return BoxesRunTime.unboxToInt(this.executeIfNotClosed((Function0 & Serializable)() -> {
            if (this.isStageAlive()) {
                Option<ByteString> option = this.detachedChunk();
                if (None$.MODULE$.equals(option)) {
                    int n;
                    block10: {
                        try {
                            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = this.sharedBuffer.poll(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                            if (streamToAdapterMessage instanceof InputStreamSinkStage.Data) {
                                ByteString byteString;
                                InputStreamSinkStage.Data data = InputStreamSinkStage$Data$.MODULE$.unapply((InputStreamSinkStage.Data)streamToAdapterMessage);
                                ByteString data2 = byteString = data._1();
                                this.detachedChunk_$eq((Option<ByteString>)Some$.MODULE$.apply((Object)data2));
                                n = this.readBytes(a, begin, length);
                                break block10;
                            }
                            if (InputStreamSinkStage$Finished$.MODULE$.equals(streamToAdapterMessage)) {
                                this.isStageAlive_$eq(false);
                                n = -1;
                                break block10;
                            }
                            if (streamToAdapterMessage instanceof InputStreamSinkStage.Failed) {
                                Throwable throwable;
                                InputStreamSinkStage.Failed failed = InputStreamSinkStage$Failed$.MODULE$.unapply((InputStreamSinkStage.Failed)streamToAdapterMessage);
                                Throwable ex = throwable = failed._1();
                                this.isStageAlive_$eq(false);
                                throw new IOException(ex);
                            }
                            if (streamToAdapterMessage == null) {
                                throw new IOException("Timeout on waiting for new data");
                            }
                            if (InputStreamSinkStage$Initialized$.MODULE$.equals(streamToAdapterMessage)) {
                                throw new IllegalStateException("message 'Initialized' must come first");
                            }
                            throw new MatchError((Object)streamToAdapterMessage);
                        }
                        catch (InterruptedException ex) {
                            throw new IOException(ex);
                        }
                    }
                    return n;
                }
                if (option instanceof Some) {
                    return this.readBytes(a, begin, length);
                }
                throw new MatchError(option);
            }
            return -1;
        }));
    }

    private int readBytes(byte[] a, int begin, int length) {
        Predef$.MODULE$.require(this.detachedChunk().nonEmpty(), InputStreamAdapter::readBytes$$anonfun$1);
        int availableInChunk = ((SeqOps)this.detachedChunk().get()).size();
        int readBytes = this.getData(a, begin, length, 0);
        if (readBytes >= availableInChunk) {
            this.sendToStage.apply((Object)InputStreamSinkStage$ReadElementAcknowledgement$.MODULE$);
        }
        return readBytes;
    }

    @Override
    public void close() throws IOException {
        if (this.isActive().getAndSet(false)) {
            if (this.isStageAlive()) {
                this.sendToStage.apply((Object)InputStreamSinkStage$Close$.MODULE$);
                return;
            }
            return;
        }
    }

    private int getData(byte[] arr, int begin, int length, int gotBytes) {
        Option<ByteString> option;
        while ((option = this.grabDataChunk()) instanceof Some) {
            ByteString data = (ByteString)((Some)option).value();
            int size = data.size();
            if (size <= length) {
                data.copyToArray((Object)arr, begin, size);
                this.detachedChunk_$eq((Option<ByteString>)None$.MODULE$);
                if (size == length) {
                    return gotBytes + size;
                }
                int n = begin + size;
                int n2 = length - size;
                int n3 = gotBytes + size;
                begin = n;
                length = n2;
                gotBytes = n3;
                continue;
            }
            data.copyToArray((Object)arr, begin, length);
            this.detachedChunk_$eq((Option<ByteString>)Some$.MODULE$.apply((Object)data.drop(length)));
            return gotBytes + length;
        }
        if (None$.MODULE$.equals(option)) {
            return gotBytes;
        }
        throw new MatchError(option);
    }

    private void waitIfNotInitialized() {
        if (!this.isInitialized()) {
            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = this.sharedBuffer.poll(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (InputStreamSinkStage$Initialized$.MODULE$.equals(streamToAdapterMessage)) {
                this.isInitialized_$eq(true);
                return;
            }
            if (streamToAdapterMessage == null) {
                throw new IOException(new StringBuilder(57).append("Timeout after ").append(this.readTimeout).append(" waiting for Initialized message from stage").toString());
            }
            InputStreamSinkStage.StreamToAdapterMessage entry = streamToAdapterMessage;
            Predef$.MODULE$.require(false, () -> InputStreamAdapter.waitIfNotInitialized$$anonfun$1(entry));
            return;
        }
    }

    private Option<ByteString> grabDataChunk() {
        Option<ByteString> option = this.detachedChunk();
        if (None$.MODULE$.equals(option)) {
            InputStreamSinkStage.StreamToAdapterMessage streamToAdapterMessage = (InputStreamSinkStage.StreamToAdapterMessage)this.sharedBuffer.poll();
            if (streamToAdapterMessage instanceof InputStreamSinkStage.Data) {
                ByteString byteString;
                InputStreamSinkStage.Data data = InputStreamSinkStage$Data$.MODULE$.unapply((InputStreamSinkStage.Data)streamToAdapterMessage);
                ByteString data2 = byteString = data._1();
                this.detachedChunk_$eq((Option<ByteString>)Some$.MODULE$.apply((Object)data2));
                return this.detachedChunk();
            }
            if (InputStreamSinkStage$Finished$.MODULE$.equals(streamToAdapterMessage)) {
                this.isStageAlive_$eq(false);
                return None$.MODULE$;
            }
            if (streamToAdapterMessage instanceof InputStreamSinkStage.Failed) {
                Throwable throwable;
                InputStreamSinkStage.Failed failed = InputStreamSinkStage$Failed$.MODULE$.unapply((InputStreamSinkStage.Failed)streamToAdapterMessage);
                Throwable e = throwable = failed._1();
                throw new IOException(e);
            }
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            return this.detachedChunk();
        }
        throw new MatchError(option);
    }

    private static final Object read$$anonfun$1() {
        return "array size must be >= 0";
    }

    private static final Object read$$anonfun$2() {
        return "begin must be >= 0";
    }

    private static final Object read$$anonfun$3() {
        return "length must be >= 0";
    }

    private static final Object read$$anonfun$4() {
        return "begin + length must be smaller or equal to the array length";
    }

    private static final Object readBytes$$anonfun$1() {
        return "Chunk must be pulled from shared buffer";
    }

    private static final Object waitIfNotInitialized$$anonfun$1(InputStreamSinkStage.StreamToAdapterMessage entry$1) {
        return new StringBuilder(52).append("First message must be Initialized notification, got ").append(entry$1).toString();
    }
}

