/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.Exceptions;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Reporter;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class ScaleGradient
implements Reporter {
    private LogoList colorLogoList = null;
    private double var = 0.0;
    private double min = 0.0;
    private double max = 0.0;
    static final int SIZE = 256;
    private static LogoList colorLogoListCache = null;
    private static int[][] gradientArray = null;

    public Syntax getSyntax() {
        int[] right = new int[]{Syntax.ListType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()};
        int ret = Syntax.ListType();
        return SyntaxJ.reporterSyntax((int[])right, (int)ret);
    }

    public Object report(Argument[] args, Context context) throws ExtensionException {
        double tempmax;
        double tempval;
        try {
            this.colorLogoList = args[0].getList();
            this.var = args[1].getDoubleValue();
            this.min = args[2].getDoubleValue();
            this.max = args[3].getDoubleValue();
        }
        catch (LogoException e) {
            throw new ExtensionException(e.getMessage());
        }
        for (int i = 0; i < this.colorLogoList.length(); ++i) {
            LogoList RGBList = this.colorLogoList.get(i) instanceof Double ? org.nlogo.api.Color.getRGBListByARGB((int)org.nlogo.api.Color.getARGBbyPremodulatedColorNumber((double)org.nlogo.api.Color.modulateDouble((double)((Double)this.colorLogoList.get(i))))) : (LogoList)this.colorLogoList.get(i);
            if (RGBList.length() == 4) {
                RGBList = RGBList.butLast();
            }
            this.validRGBList(RGBList);
        }
        double perc = 0.0;
        if (this.min > this.max) {
            if (this.var < this.max) {
                perc = 1.0;
            } else if (this.var > this.min) {
                perc = 0.0;
            } else {
                tempval = this.min - this.var;
                tempmax = this.min - this.max;
                perc = tempval / tempmax;
            }
        } else if (this.var > this.max) {
            perc = 1.0;
        } else if (this.var < this.min) {
            perc = 0.0;
        } else {
            tempval = this.var - this.min;
            tempmax = this.max - this.min;
            perc = tempval / tempmax;
        }
        int index = this.colorLogoList.size() < 3 ? (int)Math.round(perc * 255.0) : (int)Math.round(perc * (double)(255 + 256 * (this.colorLogoList.size() - 2)));
        if (colorLogoListCache == null || !colorLogoListCache.equals(this.colorLogoList)) {
            int i;
            colorLogoListCache = this.colorLogoList;
            ArrayList<Color> colorList = new ArrayList<Color>();
            for (i = 0; i < this.colorLogoList.length(); ++i) {
                LogoList RGBList = this.colorLogoList.get(i) instanceof Double ? org.nlogo.api.Color.getRGBListByARGB((int)org.nlogo.api.Color.getARGBbyPremodulatedColorNumber((double)org.nlogo.api.Color.modulateDouble((double)((Double)this.colorLogoList.get(i))))) : (LogoList)this.colorLogoList.get(i);
                if (RGBList.length() == 4) {
                    RGBList = RGBList.butLast();
                }
                Color color = new Color(((Double)RGBList.get(0)).intValue(), ((Double)RGBList.get(1)).intValue(), ((Double)RGBList.get(2)).intValue());
                colorList.add(color);
            }
            gradientArray = new int[256 * (colorList.size() - 1)][3];
            for (i = 0; i < colorList.size() - 1; ++i) {
                ColorGradient colorGradient = new ColorGradient((Color)colorList.get(i), (Color)colorList.get(i + 1), 256);
                for (int j = 0; j < 256; ++j) {
                    ScaleGradient.gradientArray[j + 256 * i] = colorGradient.getGradientRGBArray()[j];
                }
            }
        }
        LogoListBuilder gradientList = new LogoListBuilder();
        try {
            gradientList.add((Object)gradientArray[index][0]);
            gradientList.add((Object)gradientArray[index][1]);
            gradientList.add((Object)gradientArray[index][2]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExtensionException("Please e-mail send this error to bugs@ccl.northwestern.edu" + e.getMessage());
        }
        return gradientList.toLogoList();
    }

    private void validRGB(int c) throws ExtensionException {
        if (c < 0 || c > 255) {
            throw new ExtensionException("RGB values must be 0-255");
        }
    }

    void validRGBList(LogoList rgb) throws ExtensionException {
        if (rgb.size() == 3) {
            try {
                this.validRGB(((Double)rgb.get(0)).intValue());
                this.validRGB(((Double)rgb.get(1)).intValue());
                this.validRGB(((Double)rgb.get(2)).intValue());
                return;
            }
            catch (ClassCastException e) {
                Exceptions.ignore((Throwable)e);
            }
        } else {
            throw new ExtensionException("An rgb list must contain 3 numbers 0-255one of your rgb lists contains " + rgb.size() + "numbers");
        }
    }
}

