/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.time.Instant;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Method;
import sttp.model.Uri;
import sttp.model.headers.AcceptEncoding;
import sttp.model.headers.CacheDirective;
import sttp.model.headers.ContentRange;
import sttp.model.headers.Cookie;
import sttp.model.headers.CookieWithMeta;
import sttp.model.headers.ETag;
import sttp.model.headers.Origin;
import sttp.model.headers.Range;
import sttp.model.headers.WWWAuthenticateChallenge;

public class Header {
    private final String name;
    private final String value;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Header$.class.getDeclaredField("Rfc850DatetimeFormat$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Header$.class.getDeclaredField("GMT$lzy1"));

    public static Set<String> Rfc850WeekDays() {
        return Header$.MODULE$.Rfc850WeekDays();
    }

    public static Header accept(MediaType mediaType, Seq<MediaType> seq) {
        return Header$.MODULE$.accept(mediaType, seq);
    }

    public static Header accept(String string) {
        return Header$.MODULE$.accept(string);
    }

    public static Header acceptCharset(String string) {
        return Header$.MODULE$.acceptCharset(string);
    }

    public static Header acceptEncoding(AcceptEncoding acceptEncoding) {
        return Header$.MODULE$.acceptEncoding(acceptEncoding);
    }

    public static Header acceptEncoding(String string) {
        return Header$.MODULE$.acceptEncoding(string);
    }

    public static Header accessControlAllowCredentials(boolean bl) {
        return Header$.MODULE$.accessControlAllowCredentials(bl);
    }

    public static Header accessControlAllowHeaders(Seq<String> seq) {
        return Header$.MODULE$.accessControlAllowHeaders(seq);
    }

    public static Header accessControlAllowMethods(Seq<Method> seq) {
        return Header$.MODULE$.accessControlAllowMethods(seq);
    }

    public static Header accessControlAllowOrigin(String string) {
        return Header$.MODULE$.accessControlAllowOrigin(string);
    }

    public static Header accessControlExposeHeaders(Seq<String> seq) {
        return Header$.MODULE$.accessControlExposeHeaders(seq);
    }

    public static Header accessControlMaxAge(long l) {
        return Header$.MODULE$.accessControlMaxAge(l);
    }

    public static Header accessControlRequestHeaders(Seq<String> seq) {
        return Header$.MODULE$.accessControlRequestHeaders(seq);
    }

    public static Header accessControlRequestMethod(String string) {
        return Header$.MODULE$.accessControlRequestMethod(string);
    }

    public static Header apply(String string, String string2) {
        return Header$.MODULE$.apply(string, string2);
    }

    public static Header authorization(String string, String string2) {
        return Header$.MODULE$.authorization(string, string2);
    }

    public static Header cacheControl(CacheDirective cacheDirective, Seq<CacheDirective> seq) {
        return Header$.MODULE$.cacheControl(cacheDirective, seq);
    }

    public static Header cacheControl(Iterable<CacheDirective> iterable) {
        return Header$.MODULE$.cacheControl(iterable);
    }

    public static Header contentEncoding(String string) {
        return Header$.MODULE$.contentEncoding(string);
    }

    public static Header contentLength(long l) {
        return Header$.MODULE$.contentLength(l);
    }

    public static Header contentRange(ContentRange contentRange) {
        return Header$.MODULE$.contentRange(contentRange);
    }

    public static Header contentType(MediaType mediaType) {
        return Header$.MODULE$.contentType(mediaType);
    }

    public static Header cookie(Cookie cookie, Seq<Cookie> seq) {
        return Header$.MODULE$.cookie(cookie, seq);
    }

    public static Header etag(ETag eTag) {
        return Header$.MODULE$.etag(eTag);
    }

    public static Header etag(String string) {
        return Header$.MODULE$.etag(string);
    }

    public static Header expires(Instant instant) {
        return Header$.MODULE$.expires(instant);
    }

    public static Header ifModifiedSince(Instant instant) {
        return Header$.MODULE$.ifModifiedSince(instant);
    }

    public static Header ifNoneMatch(List<ETag> list) {
        return Header$.MODULE$.ifNoneMatch(list);
    }

    public static Header ifUnmodifiedSince(Instant instant) {
        return Header$.MODULE$.ifUnmodifiedSince(instant);
    }

    public static Header lastModified(Instant instant) {
        return Header$.MODULE$.lastModified(instant);
    }

    public static Header location(String string) {
        return Header$.MODULE$.location(string);
    }

    public static Header location(Uri uri) {
        return Header$.MODULE$.location(uri);
    }

    public static Header origin(Origin origin) {
        return Header$.MODULE$.origin(origin);
    }

    public static Either<String, Instant> parseHttpDate(String string) {
        return Header$.MODULE$.parseHttpDate(string);
    }

    public static Header proxyAuthorization(String string, String string2) {
        return Header$.MODULE$.proxyAuthorization(string, string2);
    }

    public static Header range(Range range) {
        return Header$.MODULE$.range(range);
    }

    public static Either<String, Header> safeApply(String string, String string2) {
        return Header$.MODULE$.safeApply(string, string2);
    }

    public static Header setCookie(CookieWithMeta cookieWithMeta) {
        return Header$.MODULE$.setCookie(cookieWithMeta);
    }

    public static String toHttpDateString(Instant instant) {
        return Header$.MODULE$.toHttpDateString(instant);
    }

    public static Option<Tuple2<String, String>> unapply(Header header) {
        return Header$.MODULE$.unapply(header);
    }

    public static Header unsafeApply(String string, String string2) {
        return Header$.MODULE$.unsafeApply(string, string2);
    }

    public static Instant unsafeParseHttpDate(String string) {
        return Header$.MODULE$.unsafeParseHttpDate(string);
    }

    public static Header userAgent(String string) {
        return Header$.MODULE$.userAgent(string);
    }

    public static Header vary(Seq<String> seq) {
        return Header$.MODULE$.vary(seq);
    }

    public static Header wwwAuthenticate(WWWAuthenticateChallenge wWWAuthenticateChallenge) {
        return Header$.MODULE$.wwwAuthenticate(wWWAuthenticateChallenge);
    }

    public static List<Header> wwwAuthenticate(WWWAuthenticateChallenge wWWAuthenticateChallenge, Seq<WWWAuthenticateChallenge> seq) {
        return Header$.MODULE$.wwwAuthenticate(wWWAuthenticateChallenge, seq);
    }

    public static Header xForwardedFor(String string, Seq<String> seq) {
        return Header$.MODULE$.xForwardedFor(string, seq);
    }

    public Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean is(String otherName) {
        return this.name().equalsIgnoreCase(otherName);
    }

    public String toString() {
        return new StringBuilder(2).append(this.name()).append(": ").append(this.value()).toString();
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.mixLast(this.name().toLowerCase().hashCode(), this.value().hashCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object h;
        Object object = that;
        if (object instanceof Object && this == (h = object)) {
            return true;
        }
        if (!(object instanceof Header)) return false;
        Header h2 = (Header)object;
        if (!this.is(h2.name())) return false;
        String string = this.value();
        String string2 = h2.value();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public String toStringSafe(Set<String> sensitiveHeaders) {
        return new StringBuilder(2).append(this.name()).append(": ").append(HeaderNames$.MODULE$.isSensitive(this.name(), (Set)sensitiveHeaders) ? "***" : this.value()).toString();
    }

    public Set<String> toStringSafe$default$1() {
        return HeaderNames$.MODULE$.SensitiveHeaders();
    }
}

