/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.geojson;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.myworldgis.io.PointZWrapper;
import org.myworldgis.io.geojson.GeoJsonConstants;
import org.myworldgis.netlogo.VectorDataset;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.File;

public class GeoJsonReader
implements GeoJsonConstants {
    private static final Map<String, VectorDataset.ShapeType> geoJsonStringTypesToShapeTypes;
    JSONObject geojson;
    GeometryFactory factory;
    VectorDataset.ShapeType shapeType;
    String geojsonShapeType;
    int size;
    int numProperties;
    Map<String, VectorDataset.PropertyType> propertyNamesToDatatypes;
    String[] propertyNames;
    VectorDataset.PropertyType[] propertyTypes;
    Geometry[] geometries;
    boolean shouldAddZField = false;
    boolean shouldWarnUnusedZ = false;
    Object[][] propertyValues;
    boolean containsDefaultValues;

    public GeoJsonReader(File file, GeometryFactory factory) throws IOException, ParseException, ExtensionException {
        this.factory = factory;
        this.containsDefaultValues = false;
        this.propertyNamesToDatatypes = new HashMap<String, VectorDataset.PropertyType>();
        InputStreamReader reader = new InputStreamReader(file.getInputStream());
        JSONParser parser = new JSONParser();
        this.geojson = (JSONObject)parser.parse((Reader)reader);
        String topLevelType = this.geojson.get((Object)"type").toString();
        if (topLevelType.equals("FeatureCollection")) {
            this.parseFeatureCollection();
        } else if (topLevelType.equals("Feature")) {
            this.parseSingleFeatureDataset();
        } else if (topLevelType.equals("Point") || topLevelType.equals("MultiPoint") || topLevelType.equals("LineString") || topLevelType.equals("MultiLineString") || topLevelType.equals("Polygon") || topLevelType.equals("MultiPolygon")) {
            this.parseSingleGeometryDataset();
        } else {
            throw new ExtensionException(topLevelType + " is not a supported GeoJSON type");
        }
    }

    private void extractShapeInfo(JSONObject geometry) throws ExtensionException {
        String geometryTypeString = geometry.get((Object)"type").toString();
        this.shapeType = GeoJsonReader.mapStringToShapeType(geometryTypeString);
        this.geojsonShapeType = geometryTypeString;
    }

    private void parseGeometryObject(JSONObject geometry, int featureIndex) throws ExtensionException {
        if (!geometry.get((Object)"type").toString().equals(this.geojsonShapeType)) {
            throw new ExtensionException("Only homogenous FeatureCollections are supported");
        }
        JSONArray coordinates = (JSONArray)geometry.get((Object)"coordinates");
        this.geometries[featureIndex] = this.parseCoordinates(coordinates, this.geojsonShapeType);
    }

    private void extractSchemaFromFeatures(JSONArray features) throws ExtensionException {
        for (Object featureObj : features) {
            JSONObject feature = (JSONObject)featureObj;
            this.parseSchemaOfSingleFeature(feature);
        }
    }

    public void parseSchemaOfSingleFeature(JSONObject feature) throws ExtensionException {
        JSONObject properties = (JSONObject)feature.get((Object)"properties");
        for (Object entryObj : properties.entrySet()) {
            Map.Entry entry = (Map.Entry)entryObj;
            if (this.propertyNamesToDatatypes.containsKey(entry.getKey())) {
                VectorDataset.PropertyType newType;
                VectorDataset.PropertyType existingType = this.propertyNamesToDatatypes.get(entry.getKey());
                if (existingType == (newType = GeoJsonReader.getPropertyTypeForValue(entry.getValue()))) continue;
                throw new ExtensionException("All features properties of the same name must be of the same datatype. The property " + (String)entry.getKey() + "has one value of type of " + existingType.toString() + "and one property type of " + newType.toString());
            }
            this.propertyNamesToDatatypes.put((String)entry.getKey(), GeoJsonReader.getPropertyTypeForValue(entry.getValue()));
        }
    }

    private void finalizeSchema() {
        this.numProperties = this.propertyNamesToDatatypes.size();
        this.propertyNames = new String[this.numProperties];
        this.propertyTypes = new VectorDataset.PropertyType[this.numProperties];
        int i = 0;
        for (Map.Entry<String, VectorDataset.PropertyType> property : this.propertyNamesToDatatypes.entrySet()) {
            this.propertyNames[i] = property.getKey();
            this.propertyTypes[i] = property.getValue();
            ++i;
        }
    }

    public void parseFeatureObject(JSONObject feature, int featureIndex) throws ExtensionException {
        JSONObject geometry = (JSONObject)feature.get((Object)"geometry");
        this.parseGeometryObject(geometry, featureIndex);
        Object[] thesePropertyValues = new Object[this.numProperties];
        JSONObject propertiesObject = (JSONObject)feature.get((Object)"properties");
        for (int i = 0; i < this.numProperties; ++i) {
            VectorDataset.PropertyType thisPropertyType = this.propertyTypes[i];
            if (!propertiesObject.containsKey((Object)this.propertyNames[i])) {
                this.containsDefaultValues = true;
                if (thisPropertyType == VectorDataset.PropertyType.NUMBER) {
                    thesePropertyValues[i] = 0.0;
                    continue;
                }
                thesePropertyValues[i] = "";
                continue;
            }
            Object thisPropertyValue = propertiesObject.get((Object)this.propertyNames[i]);
            thesePropertyValues[i] = thisPropertyType == VectorDataset.PropertyType.NUMBER ? Double.valueOf(((Number)thisPropertyValue).doubleValue()) : (thisPropertyValue instanceof JSONObject ? ((JSONObject)thisPropertyValue).toJSONString() : thisPropertyValue.toString());
        }
        this.propertyValues[featureIndex] = thesePropertyValues;
    }

    public void parseFeatureCollection() throws ExtensionException {
        JSONArray features = (JSONArray)this.geojson.get((Object)"features");
        if (features.size() < 1) {
            throw new ExtensionException("Each FeatureCollection must have at least one feature.");
        }
        this.size = features.size();
        this.geometries = new Geometry[this.size];
        this.propertyValues = new Object[this.size][];
        JSONObject firstFeature = (JSONObject)features.get(0);
        this.extractShapeInfo((JSONObject)firstFeature.get((Object)"geometry"));
        this.extractSchemaFromFeatures(features);
        this.finalizeSchema();
        int featureIndex = 0;
        for (Object featureObj : features) {
            JSONObject feature = (JSONObject)featureObj;
            this.parseFeatureObject(feature, featureIndex);
            ++featureIndex;
        }
    }

    public void parseSingleFeatureDataset() throws ExtensionException {
        this.size = 1;
        this.geometries = new Geometry[this.size];
        this.propertyValues = new Object[this.size][];
        JSONObject firstFeature = this.geojson;
        this.extractShapeInfo((JSONObject)firstFeature.get((Object)"geometry"));
        this.parseSchemaOfSingleFeature(firstFeature);
        this.finalizeSchema();
        this.parseFeatureObject(firstFeature, 0);
    }

    public void parseSingleGeometryDataset() throws ExtensionException {
        this.size = 1;
        this.geometries = new Geometry[this.size];
        this.propertyValues = new Object[this.size][0];
        this.extractShapeInfo(this.geojson);
        this.finalizeSchema();
        this.parseGeometryObject(this.geojson, 0);
    }

    public int size() {
        return this.size;
    }

    public VectorDataset.ShapeType getShapeType() {
        return this.shapeType;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public VectorDataset.PropertyType[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public Geometry[] getGeometries() {
        return this.geometries;
    }

    public Object[][] getPropertyValues() {
        return this.propertyValues;
    }

    public boolean getContainsDefaultValues() {
        return this.containsDefaultValues;
    }

    public boolean getShouldAddZField() {
        return this.shouldAddZField;
    }

    public boolean getShouldWarnUnusedZ() {
        return this.shouldWarnUnusedZ;
    }

    private Geometry parseCoordinates(JSONArray coordinates, String geojsonShapeType) throws ExtensionException {
        switch (geojsonShapeType) {
            case "Point": {
                Point p = this.factory.createPoint(this.JSONPairToCoordinate(coordinates));
                if (coordinates.size() == 3) {
                    this.shouldAddZField = true;
                    return new PointZWrapper(p, ((Number)coordinates.get(2)).doubleValue());
                }
                return p;
            }
            case "MultiPoint": {
                Coordinate[] pointCoords = new Coordinate[coordinates.size()];
                for (int i = 0; i < coordinates.size(); ++i) {
                    pointCoords[i] = this.JSONPairToCoordinate((JSONArray)coordinates.get(i));
                }
                MultiPoint points = this.factory.createMultiPointFromCoords(pointCoords);
                return points;
            }
            case "LineString": {
                return this.parseSingleLineString(coordinates);
            }
            case "MultiLineString": {
                LineString[] subLines = new LineString[coordinates.size()];
                for (int i = 0; i < coordinates.size(); ++i) {
                    subLines[i] = this.parseSingleLineString((JSONArray)coordinates.get(i));
                }
                MultiLineString lines = this.factory.createMultiLineString(subLines);
                return lines;
            }
            case "Polygon": {
                return this.parseSingleComplexPolygon(coordinates);
            }
            case "MultiPolygon": {
                if (coordinates.size() < 1) {
                    throw new ExtensionException("One of the MultiPolygons has no polygons within it");
                }
                Polygon[] subPolygons = new Polygon[coordinates.size()];
                for (int i = 0; i < coordinates.size(); ++i) {
                    subPolygons[i] = this.parseSingleComplexPolygon((JSONArray)coordinates.get(i));
                }
                MultiPolygon polygons = this.factory.createMultiPolygon(subPolygons);
                return polygons;
            }
        }
        throw new ExtensionException(geojsonShapeType + " is not a supported geojson shape type");
    }

    private LineString parseSingleLineString(JSONArray coordinates) throws ExtensionException {
        Coordinate[] linePoints = new Coordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            linePoints[i] = this.JSONPairToCoordinate((JSONArray)coordinates.get(i));
        }
        LineString line = this.factory.createLineString(linePoints);
        return line;
    }

    private Polygon parseSingleComplexPolygon(JSONArray coordinates) throws ExtensionException {
        if (coordinates.size() < 1) {
            throw new ExtensionException("Empty polygon in geojson file");
        }
        int numRings = coordinates.size();
        int numHoles = numRings - 1;
        JSONArray shellArr = (JSONArray)coordinates.get(0);
        Coordinate[] shellCoords = new Coordinate[shellArr.size()];
        for (int j = 0; j < shellArr.size(); ++j) {
            shellCoords[j] = this.JSONPairToCoordinate((JSONArray)shellArr.get(j));
        }
        LinearRing shell = this.factory.createLinearRing(shellCoords);
        Coordinate[][] holeCoords = new Coordinate[numHoles][];
        LinearRing[] holeRings = new LinearRing[numHoles];
        for (int i = 0; i < numHoles; ++i) {
            JSONArray thisRing = (JSONArray)coordinates.get(i + 1);
            holeCoords[i] = new Coordinate[thisRing.size()];
            for (int j = 0; j < thisRing.size(); ++j) {
                holeCoords[i][j] = this.JSONPairToCoordinate((JSONArray)thisRing.get(j));
            }
            holeRings[i] = this.factory.createLinearRing(holeCoords[i]);
        }
        Polygon polygon = this.factory.createPolygon(shell, holeRings);
        return polygon;
    }

    private Coordinate JSONPairToCoordinate(JSONArray arr) {
        if (arr.size() > 2) {
            this.shouldWarnUnusedZ = true;
        }
        return new Coordinate(((Number)arr.get(0)).doubleValue(), ((Number)arr.get(1)).doubleValue());
    }

    private static VectorDataset.ShapeType mapStringToShapeType(String str) throws ExtensionException {
        if (geoJsonStringTypesToShapeTypes.containsKey(str)) {
            return geoJsonStringTypesToShapeTypes.get(str);
        }
        throw new ExtensionException(str + "is not a supported geojson geometry type");
    }

    private static VectorDataset.PropertyType getPropertyTypeForValue(Object obj) throws ExtensionException {
        if (obj instanceof Number) {
            return VectorDataset.PropertyType.NUMBER;
        }
        return VectorDataset.PropertyType.STRING;
    }

    static {
        HashMap<String, VectorDataset.ShapeType> tmpMap = new HashMap<String, VectorDataset.ShapeType>();
        tmpMap.put("Point", VectorDataset.ShapeType.POINT);
        tmpMap.put("MultiPoint", VectorDataset.ShapeType.POINT);
        tmpMap.put("LineString", VectorDataset.ShapeType.LINE);
        tmpMap.put("MultiLineString", VectorDataset.ShapeType.LINE);
        tmpMap.put("Polygon", VectorDataset.ShapeType.POLYGON);
        tmpMap.put("MultiPolygon", VectorDataset.ShapeType.POLYGON);
        geoJsonStringTypesToShapeTypes = Collections.unmodifiableMap(tmpMap);
    }
}

