/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import org.myworldgis.io.shapefile.DBaseBuffer;
import org.myworldgis.io.shapefile.DBaseConstants;
import org.myworldgis.io.shapefile.DBaseFieldDescriptor;

public final class DBaseFileWriter
implements DBaseConstants {
    private RandomAccessFile _raf;
    private DBaseBuffer _buffer;
    private int _headerSize;
    private DBaseFieldDescriptor[] _fieldDescriptors;
    private int _recordLength;
    private int _recordCount;

    public DBaseFileWriter(RandomAccessFile file, DBaseFieldDescriptor[] fieldDescriptors) throws IOException {
        int i;
        this._raf = file;
        this._buffer = new DBaseBuffer();
        String[] fieldNames = new String[fieldDescriptors.length];
        for (i = 0; i < fieldDescriptors.length; ++i) {
            fieldNames[i] = fieldDescriptors[i].getName();
        }
        fieldNames = DBaseFieldDescriptor.makeLegalFieldNames(fieldNames);
        this._fieldDescriptors = new DBaseFieldDescriptor[fieldDescriptors.length];
        for (i = 0; i < fieldDescriptors.length; ++i) {
            this._fieldDescriptors[i] = new DBaseFieldDescriptor(fieldDescriptors[i].getType(), fieldNames[i], fieldDescriptors[i].getLength(), fieldDescriptors[i].getDecimalCount());
        }
        this.writeHeader();
        this.writeFileTerminator();
        this._raf.seek(this._headerSize);
    }

    private void writeHeader() throws IOException {
        this._headerSize = 32 + 32 * this._fieldDescriptors.length + 1;
        this._buffer.ensureCapacity(this._headerSize);
        this._buffer.clear(0, this._headerSize);
        this._buffer.putByte(0, (byte)3);
        this._buffer.putHeaderDate(1, new Date(System.currentTimeMillis()));
        this._buffer.putInt(4, this._recordCount);
        this._buffer.putShort(8, (short)this._headerSize);
        this._buffer.putByte(29, (byte)1);
        this._recordLength = 1;
        int offset = 32;
        for (int i = 0; i < this._fieldDescriptors.length; ++i) {
            this._buffer.putFieldDescriptor(offset, this._fieldDescriptors[i]);
            offset += 32;
            this._recordLength += this._fieldDescriptors[i].getLength();
        }
        this._buffer.ensureCapacity(this._recordLength);
        this._buffer.putShort(10, (short)this._recordLength);
        this._buffer.putByte(this._headerSize - 1, (byte)13);
        this._raf.seek(0L);
        this._buffer.write(this._raf, 0, this._headerSize);
    }

    private void writeFileTerminator() throws IOException {
        this._raf.seek(this._headerSize + this._recordLength * this._recordCount);
        this._raf.write(26);
    }

    public void writeRecord(Object[] record) throws IOException {
        if (record.length != this._fieldDescriptors.length) {
            throw new IOException("incompatable number of fields in writeRecord (record has " + record.length + " fields, file has " + this._fieldDescriptors.length + ")");
        }
        this._buffer.clear(0, this._recordLength);
        this._buffer.putRecord(0, this._fieldDescriptors, record);
        this._raf.seek(this._headerSize + this._recordLength * this._recordCount);
        this._buffer.write(this._raf, 0, this._recordLength);
        ++this._recordCount;
    }

    public void close() throws IOException {
        this.writeHeader();
        this.writeFileTerminator();
        this._raf.close();
    }
}

