/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.locationtech.jts.geom.GeometryFactory;
import org.myworldgis.io.shapefile.ESRIShapeBuffer;
import org.myworldgis.io.shapefile.ESRIShapeConstants;
import org.myworldgis.io.shapefile.ESRIShapeIndexRecord;
import org.myworldgis.util.Buffer;
import org.ngs.ngunits.UnitConverter;

public final class ESRIShapeIndexReader
implements ESRIShapeConstants {
    private RandomAccessFile _file;
    private ESRIShapeBuffer _buffer;
    private int _shapeType;
    private int _fileSizeBytes;

    public ESRIShapeIndexReader(RandomAccessFile file, UnitConverter fileToRadians, GeometryFactory factory) throws IOException {
        this._file = file;
        this._file.seek(0L);
        this._buffer = new ESRIShapeBuffer(50000, fileToRadians, factory);
        this._buffer.read(this._file, 0, 100);
        this._shapeType = this._buffer.getInt(32);
        this._buffer.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        this._fileSizeBytes = this._buffer.getInt(24) * 2;
    }

    public int getShapeType() {
        return this._shapeType;
    }

    public int getShapeCount() {
        return (this._fileSizeBytes - 100) / 8;
    }

    public ESRIShapeIndexRecord getIndexRecord(int index) throws IOException {
        if (this._file == null) {
            throw new IOException("attempted to read from closed file");
        }
        this._file.seek(100 + index * 8);
        int bytesRead = this._buffer.read(this._file, 0, 8);
        if (bytesRead < 8) {
            return null;
        }
        return new ESRIShapeIndexRecord(this._buffer.getInt(0) * 2, this._buffer.getInt(4) * 2);
    }

    public void close() throws IOException {
        this._file.close();
    }
}

