/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.awt.Dimension;
import java.awt.image.WritableRaster;
import org.locationtech.jts.geom.Envelope;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.nlogo.api.AgentException;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Patch;
import org.nlogo.api.World;
import org.nlogo.core.Reference;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class ApplyRaster
extends GISExtension.Command {
    public String getAgentClassString() {
        return "O";
    }

    public Syntax getSyntax() {
        return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.ReferenceType()});
    }

    @Override
    public void performInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
        RasterDataset dataset = RasterDataset.getDataset(args[0]);
        World world = context.getAgent().world();
        Reference patchVar = ((org.nlogo.nvm.Argument)args[1]).getReference();
        Envelope gisEnvelope = GISExtension.getState().getTransformation().getEnvelope(world);
        Dimension gridSize = new Dimension(world.worldWidth(), world.worldHeight());
        RasterDataset resampledDataset = dataset.resample(new GridDimensions(gridSize, gisEnvelope));
        WritableRaster raster = resampledDataset.getRaster();
        int px = world.minPxcor();
        int ix = 0;
        while (px <= world.maxPxcor()) {
            int py = world.minPycor();
            int iy = raster.getHeight() - 1;
            while (py <= world.maxPycor()) {
                Patch p = world.fastGetPatchAt(px, py);
                p.setVariable(patchVar.vn(), (Object)raster.getSampleDouble(ix, iy, 0));
                ++py;
                --iy;
            }
            ++px;
            ++ix;
        }
    }
}

