/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.text.ParseException;
import org.locationtech.jts.geom.Envelope;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;

public final class EnvelopeLogoListFormat {
    private static final EnvelopeLogoListFormat _instance = new EnvelopeLogoListFormat();

    public static EnvelopeLogoListFormat getInstance() {
        return _instance;
    }

    private EnvelopeLogoListFormat() {
    }

    public Envelope parse(LogoList list) throws ParseException {
        if (list.size() != 4) {
            throw new ParseException("expected a four-element list: " + Dump.logoObject((Object)list), 0);
        }
        Object minX = list.get(0);
        if (!(minX instanceof Number)) {
            throw new ParseException("not a number: " + minX, 0);
        }
        Object maxX = list.get(1);
        if (!(maxX instanceof Number)) {
            throw new ParseException("not a number: " + maxX, 1);
        }
        Object minY = list.get(2);
        if (!(minY instanceof Number)) {
            throw new ParseException("not a number: " + minY, 2);
        }
        Object maxY = list.get(3);
        if (!(maxY instanceof Number)) {
            throw new ParseException("not a number: " + maxY, 3);
        }
        return new Envelope(((Number)minX).doubleValue(), ((Number)maxX).doubleValue(), ((Number)minY).doubleValue(), ((Number)maxY).doubleValue());
    }

    public LogoList format(Envelope envelope) {
        LogoListBuilder result = new LogoListBuilder();
        result.add((Object)envelope.getMinX());
        result.add((Object)envelope.getMaxX());
        result.add((Object)envelope.getMinY());
        result.add((Object)envelope.getMaxY());
        return result.toLogoList();
    }
}

