/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.awt.Dimension;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.myworldgis.netlogo.VectorDataset;
import org.nlogo.core.ExtensionObject;

public final class GridDimensions
implements Cloneable,
ExtensionObject {
    private final Dimension _size;
    private final Envelope _envelope;

    public GridDimensions(int gridWidth, int gridHeight, float cellWidth, float cellHeight, float originX, float originY) {
        this._size = new Dimension(gridWidth, gridHeight);
        this._envelope = new Envelope((double)originX, (double)(originX + (float)gridWidth * cellWidth), (double)originY, (double)(originY + (float)gridHeight * cellHeight));
    }

    public GridDimensions(Dimension size, Envelope envelope) {
        this._size = new Dimension(size.width, size.height);
        this._envelope = new Envelope(envelope);
    }

    public int getGridWidth() {
        return this._size.width;
    }

    public int getGridHeight() {
        return this._size.height;
    }

    public int getCellCount() {
        return this._size.width * this._size.height;
    }

    public double getCellWidth() {
        return this._envelope.getWidth() / (double)this._size.width;
    }

    public double getCellHeight() {
        return this._envelope.getHeight() / (double)this._size.height;
    }

    public double getLeft() {
        return this._envelope.getMinX();
    }

    public double getRight() {
        return this._envelope.getMaxX();
    }

    public double getBottom() {
        return this._envelope.getMinY();
    }

    public double getTop() {
        return this._envelope.getMaxY();
    }

    public double getWidth() {
        return this._envelope.getWidth();
    }

    public double getHeight() {
        return this._envelope.getHeight();
    }

    public double getColumnLeft(int column) {
        return this._envelope.getMinX() + this.getCellWidth() * (double)column;
    }

    public double getColumnCenter(int column) {
        double cellWidth = this.getCellWidth();
        return this._envelope.getMinX() + cellWidth * (double)column + cellWidth * 0.5;
    }

    public double getColumnRight(int column) {
        return this._envelope.getMinX() + this.getCellWidth() * (double)(column + 1);
    }

    public double getRowBottom(int row) {
        return this._envelope.getMinY() + this.getCellHeight() * (double)row;
    }

    public double getRowCenter(int row) {
        double cellHeight = this.getCellHeight();
        return this._envelope.getMinY() + cellHeight * (double)row + cellHeight * 0.5;
    }

    public double getRowTop(int row) {
        return this._envelope.getMinY() + this.getCellHeight() * (double)(row + 1);
    }

    public int getColumn(double x) {
        int column = (int)StrictMath.floor((x - this._envelope.getMinX()) / this.getCellWidth());
        if (column >= 0 && column < this._size.width) {
            return column;
        }
        return -1;
    }

    public int getRow(double y) {
        int row = (int)StrictMath.floor((y - this._envelope.getMinY()) / this.getCellHeight());
        if (row >= 0 && row < this._size.height) {
            return row;
        }
        return -1;
    }

    public Dimension getGridSize() {
        return new Dimension(this._size);
    }

    public Envelope getEnvelope() {
        return new Envelope(this._envelope);
    }

    public Coordinate gisToGrid(Coordinate coord, Coordinate storage) {
        double gridX;
        if (storage == null) {
            storage = new Coordinate();
        }
        storage.x = (gridX = (coord.x - this._envelope.getMinX()) / this.getCellWidth()) >= 0.0 && gridX <= (double)this._size.width ? gridX : Double.NaN;
        double gridY = (coord.y - this._envelope.getMinY()) / this.getCellHeight();
        storage.y = gridY >= 0.0 && gridY <= (double)this._size.height ? gridY : Double.NaN;
        return storage;
    }

    public Coordinate gridToGIS(Coordinate coord, Coordinate storage) {
        if (storage == null) {
            storage = new Coordinate();
        }
        storage.x = coord.x >= 0.0 && coord.x <= (double)this._size.width ? this._envelope.getMinX() + coord.x * this.getCellWidth() : Double.NaN;
        storage.y = coord.y >= 0.0 && coord.y <= (double)this._size.height ? this._envelope.getMinY() + coord.y * this.getCellHeight() : Double.NaN;
        return storage;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GridDimensions[width=");
        buffer.append(this._size.width);
        buffer.append(",height=");
        buffer.append(this._size.height);
        buffer.append(",");
        buffer.append(this._envelope.toString());
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GridDimensions) {
            GridDimensions dim = (GridDimensions)obj;
            return dim._size.equals(this._size) && dim._envelope.equals((Object)this._envelope);
        }
        return false;
    }

    public int hashCode() {
        return (int)(Math.pow(2.0, this._size.hashCode()) * Math.pow(3.0, this._envelope.hashCode()) % 2.147483647E9);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            InternalError err = new InternalError("this should never happen");
            err.initCause(e);
            throw err;
        }
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        return "";
    }

    public String getExtensionName() {
        return "gis";
    }

    public String getNLTypeName() {
        return "GridDimensions";
    }

    public boolean recursivelyEqual(Object obj) {
        if (obj instanceof VectorDataset) {
            GridDimensions gd = (GridDimensions)obj;
            return gd == this;
        }
        return false;
    }
}

