/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.locationtech.jts.algorithm.Centroid;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.Vertex;
import org.myworldgis.util.TriangulationUtil;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.Nobody$;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public final class VectorFeature
implements ExtensionObject {
    private VectorDataset.ShapeType _shapeType;
    private Geometry _geometry;
    private Map<String, Object> _properties;
    private Geometry _triangulation;
    private double[] _triangulation_areas_cumulative;
    private double _total_area;

    static VectorFeature getFeature(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (obj instanceof VectorFeature) {
            return (VectorFeature)obj;
        }
        throw new ExtensionException("not a VectorFeature: " + obj);
    }

    public VectorFeature(VectorDataset.ShapeType shapeType, Geometry geometry, VectorDataset.Property[] properties, Object[] propertyValues) {
        this._shapeType = shapeType;
        this._geometry = geometry;
        this._properties = new HashMap<String, Object>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            this._properties.put(properties[i].getName(), propertyValues[i]);
        }
    }

    public VectorDataset.ShapeType getShapeType() {
        return this._shapeType;
    }

    public Envelope getEnvelope() {
        return this._geometry.getEnvelopeInternal();
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    public boolean hasProperty(String name) {
        return this._properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this._properties.get(name.toUpperCase());
    }

    public String[] getPropertyNames() {
        return this._properties.keySet().toArray(new String[0]);
    }

    private void setupTriangulation() throws ExtensionException {
        try {
            this._triangulation = TriangulationUtil.triangulate(this._geometry);
            int numTriangles = this._triangulation.getNumGeometries();
            this._triangulation_areas_cumulative = new double[numTriangles];
            for (int i = 0; i < numTriangles; ++i) {
                double thisTriangleArea = this._triangulation.getGeometryN(i).getArea();
                this._total_area += thisTriangleArea;
                this._triangulation_areas_cumulative[i] = this._total_area;
            }
        }
        catch (Exception e) {
            if (e instanceof ExtensionException) {
                throw e;
            }
            throw new ExtensionException("There was an error trying to generate a point inside the following polygon. Points can only be generated inside polygons with non-zero area *after* being projected into the current coordinate system. Did all of your data import and project how you expected it to?" + this.dump(true, false, false) + "\n");
        }
    }

    private static Coordinate randomPointInsideTriangle(Geometry tri, Random rng) {
        double weight_b = rng.nextDouble();
        double weight_c = rng.nextDouble();
        Coordinate[] coords = tri.getCoordinates();
        Coordinate p_a = coords[0];
        Coordinate p_b = coords[1];
        Coordinate p_c = coords[2];
        if (weight_b + weight_c > 1.0) {
            weight_b = 1.0 - weight_b;
            weight_c = 1.0 - weight_c;
        }
        double b_x = weight_b * (p_b.x - p_a.x);
        double b_y = weight_b * (p_b.y - p_a.y);
        double c_x = weight_c * (p_c.x - p_a.x);
        double c_y = weight_c * (p_c.y - p_a.y);
        double x = b_x + c_x + p_a.x;
        double y = b_y + c_y + p_a.y;
        return new Coordinate(x, y);
    }

    private Geometry getRandomTriangleWeightedByArea(Random rng) {
        double randBetween = rng.nextDouble() * this._total_area;
        int triangleIndex = -Arrays.binarySearch(this._triangulation_areas_cumulative, randBetween) - 1;
        return this._triangulation.getGeometryN(triangleIndex);
    }

    public Coordinate getRandomPointInsidePolygon(Random rng) throws ExtensionException {
        if (this.getShapeType() != VectorDataset.ShapeType.POLYGON) {
            throw new ExtensionException("Tried to get a point inside of a non-polygon vector feature");
        }
        if (this._triangulation == null) {
            this.setupTriangulation();
        }
        Geometry chosenTriangle = this.getRandomTriangleWeightedByArea(rng);
        return VectorFeature.randomPointInsideTriangle(chosenTriangle, rng);
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        StringBuffer buffer = new StringBuffer();
        for (String propertyName : this._properties.keySet()) {
            buffer.append("[\"");
            buffer.append(propertyName);
            buffer.append("\":\"");
            buffer.append(this._properties.get(propertyName));
            buffer.append("\"]");
        }
        return buffer.toString();
    }

    public String getExtensionName() {
        return "gis";
    }

    public String getNLTypeName() {
        return "VectorFeature";
    }

    public boolean recursivelyEqual(Object obj) {
        if (obj instanceof VectorFeature) {
            VectorFeature vf = (VectorFeature)obj;
            return vf == this;
        }
        return false;
    }

    public static final class GetRandomPointInside
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            Coordinate out = feature.getRandomPointInsidePolygon((Random)context.getRNG());
            return new Vertex(out);
        }
    }

    public static final class GetCentroid
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            Centroid cp = new Centroid(feature.getGeometry());
            return new Vertex(cp.getCentroid());
        }
    }

    public static final class GetVertexLists
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            final LogoListBuilder result = new LogoListBuilder();
            feature.getGeometry().apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof Point) {
                        LogoListBuilder list = new LogoListBuilder();
                        list.add((Object)new Vertex(((Point)geom).getCoordinate()));
                        result.add((Object)list.toLogoList());
                    } else if (geom instanceof LineString) {
                        LineString ls = (LineString)geom;
                        LogoListBuilder list = new LogoListBuilder();
                        for (int i = 0; i < ls.getNumPoints(); ++i) {
                            list.add((Object)new Vertex(ls.getCoordinateN(i)));
                        }
                        result.add((Object)list.toLogoList());
                    }
                }
            });
            return result.toLogoList();
        }
    }

    public static final class SetProperty
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType(), Syntax.StringType() | Syntax.NumberType()});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void performInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            String key;
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            if (!feature.hasProperty(key = args[1].getString().toUpperCase())) {
                throw new ExtensionException("feature does not have property '" + key + "'");
            }
            Object value = args[2].get();
            if (value instanceof String) {
                if (!(feature.getProperty(key) instanceof String)) throw new ExtensionException("Tried to set a string property to a number value");
                feature._properties.put(key, value);
                return;
            } else {
                if (!(feature.getProperty(key) instanceof Number)) throw new ExtensionException("Tried to set a numeric property to a string value");
                feature._properties.put(key, value);
            }
        }
    }

    public static final class GetProperty
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType()}, (int)Syntax.ReadableType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            String key;
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            if (feature.hasProperty(key = args[1].getString().toUpperCase())) {
                Object result = feature.getProperty(key);
                if (result == null) {
                    return Nobody$.MODULE$;
                }
                return result;
            }
            throw new ExtensionException("feature does not have property '" + key + "'");
        }
    }
}

