/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import java.text.ParseException;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.HemisphericalProjection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.projection.ProjectionUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public abstract class Conic
extends HemisphericalProjection {
    public static final String STANDARD_PARALLEL_1_PROPERTY = "standard_parallel_1";
    public static final String STANDARD_PARALLEL_2_PROPERTY = "standard_parallel_2";
    protected static final transient Coordinate NORTH_POLE = new Coordinate(0.0, 1.5707963267948966);
    protected static final transient Coordinate SOUTH_POLE = new Coordinate(0.0, -1.5707963267948966);
    protected double _phi1;
    protected double _phi2;

    public Conic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double phi1, double phi2) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._phi1 = phi1;
        this._phi2 = phi2;
        if (StrictMath.abs(this._phi2) == StrictMath.abs(this._phi1)) {
            this._phi2 += this._phi2 * 0.01;
        }
    }

    public Conic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._phi1 = parameters.getAngularParameter(STANDARD_PARALLEL_1_PROPERTY);
        this._phi2 = parameters.getAngularParameter(STANDARD_PARALLEL_2_PROPERTY);
        if (StrictMath.abs(this._phi2) == StrictMath.abs(this._phi1)) {
            this._phi2 += this._phi2 * 0.01;
        }
    }

    public double getStandardParallel1() {
        return this._phi1;
    }

    public void setStandardParallel1(double newPhi1) {
        if (newPhi1 != this._phi1) {
            this._phi1 = newPhi1;
            if (this._phi2 == -this._phi1) {
                this._phi2 += this._phi2 * 0.01;
            }
            this.computeParameters();
        }
    }

    public double getStandardParallel2() {
        return this._phi2;
    }

    public void setStandardParallel2(double newPhi2) {
        if (newPhi2 != this._phi2) {
            this._phi2 = newPhi2;
            if (this._phi2 == -this._phi1) {
                this._phi2 += this._phi2 * 0.01;
            }
            this.computeParameters();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Conic proj = (Conic)obj;
            return StrictMath.abs(proj._phi1 - this._phi1) < 1.567855942887398E-7 && StrictMath.abs(proj._phi2 - this._phi2) < 1.567855942887398E-7;
        }
        return false;
    }

    @Override
    protected Coordinate getHemisphereCenter() {
        return this._phi0 >= 0.0 ? NORTH_POLE : SOUTH_POLE;
    }

    @Override
    protected double getMaxC() {
        return 2.356194490192345;
    }

    @Override
    public MultiPolygon process(Polygon poly) {
        GeometryFactory factory = poly.getFactory();
        MultiPolygon mp = ProjectionUtils.wrap(poly, this._lambda0);
        ArrayList<Polygon> result = new ArrayList<Polygon>(mp.getNumGeometries());
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            MultiPolygon clippedPoly = super.process((Polygon)mp.getGeometryN(i));
            for (int j = 0; j < clippedPoly.getNumGeometries(); ++j) {
                result.add((Polygon)clippedPoly.getGeometryN(j));
            }
        }
        return factory.createMultiPolygon(result.toArray(new Polygon[result.size()]));
    }

    @Override
    public MultiLineString process(LineString line) {
        GeometryFactory factory = line.getFactory();
        MultiLineString mls = ProjectionUtils.wrap(line, this._lambda0);
        ArrayList<LineString> result = new ArrayList<LineString>(mls.getNumGeometries());
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            MultiLineString clippedLine = super.process((LineString)mls.getGeometryN(i));
            for (int j = 0; j < clippedLine.getNumGeometries(); ++j) {
                result.add((LineString)clippedLine.getGeometryN(j));
            }
        }
        return factory.createMultiLineString(result.toArray(new LineString[result.size()]));
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(STANDARD_PARALLEL_1_PROPERTY, this._phi1, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(STANDARD_PARALLEL_2_PROPERTY, this._phi2, (Unit<Angle>)SI.RADIAN);
        return result;
    }
}

