/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import java.text.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.myworldgis.projection.Conic;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public final class EquidistantConic
extends Conic {
    public static final String WKT_NAME = "Equidistant_Conic";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_center";
    private double _n;
    private double _aG;
    private double _rho0;
    private double[] _subM;
    private double[] _subPhi;

    public EquidistantConic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double phi1, double phi2) {
        super(ellipsoid, center, units, falseEasting, falseNorthing, phi1, phi2);
        this._name = WKT_NAME;
        this._subM = new double[4];
        this._subPhi = new double[4];
        this.computeParameters();
    }

    public EquidistantConic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._subM = new double[4];
        this._subPhi = new double[4];
        this.computeParameters();
    }

    private double getm(double phi) {
        double sinPhi = StrictMath.sin(phi);
        return StrictMath.cos(phi) / StrictMath.sqrt(1.0 - this._e2 * sinPhi * sinPhi);
    }

    private double getM(double phi) {
        return this._a * (this._subM[0] * phi + this._subM[1] * StrictMath.sin(2.0 * phi) + this._subM[2] * StrictMath.sin(4.0 * phi) + this._subM[3] * StrictMath.sin(6.0 * phi));
    }

    @Override
    protected Coordinate forwardPointRaw(double lambda, double phi, Coordinate storage) {
        double M = this.getM(phi);
        double rho = this._aG - M;
        double theta = this._n * GeometryUtils.wrap_longitude(lambda - this._lambda0);
        storage.x = rho * StrictMath.sin(theta);
        storage.y = this._rho0 - rho * StrictMath.cos(theta);
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double rho0minusY = this._rho0 - y;
        double rho = StrictMath.sqrt(x * x + rho0minusY * rho0minusY) * (double)GeometryUtils.sign(this._n);
        double M = this._aG - rho;
        double mu = M / (this._a * this._subM[0]);
        double theta = this._n < 0.0 ? StrictMath.atan2(-x, -rho0minusY) : StrictMath.atan2(x, rho0minusY);
        storage.y = mu + this._subPhi[0] * StrictMath.sin(2.0 * mu) + this._subPhi[1] * StrictMath.sin(4.0 * mu) + this._subPhi[2] * StrictMath.sin(6.0 * mu) + this._subPhi[3] * StrictMath.sin(8.0 * mu);
        double thetaOverN = theta / this._n;
        storage.x = StrictMath.abs(thetaOverN) > Math.PI ? Double.NaN : GeometryUtils.wrap_longitude(this._lambda0 + thetaOverN);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._subM[0] = 1.0 - this._e2 / 4.0 - 3.0 * this._e2 * this._e2 / 64.0 - 5.0 * this._e2 * this._e2 * this._e2 / 256.0;
        this._subM[1] = 3.0 * this._e2 / 8.0 + 3.0 * this._e2 * this._e2 / 32.0 + 45.0 * this._e2 * this._e2 * this._e2 / 1024.0;
        this._subM[2] = 15.0 * this._e2 * this._e2 / 256.0 + 45.0 * this._e2 * this._e2 * this._e2 / 1024.0;
        this._subM[3] = 35.0 * this._e2 * this._e2 * this._e2 / 3072.0;
        double M0 = this.getM(this._phi0);
        double m1 = this.getm(this._phi1);
        double M1 = this.getM(this._phi1);
        double m2 = this.getm(this._phi2);
        double M2 = this.getM(this._phi2);
        this._n = this._a * ((m1 - m2) / (M2 - M1));
        this._aG = this._a * (m1 / this._n + M1 / this._a);
        this._rho0 = this._aG - M0;
        double e1 = (1.0 - StrictMath.sqrt(1.0 - this._e2)) / (1.0 + StrictMath.sqrt(1.0 - this._e2));
        this._subPhi[0] = 3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0;
        this._subPhi[1] = 21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0;
        this._subPhi[2] = 151.0 * e1 * e1 * e1 / 96.0;
        this._subPhi[3] = 1097.0 * e1 * e1 * e1 * e1 / 512.0;
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        EquidistantConic clone = (EquidistantConic)super.clone();
        clone._subM = (double[])this._subM.clone();
        clone._subPhi = (double[])this._subPhi.clone();
        return clone;
    }
}

