/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;

public final class JTSUtils {
    private static final Comparator<Polygon> POLYGON_AREA_COMPARATOR = new Comparator<Polygon>(){

        @Override
        public int compare(Polygon p1, Polygon p2) {
            double a2;
            double a1 = p1.getArea();
            if (a1 < (a2 = p2.getArea())) {
                return 1;
            }
            if (a1 > a2) {
                return -1;
            }
            return 0;
        }
    };
    private static final Comparator<Polygon> POLYGON_CONTAINMENT_COMPARATOR = new Comparator<Polygon>(){

        @Override
        public int compare(Polygon p1, Polygon p2) {
            if (p1.contains((Geometry)p2)) {
                return 1;
            }
            if (p2.contains((Geometry)p1)) {
                return -1;
            }
            return 0;
        }
    };

    public static MultiPolygon buildPolygonGeometry(LinearRing[] rings, GeometryFactory factory, boolean repair) {
        MultiPolygon result = null;
        if (rings.length == 0) {
            result = factory.createMultiPolygon(null);
        } else if (rings.length == 1) {
            result = factory.createMultiPolygon(new Polygon[]{factory.createPolygon(rings[0], null)});
        } else {
            ArrayList<LinearRing> shellRingList = new ArrayList<LinearRing>(rings.length);
            ArrayList<LinearRing> holeRingList = new ArrayList<LinearRing>(rings.length - 1);
            for (int i = 0; i < rings.length; ++i) {
                LinearRing ring = rings[i];
                if (ring.getNumPoints() <= 0) continue;
                if (Orientation.isCCW((Coordinate[])ring.getCoordinates())) {
                    holeRingList.add(ring);
                    continue;
                }
                shellRingList.add(ring);
            }
            if (shellRingList.size() == 1) {
                Polygon poly = factory.createPolygon((LinearRing)shellRingList.get(0), GeometryFactory.toLinearRingArray(holeRingList));
                result = factory.createMultiPolygon(new Polygon[]{poly});
            } else if (holeRingList.size() == 0) {
                Polygon[] polygons = new Polygon[shellRingList.size()];
                for (int i = 0; i < shellRingList.size(); ++i) {
                    polygons[i] = factory.createPolygon((LinearRing)shellRingList.get(i), null);
                }
                result = factory.createMultiPolygon(polygons);
            } else {
                Polygon[] polygons = new Polygon[shellRingList.size()];
                for (int i = 0; i < shellRingList.size(); ++i) {
                    polygons[i] = factory.createPolygon((LinearRing)shellRingList.get(i), null);
                }
                ArrayList<Polygon> holeContainers = new ArrayList<Polygon>(4);
                block3: for (int i = 0; i < holeRingList.size(); ++i) {
                    int j;
                    LinearRing hole = (LinearRing)holeRingList.get(i);
                    holeContainers.clear();
                    for (int j2 = 0; j2 < polygons.length; ++j2) {
                        if (!polygons[j2].contains((Geometry)hole)) continue;
                        holeContainers.add(polygons[j2]);
                    }
                    if (holeContainers.size() <= 0) continue;
                    Collections.sort(holeContainers, POLYGON_CONTAINMENT_COMPARATOR);
                    Polygon container = (Polygon)holeContainers.get(0);
                    LinearRing[] newHoles = new LinearRing[container.getNumInteriorRing() + 1];
                    for (j = 0; j < container.getNumInteriorRing(); ++j) {
                        newHoles[j] = container.getInteriorRingN(j);
                    }
                    newHoles[newHoles.length - 1] = hole;
                    for (j = 0; j < polygons.length; ++j) {
                        if (container != polygons[j]) continue;
                        polygons[j] = factory.createPolygon(container.getExteriorRing(), newHoles);
                        continue block3;
                    }
                }
                result = factory.createMultiPolygon(polygons);
            }
        }
        if (result == null) {
            return factory.createMultiPolygon(null);
        }
        if (repair) {
            result = (MultiPolygon)JTSUtils.repair((Geometry)result);
        }
        return result;
    }

    public static Geometry repair(Geometry geom) {
        GeometryFactory factory = geom.getFactory();
        if (geom instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)geom;
            Polygon[] polys = new Polygon[mp.getNumGeometries()];
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                polys[i] = JTSUtils.repair((Polygon)mp.getGeometryN(i));
            }
            return factory.createMultiPolygon(polys);
        }
        if (geom instanceof Polygon) {
            return JTSUtils.repair((Polygon)geom);
        }
        if (geom.getGeometryType().equals("GeometryCollection")) {
            GeometryCollection gc = (GeometryCollection)geom;
            Geometry[] geoms = new Geometry[gc.getNumGeometries()];
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                geoms[i] = JTSUtils.repair(gc.getGeometryN(i));
            }
            Thread.dumpStack();
            return factory.createGeometryCollection(geoms);
        }
        return geom;
    }

    public static Polygon repair(Polygon p) {
        GeometryFactory factory = p.getFactory();
        IsValidOp isValidOp = new IsValidOp((Geometry)p);
        TopologyValidationError err = isValidOp.getValidationError();
        while (err != null) {
            if (err.getErrorType() == 5 || err.getErrorType() == 6 || err.getErrorType() == 4) {
                Geometry boundary = p.getBoundary();
                boundary = boundary.union(boundary);
                Polygonizer polygonizer = new Polygonizer();
                polygonizer.add(boundary);
                Collection c = polygonizer.getPolygons();
                if (c.size() > 0) {
                    Polygon[] polys = c.toArray(new Polygon[c.size()]);
                    Arrays.sort(polys, POLYGON_AREA_COMPARATOR);
                    p = polys[0];
                } else {
                    System.err.println("unable to fix polygon: " + err);
                    p = factory.createPolygon(null, null);
                }
            } else if (err.getErrorType() == 9) {
                LinearRing exterior = p.getExteriorRing();
                Coordinate[] coords = CoordinateArrays.removeRepeatedPoints((Coordinate[])exterior.getCoordinates());
                if (coords.length < 4) {
                    p = factory.createPolygon(null, null);
                } else {
                    exterior = factory.createLinearRing(coords);
                    ArrayList<LinearRing> validInteriorRings = new ArrayList<LinearRing>(p.getNumInteriorRing());
                    for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                        LinearRing s = p.getInteriorRingN(i);
                        coords = CoordinateArrays.removeRepeatedPoints((Coordinate[])s.getCoordinates());
                        if (coords.length < 4) continue;
                        validInteriorRings.add(factory.createLinearRing(coords));
                    }
                    p = factory.createPolygon(exterior, GeometryFactory.toLinearRingArray(validInteriorRings));
                }
            } else {
                System.err.println(err);
                p = factory.createPolygon(null, null);
            }
            isValidOp = new IsValidOp((Geometry)p);
            err = isValidOp.getValidationError();
        }
        return p;
    }

    public static GeometryCollection explodeMultiPolygon(MultiPolygon mp) {
        ArrayList<LinearRing> result = new ArrayList<LinearRing>(mp.getNumGeometries() * 2);
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Polygon p = (Polygon)mp.getGeometryN(i);
            result.add(p.getExteriorRing());
            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                result.add(p.getInteriorRingN(j));
            }
        }
        return mp.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(result));
    }

    public static Geometry flatten(GeometryCollection gc) {
        final LinkedList points = new LinkedList();
        final LinkedList lines = new LinkedList();
        final LinkedList polygons = new LinkedList();
        gc.apply(new GeometryFilter(){

            public void filter(Geometry geom) {
                if (geom instanceof Point) {
                    points.add((Point)geom);
                } else if (geom instanceof LineString) {
                    lines.add((LineString)geom);
                } else if (geom instanceof Polygon) {
                    polygons.add((Polygon)geom);
                }
            }
        });
        if (!polygons.isEmpty()) {
            return gc.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
        }
        if (!lines.isEmpty()) {
            return gc.getFactory().createMultiLineString(GeometryFactory.toLineStringArray(lines));
        }
        return gc.getFactory().createMultiPoint(GeometryFactory.toPointArray(points));
    }

    public static double getSharedAreaRatio(Geometry geom1, Geometry geom2) {
        try {
            return geom1.intersection(geom2).getArea() / geom1.getArea();
        }
        catch (TopologyException e) {
            double result = 0.0;
            if (geom2 instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)geom2;
                for (int j = 0; j < gc.getNumGeometries(); ++j) {
                    result += geom1.intersection(gc.getGeometryN(j)).getArea();
                }
                return result / geom1.getArea();
            }
            throw e;
        }
    }

    public static double fastGetSharedAreaRatio(Geometry geom1, Geometry geom2) {
        Envelope env1 = geom1.getEnvelopeInternal();
        if (SimplePointInAreaLocator.locate((Coordinate)new Coordinate(env1.getMinX(), env1.getMinY()), (Geometry)geom2) == 0 && SimplePointInAreaLocator.locate((Coordinate)new Coordinate(env1.getMaxX(), env1.getMaxY()), (Geometry)geom2) == 0 && SimplePointInAreaLocator.locate((Coordinate)new Coordinate(env1.getMaxX(), env1.getMinY()), (Geometry)geom2) == 0 && SimplePointInAreaLocator.locate((Coordinate)new Coordinate(env1.getMinX(), env1.getMaxY()), (Geometry)geom2) == 0) {
            return 1.0;
        }
        double xInc = env1.getWidth() / 9.0;
        double yInc = env1.getHeight() / 9.0;
        double x = env1.getMinX();
        double y = env1.getMinY();
        double ct = 0.0;
        for (int i = 0; i < 10; ++i) {
            y = env1.getMinY();
            for (int j = 0; j < 10; ++j) {
                if (SimplePointInAreaLocator.locate((Coordinate)new Coordinate(x, y), (Geometry)geom2) == 0) {
                    ct += 1.0;
                }
                y += yInc;
            }
            x += xInc;
        }
        return ct / 100.0;
    }
}

