/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw.algorithms;

import java.io.Serializable;
import org.nlogo.extensions.nw.Graph;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class ClusteringMetrics$
implements Serializable {
    public static final ClusteringMetrics$ MODULE$ = new ClusteringMetrics$();

    private ClusteringMetrics$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClusteringMetrics$.class);
    }

    public <V, E> double clusteringCoefficient(Graph<V, E> graph, V node) {
        Seq<V> neighbors = graph.outNeighbors(node);
        Set neighborSet = neighbors.toSet();
        if (neighbors.size() < 2) {
            return 0.0;
        }
        Seq neighborLinkCounts = (Seq)neighbors.map((Function1 & Serializable)t -> graph.outNeighbors(t).count((Function1 & Serializable)elem -> neighborSet.contains(elem)));
        return (double)BoxesRunTime.unboxToInt((Object)neighborLinkCounts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)(neighbors.size() * (neighbors.size() - 1));
    }

    public <V, E> double modularity(Graph<V, E> graph, Iterable<Set<V>> communities) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)communities.map((Function1 & Serializable)c -> MODULE$.communityModularity(graph, (Set)c))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public <V, E> double communityModularity(Graph<V, E> graph, Set<V> community) {
        DoubleRef totalIn = DoubleRef.create((double)0.0);
        DoubleRef totalOut = DoubleRef.create((double)0.0);
        DoubleRef internal = DoubleRef.create((double)0.0);
        community.foreach((Function1)(JProcedure1 & Serializable)node -> {
            graph.outEdges(node).foreach((Function1)(JProcedure1 & Serializable)edge -> {
                double weight = graph.weight(edge);
                if (community.contains(graph.otherEnd(node, edge))) {
                    internal$2.elem += weight;
                }
                totalOut$2.elem += weight;
            });
            graph.inEdges(node).foreach((Function1)(JProcedure1 & Serializable)edge -> totalIn$2.elem += graph.weight(edge));
        });
        return (internal.elem - totalIn.elem * totalOut.elem / graph.totalArcWeight()) / graph.totalArcWeight();
    }
}

