/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw.gephi;

import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.ImportController;
import org.gephi.io.importer.plugin.file.ImporterGDF;
import org.gephi.io.importer.plugin.file.ImporterGraphML;
import org.gephi.io.importer.plugin.file.spreadsheet.ImporterSpreadsheetCSV;
import org.gephi.io.importer.spi.FileImporter;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.extensions.nw.NetworkExtensionUtil$;
import org.nlogo.extensions.nw.gephi.GephiUtils$;
import org.openide.util.Lookup;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.control.Exception$;

public final class GephiImport$
implements Serializable {
    private static final ImportController importController;
    private static final Set<String> doubleBuiltins;
    private static final Set<String> booleanBuiltins;
    private static final Set<String> colorBuiltins;
    public static final GephiImport$ MODULE$;

    private GephiImport$() {
    }

    static {
        MODULE$ = new GephiImport$();
        importController = (ImportController)GephiUtils$.MODULE$.withNWLoaderContext().apply(MODULE$::$init$$$anonfun$1);
        doubleBuiltins = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"XCOR", "YCOR", "HEADING", "PEN-SIZE", "THICKNESS", "SIZE"}));
        booleanBuiltins = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"HIDDEN"}));
        colorBuiltins = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COLOR", "LABEL-COLOR"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GephiImport$.class);
    }

    public ImportController importController() {
        return importController;
    }

    public void load(File file, World world, AgentSet defaultTurtleBreed, AgentSet defaultLinkBreed, Function1<IterableOnce<Turtle>, BoxedUnit> initTurtles) {
        GephiUtils$.MODULE$.withNWLoaderContext().apply((Function0 & Serializable)() -> {
            GephiImport$.load$$anonfun$1(file, world, defaultTurtleBreed, defaultLinkBreed, initTurtles);
            return BoxedUnit.UNIT;
        });
    }

    public void load(File file, World world, AgentSet defaultTurtleBreed, AgentSet defaultLinkBreed, Function1<IterableOnce<Turtle>, BoxedUnit> initTurtles, String extension) {
        GephiUtils$.MODULE$.withNWLoaderContext().apply((Function0 & Serializable)() -> {
            GephiImport$.load$$anonfun$2(file, world, defaultTurtleBreed, defaultLinkBreed, initTurtles, extension);
            return BoxedUnit.UNIT;
        });
    }

    public void load(File file, World world, AgentSet defaultTurtleBreed, AgentSet defaultLinkBreed, Function1<IterableOnce<Turtle>, BoxedUnit> initTurtles, FileImporter importer) {
        GephiUtils$.MODULE$.withNWLoaderContext().apply((Function0 & Serializable)() -> {
            this.load$$anonfun$3(file, importer, world, defaultTurtleBreed, defaultLinkBreed, initTurtles);
            return BoxedUnit.UNIT;
        });
    }

    private LogoList convertColor(Color c) {
        LogoList l = LogoList$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Predef$.MODULE$.double2Double((double)c.getRed()), Predef$.MODULE$.double2Double((double)c.getGreen()), Predef$.MODULE$.double2Double((double)c.getBlue())}));
        if (c.getAlpha() != 255) {
            l.lput((Object)Predef$.MODULE$.double2Double((double)c.getAlpha()));
        }
        return l;
    }

    private Option<Tuple2<String, Object>> pair(String key, Object value) {
        return Option$.MODULE$.apply(value).map((Function1 & Serializable)v -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, MODULE$.convertAttribute(key, v));
        });
    }

    private scala.collection.immutable.Map<String, Object> getAttributes(ElementDraft el) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(el.getColumns()).asScala().map((Function1 & Serializable)c -> {
            String name = c.getId().toUpperCase();
            Object rawValue = el.getValue(c.getId());
            Object value = MODULE$.convertAttribute(name, rawValue);
            return Tuple2$.MODULE$.apply((Object)name, value);
        })).filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object v = tuple2._2();
                return v != null;
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<AgentSet> getBreed(Map<String, Object> attributes, Map<String, AgentSet> breeds) {
        return attributes.get((Object)"BREED").collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof String) {
                    String s = (String)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof String) {
                    String s = (String)object;
                    return s.toUpperCase();
                }
                return function1.apply(x);
            }
        }).flatMap((Function1 & Serializable)s -> breeds.get(s));
    }

    private Object convertAttribute(String name, Object o2) {
        if (doubleBuiltins.contains((Object)name)) {
            Object object = o2;
            if (object instanceof Number) {
                Number x = (Number)object;
                return Predef$.MODULE$.double2Double(x.doubleValue());
            }
            if (object instanceof String) {
                String s = (String)object;
                return (Comparable)Exception$.MODULE$.allCatch().opt(() -> GephiImport$.convertAttribute$$anonfun$1(s)).getOrElse(GephiImport$::convertAttribute$$anonfun$2);
            }
            return "";
        }
        if (booleanBuiltins.contains((Object)name)) {
            Object object = o2;
            if (object instanceof Number) {
                Number x = (Number)object;
                return Predef$.MODULE$.boolean2Boolean(x.doubleValue() != 0.0);
            }
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                return b;
            }
            if (object instanceof String) {
                String s = (String)object;
                return (Comparable)Exception$.MODULE$.allCatch().opt(() -> GephiImport$.convertAttribute$$anonfun$3(s)).getOrElse(GephiImport$::convertAttribute$$anonfun$4);
            }
            return "";
        }
        if (colorBuiltins.contains((Object)name)) {
            Object object = o2;
            if (object instanceof Color) {
                Color c = (Color)object;
                return this.convertColor(c);
            }
            if (object instanceof Number) {
                Number x = (Number)object;
                return Predef$.MODULE$.double2Double(x.doubleValue());
            }
            if (object instanceof Collection) {
                Collection c = (Collection)object;
                return LogoList$.MODULE$.fromIterator(((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(c).asScala().map((Function1 & Serializable)o -> MODULE$.convertAttribute(o))).iterator());
            }
            if (object instanceof String) {
                String s = (String)object;
                return (Serializable)Exception$.MODULE$.allCatch().opt(() -> GephiImport$.convertAttribute$$anonfun$6(s)).getOrElse(GephiImport$::convertAttribute$$anonfun$7);
            }
            return "";
        }
        return this.convertAttribute(o2);
    }

    private Object convertAttribute(Object o2) {
        Object object = o2;
        if (object instanceof Color) {
            Color c = (Color)object;
            return this.convertColor(c);
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return Predef$.MODULE$.double2Double(n.doubleValue());
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        if (object instanceof LogoList) {
            LogoList ll = (LogoList)object;
            return ll;
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            return LogoList$.MODULE$.fromIterator(((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(c).asScala().map((Function1 & Serializable)x -> MODULE$.convertAttribute(x))).iterator());
        }
        if (object instanceof TimeMap) {
            TimeMap d = (TimeMap)object;
            Object object2 = Predef$.MODULE$.refArrayOps(d.toValuesArray());
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x -> MODULE$.convertAttribute(x), ClassTag$.MODULE$.apply(Object.class)));
            return LogoList$.MODULE$.fromIterator(ArrayOps$.MODULE$.iterator$extension(object3));
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a = object;
            Object object4 = Predef$.MODULE$.genericArrayOps(a);
            Object object5 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)o -> MODULE$.convertAttribute(o), ClassTag$.MODULE$.apply(Object.class)));
            return LogoList$.MODULE$.fromIterator(ArrayOps$.MODULE$.iterator$extension(object5));
        }
        if (object == null) {
            return "";
        }
        Object x2 = object;
        return x2.toString();
    }

    private void setAttribute(World world, Agent agent, String name, Object value) {
        int i = world.indexOfVariable(agent, name);
        if (i != -1) {
            try {
                agent.setVariable(i, value);
            }
            catch (AgentException e) {
                // empty catch block
            }
            return;
        }
    }

    private final ImportController $init$$$anonfun$1() {
        return (ImportController)Lookup.getDefault().lookup(ImportController.class);
    }

    private static final void load$$anonfun$1(File file$1, World world$1, AgentSet defaultTurtleBreed$1, AgentSet defaultLinkBreed$1, Function1 initTurtles$1) {
        MODULE$.load(file$1, world$1, defaultTurtleBreed$1, defaultLinkBreed$1, (Function1<IterableOnce<Turtle>, BoxedUnit>)initTurtles$1, MODULE$.importController().getFileImporter(file$1));
    }

    private static final void load$$anonfun$2(File file$2, World world$2, AgentSet defaultTurtleBreed$2, AgentSet defaultLinkBreed$2, Function1 initTurtles$2, String extension$1) {
        MODULE$.load(file$2, world$2, defaultTurtleBreed$2, defaultLinkBreed$2, (Function1<IterableOnce<Turtle>, BoxedUnit>)initTurtles$2, MODULE$.importController().getFileImporter(extension$1));
    }

    private static final AgentSet $anonfun$3(AgentSet defaultTurtleBreed$5) {
        return defaultTurtleBreed$5;
    }

    private static final AgentSet $anonfun$5(AgentSet defaultLinkBreed$5) {
        return defaultLinkBreed$5;
    }

    private static final /* synthetic */ Option $anonfun$4(Map nodeToTurtle$1, scala.collection.mutable.Map linkBreeds$1, AgentSet defaultLinkBreed$4, boolean defaultDirected$1, boolean isGdfImport$1, World world$6, EdgeDraft edge) {
        boolean bl;
        boolean gephiUnset;
        Turtle source = (Turtle)nodeToTurtle$1.apply((Object)edge.getSource());
        Turtle target = (Turtle)nodeToTurtle$1.apply((Object)edge.getTarget());
        scala.collection.immutable.Map attrs = (scala.collection.immutable.Map)((MapOps)((MapOps)((MapOps)MODULE$.getAttributes((ElementDraft)edge).$plus$plus(MODULE$.pair("LABEL", edge.getLabel()))).$plus$plus(MODULE$.pair("LABEL-COLOR", edge.getLabelColor()))).$plus$plus(MODULE$.pair("COLOR", edge.getColor()))).$plus$plus(MODULE$.pair("WEIGHT", Predef$.MODULE$.double2Double(edge.getWeight())));
        AgentSet breed = (AgentSet)MODULE$.getBreed((Map<String, Object>)attrs, (Map<String, AgentSet>)linkBreeds$1).getOrElse(() -> GephiImport$.$anonfun$5(defaultLinkBreed$4));
        EdgeDirection edgeDirection = edge.getDirection();
        EdgeDirection edgeDirection2 = EdgeDirection.DIRECTED;
        boolean gephiDirected = !(edgeDirection != null ? !edgeDirection.equals(edgeDirection2) : edgeDirection2 != null);
        EdgeDirection edgeDirection3 = edge.getDirection();
        EdgeDirection edgeDirection4 = EdgeDirection.UNDIRECTED;
        boolean gephiUndirected = !(edgeDirection3 != null ? !edgeDirection3.equals(edgeDirection4) : edgeDirection4 != null);
        boolean bl2 = gephiUnset = edge.getDirection() == null;
        if (breed.isDirected() == breed.isUndirected()) {
            if (gephiUnset) {
                breed.setDirected(defaultDirected$1);
            } else {
                breed.setDirected(gephiDirected);
            }
            bl = false;
        } else {
            bl = breed.isDirected() && gephiUndirected && !isGdfImport$1 || breed.isUndirected() && gephiDirected;
        }
        boolean bad = bl;
        List links = (List)((IterableOps)new .colon.colon((Object)world$6.linkManager().createLink(source, target, breed), (List)Nil$.MODULE$)).$plus$plus((IterableOnce)(breed.isDirected() && gephiUnset ? Some$.MODULE$.apply((Object)world$6.linkManager().createLink(target, source, breed)) : None$.MODULE$));
        links.foreach((Function1)(JProcedure1 & Serializable)l -> attrs.$minus((Object)"BREED").foreach(((JProcedure2 & Serializable)(JProcedure2 & Serializable)(name, value) -> MODULE$.setAttribute(world$6, (Agent)l, (String)name, value)).tupled()));
        if (bad) {
            return Some$.MODULE$.apply((Object)edge);
        }
        return None$.MODULE$;
    }

    private final void load$$anonfun$3(File file$3, FileImporter importer$1, World world$3, AgentSet defaultTurtleBreed$3, AgentSet defaultLinkBreed$3, Function1 initTurtles$3) {
        Container container;
        if (!file$3.exists()) {
            throw new ExtensionException("The file " + file$3 + " cannot be found.");
        }
        FileImporter fileImporter = importer$1;
        if (fileImporter == null) {
            throw new ExtensionException("Unable to find importer for " + file$3);
        }
        if (fileImporter instanceof ImporterSpreadsheetCSV) {
            throw new ExtensionException("Importing CSV files is not supported.");
        }
        if (fileImporter instanceof ImporterGraphML) {
            throw new ExtensionException("You must use nw:load-graphml to load graphml files.");
        }
        boolean isGdfImport = fileImporter instanceof ImporterGDF;
        scala.collection.mutable.Map turtleBreeds = CollectionConverters$.MODULE$.MapHasAsScala(world$3.breeds()).asScala();
        scala.collection.mutable.Map linkBreeds = CollectionConverters$.MODULE$.MapHasAsScala(world$3.linkBreeds()).asScala();
        try {
            container = (Container)NetworkExtensionUtil$.MODULE$.using(new FileReader(file$3), (Function1 & Serializable)r -> MODULE$.importController().importFile((Reader)r, importer$1));
        }
        catch (IOException e2) {
            throw new ExtensionException((Exception)e2);
        }
        Container container2 = container;
        ContainerUnloader unloader = container2.getUnloader();
        EdgeDirectionDefault edgeDirectionDefault = unloader.getEdgeDefault();
        EdgeDirectionDefault edgeDirectionDefault2 = EdgeDirectionDefault.DIRECTED;
        boolean defaultDirected = !(edgeDirectionDefault != null ? !edgeDirectionDefault.equals(edgeDirectionDefault2) : edgeDirectionDefault2 != null);
        Iterable nodes = CollectionConverters$.MODULE$.IterableHasAsScala(unloader.getNodes()).asScala();
        Iterable edges = CollectionConverters$.MODULE$.IterableHasAsScala(unloader.getEdges()).asScala();
        scala.collection.immutable.Map nodeToTurtle = ((IterableOnceOps)nodes.zip((IterableOnce)nodes.map((Function1 & Serializable)node -> {
            scala.collection.immutable.Map attrs = (scala.collection.immutable.Map)((MapOps)((MapOps)MODULE$.getAttributes((ElementDraft)node).$plus$plus(MODULE$.pair("LABEL", node.getLabel()))).$plus$plus(MODULE$.pair("LABEL-COLOR", node.getLabelColor()))).$plus$plus(MODULE$.pair("COLOR", node.getColor()));
            AgentSet breed = (AgentSet)MODULE$.getBreed((Map<String, Object>)attrs, (Map<String, AgentSet>)turtleBreeds).getOrElse(() -> GephiImport$.$anonfun$3(defaultTurtleBreed$3));
            Turtle turtle = NetworkExtensionUtil$.MODULE$.createTurtle(world$3, breed, world$3.mainRNG());
            attrs.$minus((Object)"BREED").foreach(((JProcedure2 & Serializable)(JProcedure2 & Serializable)(name, value) -> MODULE$.setAttribute(world$3, (Agent)turtle, (String)name, value)).tupled());
            return turtle;
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Iterable badEdges = (Iterable)((IterableOps)edges.map(arg_0 -> GephiImport$.$anonfun$4((Map)nodeToTurtle, linkBreeds, defaultLinkBreed$3, defaultDirected, isGdfImport, world$3, arg_0))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                EdgeDraft edgeDraft;
                Option option = x;
                if (option instanceof Some && (edgeDraft = (EdgeDraft)((Some)option).value()) != null) {
                    EdgeDraft e = edgeDraft;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                EdgeDraft edgeDraft;
                Option option = x;
                if (option instanceof Some && (edgeDraft = (EdgeDraft)((Some)option).value()) != null) {
                    EdgeDraft e = edgeDraft;
                    return e;
                }
                return function1.apply((Object)x);
            }
        });
        initTurtles$3.apply((Object)nodeToTurtle.values());
        if (badEdges.nonEmpty()) {
            String edgesList = ((IterableOnceOps)badEdges.map((Function1 & Serializable)e -> e.getSource().getId() + "->" + e.getTarget().getId())).mkString(", ");
            String errorMsg = "The following edges had a directedness different than their assigned breed. They have been given the directedness of their breed. If you wish to ignore this error, wrap this command in a CAREFULLY:";
            throw new ExtensionException(errorMsg + " " + edgesList);
        }
    }

    private static final Double convertAttribute$$anonfun$1(String s$1) {
        return Predef$.MODULE$.double2Double(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s$1)));
    }

    private static final Double convertAttribute$$anonfun$2() {
        return Predef$.MODULE$.double2Double(0.0);
    }

    private static final Boolean convertAttribute$$anonfun$3(String s$2) {
        return Predef$.MODULE$.boolean2Boolean(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s$2)));
    }

    private static final Boolean convertAttribute$$anonfun$4() {
        return Predef$.MODULE$.boolean2Boolean(false);
    }

    private static final Double convertAttribute$$anonfun$6(String s$3) {
        return Predef$.MODULE$.double2Double(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s$3)));
    }

    private static final Comparable convertAttribute$$anonfun$7() {
        return "";
    }
}

