/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.vid;

import java.io.Serializable;
import org.nlogo.swing.MessageDialog;
import org.nlogo.util.Utils$;
import scala.runtime.ModuleSerializationProxy;

public final class PlatformErrors$
implements Serializable {
    public static final PlatformErrors$ MODULE$ = new PlatformErrors$();

    private PlatformErrors$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlatformErrors$.class);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public void showDialog(String title, String message, Throwable ex) {
        String stackTrace = Utils$.MODULE$.getStackTrace(ex);
        MessageDialog dialog = new MessageDialog(title, message, stackTrace){
            {
                this.doShow(title$1, message$1 + "\n\nIf it still does not work, please report the below error message to bugs@ccl.northwestern.edu or at https://github.com/NetLogo/Vid-Extension/issues\n\n" + stackTrace$1, 15, 60);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPossibleMacOSSecurityError(Exception ex) {
        if (!this.isMacOS()) return false;
        String string = ex.getMessage();
        String string2 = "read() Error: Could not read frame in start().";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public void showMacOSSecurityMessage(Exception ex) {
        String message = "It appears that NetLogo does not have permission to use the cameras on this system.  Please open System Preferences, Security & Privacy, then the Privacy Tab, select Camera in the list, and allow NetLogo to use the camera.  You will need to quit and re-open NetLogo for the change to take effect.  See this link for more details:  https://support.apple.com/en-euro/guide/mac-help/mchlf6d108da/mac";
        this.showDialog("macOS Camera Permission Needed", message, ex);
    }

    public boolean isPossibleWinMissingVcppRuntimeError() {
        return this.isWindows();
    }

    public void showMissingVcppRuntimeMessage(ExceptionInInitializerError ex) {
        boolean is64 = System.getProperty("os.arch").contains("64");
        String url = is64 ? "https://download.microsoft.com/download/1/6/5/165255E7-1014-4D0A-B094-B6A430A6BFFC/vcredist_x64.exe" : "https://download.microsoft.com/download/1/6/5/165255E7-1014-4D0A-B094-B6A430A6BFFC/vcredist_x86.exe";
        String message = "It appears that a Windows library needed by the Vid extension is not installed.  Please visit this link to download the Microsoft Visual C++ 10 runtime library installer: " + url + "\n\nAfter installing it try running the Vid extension one more time.";
        this.showDialog("Missing Windows Library", message, ex);
    }
}

