/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.vid;

import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.extensions.vid.Recorder;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public class RecordInterface
implements Command {
    private final Recorder recorder;

    public RecordInterface(Recorder recorder) {
        this.recorder = recorder;
    }

    public Syntax getSyntax() {
        return Syntax$.MODULE$.commandSyntax((List)Nil$.MODULE$, Syntax$.MODULE$.commandSyntax$default$2(), Syntax$.MODULE$.commandSyntax$default$3(), Syntax$.MODULE$.commandSyntax$default$4(), Syntax$.MODULE$.commandSyntax$default$5(), Syntax$.MODULE$.commandSyntax$default$6(), Syntax$.MODULE$.commandSyntax$default$7());
    }

    public void perform(Argument[] args, Context context) {
        if (!this.recorder.isRecording()) {
            throw new ExtensionException("vid: recorder not started");
        }
        try {
            Path tmpFile = Files.createTempFile("interfaceexport", "png", new FileAttribute[0]);
            context.workspace().exportInterface(tmpFile.toString());
            BufferedImage exportedImage = ImageIO.read(tmpFile.toFile());
            this.recorder.recordFrame(exportedImage);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ExtensionException("vid: export interface not supported");
        }
    }
}

