/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.vid;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.extensions.vid.Recorder;
import org.nlogo.extensions.vid.Recorder$NoFrames$;
import org.nlogo.extensions.vid.Recorder$NotRecording$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public class SaveRecording
implements Command {
    private final Recorder recorder;

    public SaveRecording(Recorder recorder) {
        this.recorder = recorder;
    }

    public Syntax getSyntax() {
        return Syntax$.MODULE$.commandSyntax((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)Nil$.MODULE$), Syntax$.MODULE$.commandSyntax$default$2(), Syntax$.MODULE$.commandSyntax$default$3(), Syntax$.MODULE$.commandSyntax$default$4(), Syntax$.MODULE$.commandSyntax$default$5(), Syntax$.MODULE$.commandSyntax$default$6(), Syntax$.MODULE$.commandSyntax$default$7());
    }

    public void perform(Argument[] args, Context context) {
        try {
            String pathString = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(args[0].getString()), ".mp4") + ".mp4";
            Path path = Paths.get(pathString, new String[0]);
            Path savePath = path.isAbsolute() ? path : Paths.get(context.attachCurrentDirectory(pathString), new String[0]);
            this.recorder.save(savePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ExtensionException("vid: no such directory");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (Recorder$NotRecording$.MODULE$.equals(throwable2)) {
                throw new ExtensionException("vid: recorder not started");
            }
            if (Recorder$NoFrames$.MODULE$.equals(throwable2)) {
                throw new ExtensionException("vid: no frames recorded");
            }
            throw throwable;
        }
    }
}

