/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.nlogo.agent.Patch;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.core.File;
import org.nlogo.core.I18N;

public class ImportPatchColors {
    public static void importPatchColors(File imageFile, World world, boolean asNetLogoColors) throws IOException {
        String filename = imageFile.getAbsolutePath();
        InputStream stream = imageFile.getInputStream();
        BufferedImage image = ImageIO.read(stream);
        stream.close();
        if (image == null) {
            throw new IOException(I18N.errorsJ().getN("org.nlogo.agent.ImportPatchColors.unsupportedImageFormat", filename));
        }
        ImportPatchColors.doImport(image, world, asNetLogoColors);
    }

    public static void doImport(BufferedImage image, World world, boolean asNetLogoColors) {
        float scaley;
        float scalex = (float)world.worldWidth() / (float)image.getWidth();
        float scale = scalex < (scaley = (float)world.worldHeight() / (float)image.getHeight()) ? scalex : scaley;
        BufferedImage scaledImage = null;
        if (scale != 1.0f) {
            AffineTransformOp trans = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), 2);
            if (image.getColorModel().getColorSpace().getType() == 6 && !image.getColorModel().hasAlpha()) {
                scaledImage = trans.createCompatibleDestImage(image, image.getColorModel());
                trans.filter(image, scaledImage);
            } else {
                scaledImage = trans.filter(image, null);
            }
        } else {
            scaledImage = image;
        }
        SampleModel sm = scaledImage.getSampleModel();
        int maxwidth = StrictMath.min(scaledImage.getWidth(), world.worldWidth());
        int maxheight = StrictMath.min(scaledImage.getHeight(), world.worldHeight());
        DataBuffer db = scaledImage.getData().getDataBuffer();
        ColorModel cm = scaledImage.getColorModel();
        CachedColorLookup lookup = new CachedColorLookup();
        int woff = (int)StrictMath.floor((world.worldWidth() - scaledImage.getWidth()) / 2);
        int hoff = (int)StrictMath.floor((world.worldHeight() - scaledImage.getHeight()) / 2);
        int currentPxcor = world.minPxcor() + woff;
        for (int i = 0; i < maxwidth; ++i) {
            int currentPycor = world.maxPycor() - hoff;
            for (int j = 0; j < maxheight; ++j) {
                Object transferType = sm.getDataElements(i, j, null, db);
                if (cm.getAlpha(transferType) != 0) {
                    int argb = cm.getRGB(transferType);
                    if (asNetLogoColors) {
                        ((Patch)world.fastGetPatchAt(currentPxcor, currentPycor)).pcolor(lookup.lookupColor(argb));
                    } else {
                        try {
                            ((Patch)world.fastGetPatchAt(currentPxcor, currentPycor)).pcolor(Color.getRGBListByARGB(argb));
                        }
                        catch (AgentException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
                --currentPycor;
            }
            ++currentPxcor;
        }
    }

    private static class CachedColorLookup {
        private final Map<Integer, Double> cache = new HashMap<Integer, Double>();

        private CachedColorLookup() {
        }

        double lookupColor(int argb) {
            Integer boxed = argb;
            Double value = this.cache.get(boxed);
            if (value == null && !this.cache.containsKey(boxed)) {
                value = Color.getClosestColorNumberByARGB(argb);
                this.cache.put(boxed, value);
            }
            return value;
        }
    }
}

