/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import java.util.List;
import org.nlogo.agent.ImporterJ;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Color$;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.PlotState$;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.AgentVariables$;
import org.nlogo.core.Breed;
import org.nlogo.core.PlotPenState;
import org.nlogo.core.PlotPenState$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.ListMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class Importer
extends ImporterJ {
    public Importer(ImporterJ.ErrorHandler _errorHandler, World _world, ImporterUser _importerUser, ImporterJ.StringReader _stringReader) {
        super(_errorHandler, _world, _importerUser, _stringReader);
    }

    @Override
    public String[] getImplicitVariables(AgentKind kind) {
        AgentKind agentKind = kind;
        if (AgentKind$Observer$.MODULE$.equals(agentKind)) {
            return (String[])AgentVariables$.MODULE$.implicitObserverVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        }
        if (AgentKind$Turtle$.MODULE$.equals(agentKind)) {
            return (String[])AgentVariables$.MODULE$.implicitTurtleVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        }
        if (AgentKind$Patch$.MODULE$.equals(agentKind)) {
            return (String[])AgentVariables$.MODULE$.implicitPatchVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        }
        if (AgentKind$Link$.MODULE$.equals(agentKind)) {
            return (String[])AgentVariables$.MODULE$.implicitLinkVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        }
        throw new MatchError((Object)agentKind);
    }

    @Override
    public String[] getSpecialObserverVariables() {
        return new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", "SCREEN-EDGE-X", "SCREEN-EDGE-Y", "PERSPECTIVE", "SUBJECT", "NEXTINDEX", "DIRECTED-LINKS", "TICKS"};
    }

    @Override
    public String[] getSpecialTurtleVariables() {
        scala.collection.immutable.Seq<String> vars = AgentVariables$.MODULE$.implicitTurtleVariables();
        return new String[]{(String)vars.apply(Turtle.VAR_WHO), (String)vars.apply(Turtle.VAR_BREED), (String)vars.apply(Turtle.VAR_LABEL), (String)vars.apply(Turtle.VAR_SHAPE)};
    }

    @Override
    public String[] getSpecialPatchVariables() {
        scala.collection.immutable.Seq<String> vars = AgentVariables$.MODULE$.implicitPatchVariables();
        return new String[]{(String)vars.apply(Patch.VAR_PXCOR), (String)vars.apply(Patch.VAR_PYCOR), (String)vars.apply(Patch.VAR_PLABEL)};
    }

    @Override
    public String[] getSpecialLinkVariables() {
        scala.collection.immutable.Seq<String> vars = AgentVariables$.MODULE$.implicitLinkVariables();
        return new String[]{(String)vars.apply(Link.VAR_BREED), (String)vars.apply(Link.VAR_LABEL), (String)vars.apply(Link.VAR_END1), (String)vars.apply(Link.VAR_END2)};
    }

    @Override
    public List<String> getAllVars(ListMap<String, Breed> breeds) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)breeds.values().flatMap((Function1 & Serializable)_$1 -> _$1.owns())).toSeq()).asJava();
    }

    @Override
    public void importPlots() {
        if (this.hasMoreLines(false)) {
            String[] firstLine = this.nextLine();
            String currentPlot = firstLine[0];
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(currentPlot))) {
                this.importerUser.currentPlot(currentPlot);
            }
            while (this.hasMoreLines(false)) {
                String[] line = this.nextLine();
                try {
                    String plotName = (String)this.getTokenValue(line[0], false, false);
                    Option<PlotInterface> option = this.importerUser.maybeGetPlot(plotName);
                    if (option instanceof Some) {
                        PlotInterface plot = (PlotInterface)((Some)option).value();
                        Tuple2<Object, Option<String>> tuple2 = this.importIntro(plot);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int numPens = BoxesRunTime.unboxToInt((Object)tuple2._1());
                        Option currentPenNameOpt = (Option)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numPens), (Object)currentPenNameOpt);
                        int numPens2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
                        Option currentPenNameOpt2 = (Option)tuple22._2();
                        this.importPens(plot, numPens2);
                        this.importPoints(plot);
                        currentPenNameOpt2.foreach(pen -> plot.currentPenByName_$eq((String)pen));
                        continue;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.errorHandler.showError("Error Importing Plots", "The plot \"" + plotName + "\" does not exist.", false);
                        while (this.hasMoreLines(false)) {
                        }
                        return;
                    }
                    throw new MatchError(option);
                }
                catch (ClassCastException e) {
                    throw new ImporterJ.AbortingImportException(ImporterJ.ImportError.ILLEGAL_CLASS_CAST_ERROR, "");
                }
            }
            return;
        }
    }

    private Tuple2<Object, Option<String>> importIntro(PlotInterface plot) {
        if (!this.hasMoreLines(false)) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)None$.MODULE$);
        }
        if (!this.hasMoreLines(false)) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)None$.MODULE$);
        }
        String[] line = this.nextLine();
        double d = this.readNumber(line[0]);
        double d2 = this.readNumber(line[1]);
        double d3 = this.readNumber(line[2]);
        double d4 = this.readNumber(line[3]);
        boolean bl = this.readBoolean(line[4]);
        boolean bl2 = this.readBoolean(line[4]);
        plot.state_$eq(PlotState$.MODULE$.apply(bl, bl2, d, d2, d3, d4));
        plot.legendIsOpen_$eq(this.readBoolean(line[6]));
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.readNumber(line[7]))), (Object)Option$.MODULE$.apply((Object)this.readString(line[5])));
    }

    public void importPens(PlotInterface plot, int numPens) {
        if (this.hasMoreLines(false)) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPens).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.hasMoreLines(false)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                String[] line = this.nextLine();
                Object object = this.getTokenValue(line[0], false, false);
                if (object instanceof String) {
                    String name = (String)object;
                    Option<PlotPenInterface> option = plot.getPen(name);
                    if (option instanceof Some) {
                        PlotPenInterface pen = (PlotPenInterface)((Some)option).value();
                        boolean bl = this.readBoolean(line[1]);
                        int n = (int)this.readNumber(line[2]);
                        double d = this.readNumber(line[3]);
                        int n2 = Color$.MODULE$.getARGBbyPremodulatedColorNumber(this.readNumber(line[4]));
                        double d2 = this.readNumber(line[5]);
                        boolean bl2 = PlotPenState$.MODULE$.$lessinit$greater$default$6();
                        pen.state_$eq(PlotPenState$.MODULE$.apply(d2, n2, d, n, bl, bl2));
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.errorHandler.showError("Error Importing Plots", "The pen \"" + name + "\" does not exist.", false);
                        while (this.hasMoreLines(false)) {
                            this.nextLine();
                        }
                        return;
                    }
                    throw new MatchError(option);
                }
            });
            return;
        }
    }

    public void importPoints(PlotInterface plot) {
        if (this.hasMoreLines(false)) {
            Object[] line = this.nextLine();
            Object object = Predef$.MODULE$.refArrayOps(line);
            int penCount = (ArrayOps$.MODULE$.size$extension(object) - 1) / 4 + 1;
            Object[] pens = (String[])Array$.MODULE$.tabulate(penCount, arg_0 -> this.$anonfun$adapted$1((String[])line, arg_0), ClassTag$.MODULE$.apply(String.class));
            if (this.hasMoreLines(false)) {
                while (this.hasMoreLines(true)) {
                    String[] data = this.nextLine();
                    Object object2 = Predef$.MODULE$.refArrayOps(pens);
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object2)).foreach(arg_0 -> this.importPoints$$anonfun$adapted$1(plot, (String[])pens, data, arg_0));
                }
                return;
            }
            return;
        }
    }

    private void importPointHelper(PlotInterface plot, PlotPenInterface pen, String[] data, int i) {
        try {
            PlotPenState plotPenState = pen.state();
            int n = Color$.MODULE$.getARGBbyPremodulatedColorNumber(this.readNumber(data[i * 4 + 2]));
            boolean bl = this.readBoolean(data[i * 4 + 3]);
            double d = plotPenState.copy$default$1();
            double d2 = plotPenState.copy$default$3();
            int n2 = plotPenState.copy$default$4();
            boolean bl2 = plotPenState.copy$default$6();
            pen.state_$eq(plotPenState.copy(d, n, d2, n2, bl, bl2));
            plot.plot(this.readNumber(data[i * 4]), this.readNumber(data[i * 4 + 1]));
        }
        catch (ClassCastException e) {
            this.errorHandler.showError("Import Error", "Error while importing " + plot.name() + ", this point will be skipped.", false);
        }
    }

    private double readNumber(String line) {
        Object object = this.getTokenValue(line, false, false);
        if (object instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        return 0.0;
    }

    private boolean readBoolean(String line) {
        Object object = this.getTokenValue(line, false, false);
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        return false;
    }

    private String readString(String line) {
        Object object = this.getTokenValue(line, false, false);
        if (object instanceof String) {
            String s = (String)object;
            return s;
        }
        return null;
    }

    private final /* synthetic */ String $anonfun$1(String[] line$1, int i) {
        return this.readString(line$1[i * 4]);
    }

    private final /* synthetic */ Object importPoints$$anonfun$1(PlotInterface plot$3, String[] pens$1, String[] data$1, int i) {
        Option<PlotPenInterface> option = plot$3.getPen(pens$1[i]);
        if (option instanceof Some) {
            PlotPenInterface pen = (PlotPenInterface)((Some)option).value();
            plot$3.currentPenByName_$eq(pen.name());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(data$1[i * 4]))) {
                PlotPenState oldState = pen.state();
                this.importPointHelper(plot$3, pen, data$1, i);
                pen.state_$eq(oldState);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)this.errorHandler.showError("Error Importing Plots", "The pen \"" + pens$1[i] + "\" does not exist.", false));
        }
        throw new MatchError(option);
    }
}

