/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ImportLexer;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.LogoException;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.AgentVariables;
import org.nlogo.core.Breed;
import org.nlogo.core.WorldDimensions;
import scala.collection.immutable.ListMap;

public abstract class ImporterJ
implements ImportErrorHandler {
    final ImporterUser importerUser;
    final ErrorHandler errorHandler;
    final World world;
    final StringReader stringReader;
    Set<Object> shapesNotToImport;
    Set<String> breedsNotToImport;
    List<String> someBreedOwns;
    List<String> someLinkBreedOwns;
    static final String SCREEN_EDGE_X_HEADER = "SCREEN-EDGE-X";
    static final String SCREEN_EDGE_Y_HEADER = "SCREEN-EDGE-Y";
    static final String MIN_PXCOR_HEADER = "MIN-PXCOR";
    static final String MAX_PXCOR_HEADER = "MAX-PXCOR";
    static final String MIN_PYCOR_HEADER = "MIN-PYCOR";
    static final String MAX_PYCOR_HEADER = "MAX-PYCOR";
    static final String PERSPECTIVE_HEADER = "PERSPECTIVE";
    static final String SUBJECT_HEADER = "SUBJECT";
    static final String NEXT_INDEX_HEADER = "NEXTINDEX";
    static final String DIRECTED_LINKS_HEADER = "DIRECTED-LINKS";
    static final String TICKS_HEADER = "TICKS";
    boolean needToResize = false;
    private boolean olderThan40beta2 = false;
    BitSet varsToImport;
    String[] builtInVars;
    boolean tooManyValuesForSection = false;
    boolean convertPenDown = false;
    boolean convertTopology = false;
    boolean importLinks = true;
    int TURTLE_BREED;
    int perspectiveType = 0;
    Map<AgentKind, List<String>> specialVariables;
    Map<AgentKind, List<String>> essentialVarHeadersToImport;
    int lineNum = 0;
    String nextLine;
    private String[] nextLineFields;
    private static final int REQUIRED_SECTIONS = 3;
    private final String[] sentinels = new String[]{"GLOBALS", "TURTLES", "PATCHES", "LINKS", "DRAWING", "OUTPUT", "PLOTS", "EXTENSIONS", "DONE"};
    private final int numSentinels = this.sentinels.length - 1;
    private int currentSentinel = 0;
    BufferedReader lines;
    static final String NO_DETAILS = "";

    void setupVarsToImport(int size) {
        this.varsToImport = new BitSet(size);
        for (int j = 0; j < size; ++j) {
            this.varsToImport.set(j);
        }
    }

    public ImporterJ(ErrorHandler errorHandler, World world, ImporterUser importerUser, StringReader stringReader) {
        this.errorHandler = errorHandler;
        this.world = world;
        this.importerUser = importerUser;
        this.stringReader = stringReader;
        this.TURTLE_BREED = 8;
        this.shapesNotToImport = new HashSet<Object>();
        this.breedsNotToImport = new HashSet<String>();
        this.someBreedOwns = this.getAllBreedVars();
        this.someLinkBreedOwns = this.getAllLinkBreedVars();
        this.specialVariables = this.fillSpecialVariables();
    }

    void checkVersion(String versionNumber) throws AbortingImportException {
        if (versionNumber.startsWith("1.") || versionNumber.startsWith("2.0") || versionNumber.startsWith("2.1") || versionNumber.startsWith("2.2pre1") || versionNumber.startsWith("2.2pre2")) {
            this.convertPenDown = true;
            this.convertTopology = true;
            this.importLinks = false;
        } else if (versionNumber.startsWith("3.0")) {
            this.convertTopology = true;
            this.importLinks = false;
        }
        if (versionNumber.startsWith("1.") || versionNumber.startsWith("2.") || versionNumber.startsWith("3.")) {
            this.importLinks = false;
        }
        if (versionNumber.startsWith("1.") || versionNumber.startsWith("2.") || versionNumber.startsWith("3.") || versionNumber.startsWith("4.0pre") || versionNumber.startsWith("4.0alpha") || versionNumber.startsWith("4.0beta1")) {
            this.olderThan40beta2 = true;
        }
    }

    abstract void importPlots();

    public void importWorld(BufferedReader fileBuff) throws IOException {
        this.lines = fileBuff;
        try {
            while (this.hasMoreLines(false)) {
                String versionHeader;
                String[] line = this.nextLine();
                if (line[0].startsWith(versionHeader = "export-world data (NetLogo ")) {
                    String versionNumber = line[0].substring(versionHeader.length());
                    this.checkVersion(versionNumber);
                }
                if (!line[0].trim().equals("RANDOM STATE")) continue;
                this.hasMoreLines(false);
                line = this.nextLine();
                this.world.mainRNG().load(line[0]);
            }
            this.essentialVarHeadersToImport = this.fillEssentialVarsToImport();
            this.world.clearAll();
            this.importAgents(AgentKindJ.Observer());
            this.importAgents(AgentKindJ.Turtle());
            this.importAgents(AgentKindJ.Patch());
            this.checkForBlankTurtles();
            if (this.importLinks) {
                this.importAgents(AgentKindJ.Link());
            }
            if (this.nextLine != null && this.nextLine.indexOf("DRAWING") != -1) {
                this.importDrawing();
            }
            if (this.nextLine != null && this.nextLine.indexOf("OUTPUT") != -1) {
                this.importOutputArea();
            }
            if (this.needToResize) {
                this.importerUser.resizeView();
            }
            this.importPlots();
            this.importExtensionData();
        }
        catch (AbortingImportException aix) {
            this.world.clearAll();
            if (aix.errorType != ImportError.ERROR_GIVEN) {
                this.showError(aix);
            }
        }
        catch (InvalidDataException e) {
            this.errorHandler.showError("Error Importing Drawing", "Invalid data length, the drawing will not be imported", false);
        }
    }

    void importOutputArea() throws IOException {
        StringBuilder outputString = new StringBuilder();
        while (this.hasMoreLines(false)) {
            String[] fields = this.nextLine();
            for (int i = 0; i < fields.length; ++i) {
                outputString.append(fields[i]);
            }
        }
        if (outputString.length() > 0) {
            this.importerUser.setOutputAreaContents((String)this.getTokenValue(outputString.toString(), false, false));
        } else {
            this.importerUser.setOutputAreaContents(NO_DETAILS);
        }
    }

    void importDrawing() throws IOException {
        if (this.hasMoreLines(false)) {
            Double patchSize = Double.valueOf(this.nextLine()[0]);
            this.importerUser.patchSize(patchSize);
            this.importerUser.resizeView();
            this.needToResize = false;
            this.hasMoreLines(false);
            String[] tempLine = this.nextLine();
            String nextie = tempLine[0];
            if (nextie.matches("data:image/.*;base64,.*")) {
                this.world.trailDrawer().importDrawingBase64(nextie);
                this.hasMoreLines(false);
            } else {
                int width = (int)(patchSize * (double)this.world.worldWidth());
                int height = (int)(patchSize * (double)this.world.worldHeight());
                StringBuilder colorString = new StringBuilder(width * height * 32);
                try {
                    for (int i = 0; i < tempLine.length; ++i) {
                        colorString.append(this.stringReader.readFromString(tempLine[i].replaceAll(",", NO_DETAILS)));
                    }
                    while (this.hasMoreLines(false)) {
                        String[] line = this.nextLine();
                        for (int i = 0; i < line.length; ++i) {
                            colorString.append(this.stringReader.readFromString(line[i].replaceAll(",", NO_DETAILS)));
                        }
                    }
                    int[] colors = ImporterJ.fromHexString(colorString.toString());
                    if (colors.length != width * height * 4) {
                        throw new InvalidDataException("The data was not the correct length for the size of the world");
                    }
                    this.world.trailDrawer().setColors(colors, width, height);
                }
                catch (StringReaderException e) {
                    throw new InvalidDataException("invalid drawing data: drawing will not be imported");
                }
            }
        }
    }

    public void importExtensionData() {
        try {
            if (this.hasMoreLines(false)) {
                String[] line = this.nextLine();
                String extensionName = line[0];
                while (this.hasMoreLines(false)) {
                    ArrayList<String[]> lines = new ArrayList<String[]>();
                    while (!this.importerUser.isExtensionName((line = this.nextLine())[0])) {
                        lines.add(line);
                        if (this.hasMoreLines(false)) continue;
                    }
                    this.importerUser.importExtensionData(extensionName, lines, this);
                    extensionName = line[0];
                }
            }
        }
        catch (ExtensionException e) {
            this.errorHandler.showError("Error Importing Extension Data", e.getMessage(), false);
        }
        catch (IOException e) {
            this.errorHandler.showError("Error Importing Extension Data", e.getMessage(), false);
        }
    }

    void importAgents(AgentKind kind) throws IOException {
        this.tooManyValuesForSection = false;
        this.builtInVars = this.getImplicitVariables(kind);
        String[] headers = this.getHeaders(kind);
        this.setupVarsToImport(headers.length);
        while (this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            this.importOneAgent(kind, line, headers);
        }
    }

    void importOneAgent(AgentKind kind, String[] line, String[] headers) {
        Map<String, Object> varVals = this.getVarVals(headers, line, kind);
        if (kind == AgentKindJ.Observer()) {
            this.setScreenDimensions(varVals);
        }
        varVals = this.getVarVals(headers, line, kind);
        Agent agent = this.nextAgent(kind, varVals);
        for (int i = 0; i < headers.length; ++i) {
            Object value;
            String header = headers[i];
            if (this.isSpecialVariable(kind, header)) {
                this.handleSpecialVariable(agent, header, varVals, i);
                continue;
            }
            int varIndex = this.getVarIndex(agent, header, i);
            if (varIndex == -1 || (value = varVals.get(header)) == null) continue;
            this.setVarVal(agent, varIndex, header, value);
        }
    }

    Agent nextAgent(AgentKind kind, Map<String, Object> varVals) {
        if (kind == AgentKindJ.Observer()) {
            return this.world.observer();
        }
        if (kind == AgentKindJ.Turtle()) {
            AgentSet breed = this.getTurtleBreed(varVals, this.builtInVars[this.TURTLE_BREED]);
            long id = this.getTurtleId(varVals, this.builtInVars[0]);
            Turtle turtle = this.world.getOrCreateTurtle(id);
            turtle.setBreed(breed);
            return turtle;
        }
        if (kind == AgentKindJ.Patch()) {
            return this.getPatch(varVals);
        }
        if (kind == AgentKindJ.Link()) {
            AgentSet breed = this.getLinkBreed(varVals, this.builtInVars[6]);
            Turtle end1 = this.getLinkEnd(varVals, this.builtInVars[0]);
            Turtle end2 = this.getLinkEnd(varVals, this.builtInVars[1]);
            return this.world.getOrCreateLink(end1, end2, breed);
        }
        return null;
    }

    void handleSpecialVariable(Agent agent, String header, Map<String, Object> varVals, int headerIndex) {
        try {
            if (!(agent instanceof Observer)) {
                int varIndex = this.getVarIndex(agent, header, headerIndex);
                if (varIndex != -1) {
                    if (agent instanceof Turtle) {
                        this.handleSpecialTurtleVariable((Turtle)agent, varVals.get(header), varIndex);
                    } else if (agent instanceof Patch) {
                        this.handleSpecialPatchVariable((Patch)agent, varVals.get(header), varIndex);
                    } else if (agent instanceof Link) {
                        this.handleSpecialLinkVariable((Link)agent, varVals.get(header), varIndex, header);
                    }
                }
            } else {
                this.handleSpecialObserverVariable((Observer)agent, varVals.get(header), header);
            }
        }
        catch (ImportException ix) {
            this.showError(ix);
        }
    }

    void handleSpecialObserverVariable(Observer observer, Object val, String header) {
        if (header.equals(PERSPECTIVE_HEADER)) {
            this.perspectiveType = ((Double)val).intValue();
        } else if (header.equals(SUBJECT_HEADER) && val instanceof Agent) {
            int followDistance = 0;
            if (this.perspectiveType == 2) {
                followDistance = 5;
            }
            Perspective newPerspective = PerspectiveJ.create(this.perspectiveType, (Agent)val, followDistance);
            observer.setPerspective(newPerspective);
        } else if (header.equals(NEXT_INDEX_HEADER)) {
            this.world.nextTurtleIndex(((Double)val).longValue());
        } else if (header.equals(DIRECTED_LINKS_HEADER)) {
            String str = (String)val;
            if (!str.equals("NEITHER")) {
                this.world.links().setDirected(str.equals("DIRECTED"));
            }
        } else if (header.equals(TICKS_HEADER)) {
            this.world.tickCounter().ticks_$eq((Double)val);
        }
    }

    void handleSpecialTurtleVariable(Turtle turtle, Object val, int varIndex) {
        switch (varIndex) {
            case 5: {
                this.setTurtleShape(turtle, val, this.builtInVars[5], varIndex);
                break;
            }
            case 6: {
                this.setVarVal(turtle, varIndex, this.builtInVars[6], this.getLabel(val));
                break;
            }
            case 0: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void handleSpecialLinkVariable(Link link, Object val, int varIndex, String header) {
        switch (varIndex) {
            case 3: {
                this.setVarVal(link, varIndex, this.builtInVars[3], this.getLabel(val));
                break;
            }
            case 0: 
            case 1: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void handleSpecialPatchVariable(Patch patch, Object val, int varIndex) {
        switch (varIndex) {
            case 3: {
                this.setVarVal(patch, varIndex, this.builtInVars[3], this.getLabel(val));
                break;
            }
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    String[] getHeaders(AgentKind kind) throws IOException {
        if (!this.hasMoreLines(false)) {
            String abortingError = "No " + this.printName(kind) + " headers have been imported. Globals, Turtles, and Patches must be in the same import file.";
            throw new AbortingImportException(ImportError.UNEXPECTED_EOF_ERROR, abortingError);
        }
        String[] mixedCaseHeaders = this.nextLine();
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < mixedCaseHeaders.length; ++i) {
            if (mixedCaseHeaders[i].trim().equals(NO_DETAILS)) continue;
            if (this.convertPenDown && mixedCaseHeaders[i].equalsIgnoreCase("PEN-DOWN?")) {
                headers.add("PEN-MODE");
                continue;
            }
            headers.add(mixedCaseHeaders[i].toUpperCase());
        }
        String[] headersArr = headers.toArray(new String[headers.size()]);
        this.varHeadersImported(kind, headersArr, true);
        this.varHeadersImported(kind, headersArr, false);
        return headersArr;
    }

    List<String> getOptionalHeaders(AgentKind kind) {
        if (this.convertPenDown && kind == AgentKindJ.Turtle()) {
            return Arrays.asList("PEN-SIZE", "PEN-COLOR");
        }
        if (this.olderThan40beta2 && kind == AgentKindJ.Link()) {
            return Arrays.asList("SHAPE", "TIE-MODE");
        }
        if (kind == AgentKindJ.Link()) {
            return Arrays.asList("TIE-MODE");
        }
        return null;
    }

    Map<String, Object> getVarVals(String[] headersArr, String[] values, AgentKind kind) {
        int i;
        HashMap<String, Object> varVals = new HashMap<String, Object>();
        if (!this.tooManyValuesForSection && values.length > headersArr.length) {
            for (i = headersArr.length; i < values.length; ++i) {
                if (values[i].equals(NO_DETAILS)) continue;
                this.tooManyValuesForSection = true;
                this.showError(new ImportException(ImportError.TOO_MANY_VALUES_ERROR, "Too Many Values For Agent", "There are a total of " + headersArr.length + " " + this.printName(kind) + " variables declared in this model (including built-in " + (kind == AgentKindJ.Turtle() || kind == AgentKindJ.Link() ? "and breed " : NO_DETAILS) + "variables).  The import-world file has at least one agent in the " + this.printSectionName() + " section with more than this number of values.", "All the extra values will be ignored for this section."));
            }
        }
        for (i = 0; i < headersArr.length; ++i) {
            Junk value;
            boolean linkBreedVar;
            boolean turtleBreedVar = kind == AgentKindJ.Turtle() && headersArr[i].equals(this.builtInVars[this.TURTLE_BREED]);
            boolean bl = linkBreedVar = kind == AgentKindJ.Link() && headersArr[i].equals(this.builtInVars[6]);
            if (this.convertPenDown && headersArr[i].equals("PEN-MODE")) {
                if (values[i].equalsIgnoreCase("FALSE")) {
                    values[i] = "\"up\"";
                } else if (values[i].equals("TRUE")) {
                    values[i] = "\"down\"";
                }
            }
            Junk junk = value = values[i].equals(NO_DETAILS) ? new Junk() : this.getTokenValue(values[i], turtleBreedVar, linkBreedVar);
            if (this.essentialVarHeadersToImport.get(kind).contains(headersArr[i]) && value instanceof Junk) {
                String abortingError = "A " + this.printName(kind) + " with the essential variable " + headersArr[i] + " cannot be imported since the agent's value in the import file for " + headersArr[i] + " could not be imported.";
                throw new AbortingImportException(ImportError.UNIMPORTED_ESSENTIAL_VAR_ERROR, abortingError);
            }
            varVals.put(headersArr[i], value);
        }
        return varVals;
    }

    boolean validBreed(String breed) {
        return this.world.getBreed(breed.toUpperCase(Locale.ENGLISH)) != null || breed.equalsIgnoreCase("TURTLES") || breed.equalsIgnoreCase("PATCHES") || breed.equalsIgnoreCase("LINKS");
    }

    Object getTokenValue(String valueString, boolean turtleBreedVar, boolean linkBreedVar) {
        try {
            return this.stringReader.readFromString(valueString);
        }
        catch (StringReaderException ex) {
            if (turtleBreedVar) {
                if (!this.breedsNotToImport.contains(valueString)) {
                    this.breedsNotToImport.add(valueString);
                    this.showError(new ImportException(ImportError.ILLEGAL_BREED_ERROR, "Illegal Breed", ex.getMessage(), "all turtles with this breed will be made as regular turtles"));
                }
                return this.world.turtles();
            }
            if (linkBreedVar) {
                if (!this.breedsNotToImport.contains(valueString)) {
                    this.breedsNotToImport.add(valueString);
                    this.showError(new ImportException(ImportError.ILLEGAL_BREED_ERROR, "Illegal Link Breed", ex.getMessage(), "all links with this breed will be made as regular links"));
                }
                return this.world.links();
            }
            this.showError(new ImportException(ImportError.PARSING_ERROR, "Parsing Error", "error parsing the values:\n" + valueString, "the import will continue if it can, but values for this agent's variables will be set to an appropriate default", ex.getMessage()));
            return new Junk();
        }
    }

    int getVarIndex(Agent agent, String header, int headerIndex) {
        AgentKind kind = agent.kind();
        int varIndex = Arrays.asList(this.builtInVars).indexOf(header);
        String agentType = this.printName(kind);
        if (varIndex == -1) {
            if (kind == AgentKindJ.Observer()) {
                varIndex = this.world.observerOwnsIndexOf(header);
            } else if (kind == AgentKindJ.Patch()) {
                varIndex = this.world.patchesOwnIndexOf(header);
            } else if (kind == AgentKindJ.Turtle() ? (varIndex = this.world.turtlesOwnIndexOf(header)) == -1 && (varIndex = this.getBreedVarIndex((Turtle)agent, header)) == -1 && this.someBreedOwns.contains(header) : kind == AgentKindJ.Link() && (varIndex = this.world.linksOwnIndexOf(header)) == -1 && (varIndex = this.getLinkBreedVarIndex((Link)agent, header)) == -1 && this.someLinkBreedOwns.contains(header)) {
                return -1;
            }
        }
        if (this.varsToImport.get(headerIndex) && varIndex == -1) {
            this.varsToImport.clear(headerIndex);
            this.showError(new ImportException(ImportError.ILLEGAL_AGENT_VAR_ERROR, "Illegal " + agentType + " Variable", "the " + agentType + " variable " + header + " does not exist in this model.", "the import will continue but this variable will be ignored."));
        }
        return varIndex;
    }

    int getBreedVarIndex(Turtle turtle, String header) {
        if (turtle.getBreed() != this.world.turtles() && this.world.breedOwns(turtle.getBreed(), header)) {
            return this.world.breedsOwnIndexOf(turtle.getBreed(), header);
        }
        return -1;
    }

    int getLinkBreedVarIndex(Link link, String header) {
        if (link.getBreed() != this.world.links() && this.world.linkBreedOwns(link.getBreed(), header)) {
            return this.world.linkBreedsOwnIndexOf(link.getBreed(), header);
        }
        return -1;
    }

    void setVarVal(Agent agent, int index, String header, Object value) {
        try {
            if (value instanceof Junk) {
                value = World.Zero();
            }
            agent.setVariable(index, value);
        }
        catch (AgentException ae) {
            this.showError(new ImportException(ImportError.SETTING_VAR_ERROR, "Error Setting Value", "could not set " + agent + "'s variable " + header + " to " + value, "the import will continue, but the variable will be set to an appropriate default."));
        }
        catch (LogoException ae) {
            this.showError(new ImportException(ImportError.SETTING_VAR_ERROR, "Error Setting Value", "could not set " + agent + "'s variable " + header + " to " + value, "the import will continue, but the variable will be set to an appropriate default."));
        }
    }

    Patch getPatch(Map<String, Object> varVals) {
        try {
            int pxcor = ((Double)varVals.get(this.builtInVars[0])).intValue();
            int pycor = ((Double)varVals.get(this.builtInVars[1])).intValue();
            if (!this.world.validPatchCoordinates(pxcor, pycor)) {
                String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be in range.";
                throw new AbortingImportException(ImportError.ILLEGAL_PCOR_ERROR, abortingError);
            }
            return this.world.fastGetPatchAt(pxcor, pycor);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Patch Coordinate- pxcor and pycor must be integers.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    long getTurtleId(Map<String, Object> varVals, String whoHeaderName) {
        try {
            return ((Double)varVals.get(whoHeaderName)).longValue();
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Who- a turtle's who must be an integer.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    long getLinkId(Map<String, Object> varVals, String whoHeaderName) {
        try {
            return ((Double)varVals.get(whoHeaderName)).longValue();
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal lwho- a link's who must be an integer.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    Turtle getLinkEnd(Map<String, Object> varVals, String headerName) {
        try {
            return (Turtle)varVals.get(headerName);
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal End a link's end points must be a turtle.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    void setTurtleShape(Turtle turtle, Object shape, String header, int varIndex) {
        try {
            turtle.setVariable(varIndex, shape);
        }
        catch (AgentException ae) {
            if (!this.shapesNotToImport.contains(shape)) {
                this.shapesNotToImport.add(shape);
                throw new ImportException(ImportError.ILLEGAL_SHAPE_ERROR, "Illegal Shape", ae.getMessage(), "setting " + turtle + "'s shape to its breed's default shape");
            }
            this.setVarVal(turtle, varIndex, header, this.world.turtleBreedShapes().breedShape(turtle.getBreed()));
        }
    }

    AgentSet getTurtleBreed(Map<String, Object> varVals, String breedHeaderName) {
        if (varVals.containsKey(breedHeaderName)) {
            return (AgentSet)varVals.get(breedHeaderName);
        }
        return this.world.turtles();
    }

    AgentSet getLinkBreed(Map<String, Object> varVals, String breedHeaderName) {
        if (varVals.containsKey(breedHeaderName)) {
            return (AgentSet)varVals.get(breedHeaderName);
        }
        return this.world.links();
    }

    Object getLabel(Object val) {
        if (val instanceof Junk) {
            return NO_DETAILS;
        }
        return val;
    }

    void setScreenDimensions(Map<String, Object> varVals) {
        try {
            int maxy;
            int miny;
            int maxx;
            int minx;
            if (!this.convertTopology) {
                minx = ((Double)varVals.get(MIN_PXCOR_HEADER)).intValue();
                maxx = ((Double)varVals.get(MAX_PXCOR_HEADER)).intValue();
                miny = ((Double)varVals.get(MIN_PYCOR_HEADER)).intValue();
                maxy = ((Double)varVals.get(MAX_PYCOR_HEADER)).intValue();
            } else {
                int sex = ((Double)varVals.get(SCREEN_EDGE_X_HEADER)).intValue();
                int sey = ((Double)varVals.get(SCREEN_EDGE_Y_HEADER)).intValue();
                minx = -sex;
                maxx = sex;
                miny = -sey;
                maxy = sey;
            }
            if (minx != this.world.minPxcor() || maxx != this.world.maxPxcor() || miny != this.world.minPycor() || maxy != this.world.maxPycor()) {
                this.importerUser.setDimensions(new WorldDimensions(minx, maxx, miny, maxy));
                this.needToResize = true;
            }
        }
        catch (ClassCastException cce) {
            String abortingError = "Illegal Screen dimension- max-px/ycor, min-px/ycor must be numbers.";
            throw new AbortingImportException(ImportError.ILLEGAL_CLASS_CAST_ERROR, abortingError);
        }
    }

    abstract List<String> getAllVars(ListMap<String, Breed> var1);

    List<String> getAllBreedVars() {
        return this.getAllVars(this.world.program().breeds());
    }

    List<String> getAllLinkBreedVars() {
        return this.getAllVars(this.world.program().linkBreeds());
    }

    Map<AgentKind, List<String>> fillSpecialVariables() {
        HashMap<AgentKind, List<String>> result = new HashMap<AgentKind, List<String>>();
        List<String> specialObserverVars = this.stringArrayToList(this.getSpecialObserverVariables());
        List<String> specialTurtleVars = this.stringArrayToList(this.getSpecialTurtleVariables());
        List<String> specialPatchVars = this.stringArrayToList(this.getSpecialPatchVariables());
        List<String> specialLinkVars = this.stringArrayToList(this.getSpecialLinkVariables());
        result.put(AgentKindJ.Observer(), specialObserverVars);
        result.put(AgentKindJ.Turtle(), specialTurtleVars);
        result.put(AgentKindJ.Patch(), specialPatchVars);
        result.put(AgentKindJ.Link(), specialLinkVars);
        return result;
    }

    private List<String> stringArrayToList(String[] vars) {
        ArrayList<String> list = new ArrayList<String>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            list.add(vars[i]);
        }
        return list;
    }

    abstract String[] getSpecialObserverVariables();

    abstract String[] getSpecialTurtleVariables();

    abstract String[] getSpecialPatchVariables();

    abstract String[] getSpecialLinkVariables();

    boolean isSpecialVariable(AgentKind kind, String header) {
        return this.specialVariables.get(kind).contains(header);
    }

    Map<AgentKind, List<String>> fillEssentialVarsToImport() {
        HashMap<AgentKind, List<String>> result = new HashMap<AgentKind, List<String>>();
        List<String> essentialObserverVarHeaders = !this.convertTopology ? this.stringArrayToList(this.getEssentialObserverVars()) : this.stringArrayToList(this.getEssentialObserverVarsOld());
        List<String> essentialTurtleVarHeaders = this.stringArrayToList(this.getEssentialTurtleVariables());
        List<String> essentialPatchVarHeaders = this.stringArrayToList(this.getEssentialPatchVariables());
        List<String> essentialLinkVarHeaders = this.stringArrayToList(this.getEssentialLinkVariables());
        result.put(AgentKindJ.Observer(), essentialObserverVarHeaders);
        result.put(AgentKindJ.Turtle(), essentialTurtleVarHeaders);
        result.put(AgentKindJ.Patch(), essentialPatchVarHeaders);
        result.put(AgentKindJ.Link(), essentialLinkVarHeaders);
        return result;
    }

    String[] getEssentialObserverVars() {
        return new String[]{MIN_PXCOR_HEADER, MAX_PXCOR_HEADER, MIN_PYCOR_HEADER, MAX_PYCOR_HEADER};
    }

    String[] getEssentialObserverVarsOld() {
        return new String[]{SCREEN_EDGE_X_HEADER, SCREEN_EDGE_Y_HEADER};
    }

    String[] getEssentialTurtleVariables() {
        return new String[]{AgentVariables.getImplicitTurtleVariables()[0]};
    }

    String[] getEssentialPatchVariables() {
        String[] vars = AgentVariables.getImplicitPatchVariables();
        return new String[]{vars[0], vars[1]};
    }

    String[] getEssentialLinkVariables() {
        String[] vars = AgentVariables.getImplicitLinkVariables();
        return new String[]{vars[0], vars[1]};
    }

    void varHeadersImported(AgentKind kind, String[] headers, boolean essentialHeaders) {
        List<String> headersToCheckFor = essentialHeaders ? this.essentialVarHeadersToImport.get(kind) : Arrays.asList(this.builtInVars);
        List<String> optionalHeaders = this.getOptionalHeaders(kind);
        for (int i = 0; i < headersToCheckFor.size(); ++i) {
            String header = headersToCheckFor.get(i);
            boolean foundHeader = false;
            for (int j = 0; j < headers.length; ++j) {
                if (!header.equals(headers[j])) continue;
                foundHeader = true;
                break;
            }
            if (foundHeader) continue;
            if (essentialHeaders) {
                String abortingError = header + " is not in the list of variables to be imported from the import file in the " + this.printSectionName() + " section. This variable is essential to a model.";
                throw new AbortingImportException(ImportError.UNDECLARED_ESSENTIAL_VAR_ERROR, abortingError);
            }
            if (optionalHeaders != null && optionalHeaders.contains(header)) continue;
            this.showError(new ImportException(ImportError.UNDECLARED_AGENT_VAR_ERROR, "Implicit Variable Not Declared", "the " + this.printName(kind) + " variable " + header + " was not declared.", "the import will continue but all agents with this variable will have it set to an appropriate default."));
        }
    }

    abstract String[] getImplicitVariables(AgentKind var1);

    public boolean hasMoreLines(boolean returnBlankLines) throws IOException {
        this.nextLine = this.lines.readLine();
        ++this.lineNum;
        if (this.nextLine == null) {
            if (this.currentSentinel != this.numSentinels) {
                if (this.sentinels[this.currentSentinel].equals("DRAWING") || this.sentinels[this.currentSentinel].equals("LINKS") || this.sentinels[this.currentSentinel].equals("OUTPUT") || this.sentinels[this.currentSentinel].equals("PLOTS") || this.sentinels[this.currentSentinel].equals("EXTENSIONS")) {
                    ++this.currentSentinel;
                    return false;
                }
                String abortingError = "No " + this.sentinels[this.currentSentinel] + " have been imported.  Globals, Turtles, and Patches must be in the same import file.";
                throw new AbortingImportException(ImportError.UNEXPECTED_EOF_ERROR, abortingError);
            }
            return false;
        }
        if (this.nextLine.equals(NO_DETAILS)) {
            if (returnBlankLines) {
                return false;
            }
            return this.hasMoreLines(false);
        }
        try {
            this.nextLineFields = ImportLexer.lex(this.nextLine);
        }
        catch (ImportLexer.LexerException le) {
            throw new AbortingImportException(ImportError.CSV_LEXING_ERROR, "At line " + this.lineNum + ": " + le.getMessage());
        }
        if (this.nextLineFields.length <= 0) {
            if (returnBlankLines) {
                return true;
            }
            return this.hasMoreLines(returnBlankLines);
        }
        if (this.nextLineFields[0].toUpperCase().startsWith(this.sentinels[this.currentSentinel])) {
            ++this.currentSentinel;
            return false;
        }
        if (this.anotherSentinelEquals(this.nextLineFields[0].toUpperCase()) && this.lineNum > 3) {
            if (this.currentSentinel < 3) {
                String abortingError = "The agents are in the wrong order in the import file. The global variables should be first, followed by the turtles, followed by the patches.  Found " + this.nextLineFields[0] + " but needed " + this.sentinels[this.currentSentinel];
                throw new AbortingImportException(ImportError.FILE_STRUCTURE_ERROR, abortingError);
            }
            return false;
        }
        return true;
    }

    boolean anotherSentinelEquals(String line) {
        int i;
        for (i = 0; i < this.currentSentinel; ++i) {
            if (!line.equals(this.sentinels[i])) continue;
            return true;
        }
        for (i = this.currentSentinel + 1; i < this.numSentinels; ++i) {
            if (!line.equals(this.sentinels[i])) continue;
            return true;
        }
        return false;
    }

    String[] nextLine() {
        return this.nextLineFields;
    }

    public String next() {
        return this.nextLine;
    }

    String printSectionName() {
        return this.currentSentinel > 0 ? this.sentinels[this.currentSentinel - 1] : "UNKNOWN";
    }

    String printName(AgentKind kind) {
        if (kind == AgentKindJ.Observer()) {
            return "Global";
        }
        if (kind == AgentKindJ.Turtle()) {
            return "Turtle";
        }
        if (kind == AgentKindJ.Patch()) {
            return "Patch";
        }
        if (kind == AgentKindJ.Link()) {
            return "Link";
        }
        return NO_DETAILS;
    }

    void checkForBlankTurtles() {
        AgentIterator iter = this.world.turtles().iterator();
        while (iter.hasNext()) {
            Turtle turtle = (Turtle)iter.next();
            if (turtle.getBreed() != null) continue;
            String abortingError = turtle.toString() + " was referenced in an agentset or agent but was not defined in the TURTLES section.";
            throw new AbortingImportException(ImportError.BLANK_TURTLE_ERROR, abortingError);
        }
    }

    void showError(ImportException ix) {
        if (ix.type.compareTo(ImportError.LAST_NONFATAL_ERROR) > 0) {
            throw new AbortingImportException(ImportError.UNKNOWN_ERROR, "An unknown error has occurred. The import will now abort.");
        }
        if (!this.errorHandler.showError("Warning: " + ix.title, "Error Importing at Line " + this.lineNum + ": " + ix.message + "\n\nAction to be Taken: " + ix.action, false)) {
            throw new AbortingImportException(ImportError.ERROR_GIVEN, NO_DETAILS);
        }
    }

    @Override
    public void showError(String title, String message, String defaultAction) {
        this.showError(new ImportException(ImportError.PARSING_ERROR, title, message, defaultAction));
    }

    void showError(AbortingImportException aix) {
        this.errorHandler.showError(aix.title, aix.details, true);
    }

    Object readFromString(String s) throws StringReaderException {
        return this.stringReader.readFromString(s);
    }

    private static int[] fromHexString(String s) throws InvalidDataException {
        int stringLength = s.length();
        int[] ints = new int[stringLength / 8];
        if (stringLength % 8 == 0) {
            int i = 0;
            int j = 0;
            while (j < stringLength / 8) {
                ints[j] = ImporterJ.charToNibble(s.charAt(i++)) << 28;
                int n = j;
                ints[n] = ints[n] | ImporterJ.charToNibble(s.charAt(i++)) << 24;
                int n2 = j;
                ints[n2] = ints[n2] | ImporterJ.charToNibble(s.charAt(i++)) << 20;
                int n3 = j;
                ints[n3] = ints[n3] | ImporterJ.charToNibble(s.charAt(i++)) << 16;
                int n4 = j;
                ints[n4] = ints[n4] | ImporterJ.charToNibble(s.charAt(i++)) << 12;
                int n5 = j;
                ints[n5] = ints[n5] | ImporterJ.charToNibble(s.charAt(i++)) << 8;
                int n6 = j;
                ints[n6] = ints[n6] | ImporterJ.charToNibble(s.charAt(i++)) << 4;
                int n7 = j++;
                ints[n7] = ints[n7] | ImporterJ.charToNibble(s.charAt(i++));
            }
        } else {
            throw new InvalidDataException("The data must be a multiple of 4 to convert from Hex string to ints");
        }
        return ints;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public static interface ErrorHandler {
        public boolean showError(String var1, String var2, boolean var3);
    }

    public static interface StringReader {
        public Object readFromString(String var1) throws StringReaderException;
    }

    static class AbortingImportException
    extends RuntimeException {
        ImportError errorType;
        public String title;
        public String details;

        public AbortingImportException(ImportError errorType, String details) {
            super("Fatal Error Type:" + errorType);
            this.errorType = errorType;
            this.title = "Fatal Error- " + this.getErrorMessage();
            this.details = details + "\n\nThe import will now abort.";
        }

        String getErrorMessage() {
            String message;
            switch (this.errorType) {
                case ERROR_GIVEN: {
                    message = "Error Already Given";
                    break;
                }
                case ILLEGAL_CLASS_CAST_ERROR: {
                    message = "Illegal Type Cast";
                    break;
                }
                case UNEXPECTED_EOF_ERROR: {
                    message = "Unexpected End of File";
                    break;
                }
                case FILE_STRUCTURE_ERROR: {
                    message = "Incorrect Structure For Import File";
                    break;
                }
                case UNDECLARED_ESSENTIAL_VAR_ERROR: {
                    message = "Essential Variable Not Declared";
                    break;
                }
                case UNIMPORTED_ESSENTIAL_VAR_ERROR: {
                    message = "Essential Variable Not Imported";
                    break;
                }
                case BLANK_TURTLE_ERROR: {
                    message = "Referenced Turtle Not Defined";
                    break;
                }
                case CSV_LEXING_ERROR: {
                    message = "Invalid CSV File";
                    break;
                }
                case IMPORT_3D_ERROR: {
                    message = "You cannot import a 2D world into 3D NetLogo";
                    break;
                }
                default: {
                    message = "Unknown Fatal Error";
                }
            }
            return message;
        }
    }

    static enum ImportError {
        ILLEGAL_AGENT_VAR_ERROR,
        ILLEGAL_SHAPE_ERROR,
        ILLEGAL_BREED_ERROR,
        PARSING_ERROR,
        SETTING_VAR_ERROR,
        UNDECLARED_AGENT_VAR_ERROR,
        TOO_MANY_VALUES_ERROR,
        LAST_NONFATAL_ERROR,
        ILLEGAL_CLASS_CAST_ERROR,
        UNEXPECTED_EOF_ERROR,
        ERROR_GIVEN,
        FILE_STRUCTURE_ERROR,
        UNDECLARED_ESSENTIAL_VAR_ERROR,
        UNIMPORTED_ESSENTIAL_VAR_ERROR,
        BLANK_TURTLE_ERROR,
        CSV_LEXING_ERROR,
        ILLEGAL_PCOR_ERROR,
        IMPORT_3D_ERROR,
        UNKNOWN_ERROR;

    }

    static class InvalidDataException
    extends IOException {
        public InvalidDataException(String message) {
            super(message);
        }
    }

    public static class StringReaderException
    extends Exception {
        public StringReaderException(String message) {
            super(message);
        }
    }

    class ImportException
    extends RuntimeException {
        public ImportError type;
        public String message;
        public String action;
        public String title;

        public ImportException(ImportError errorType, String errorTitle, String errorMessage, String defaultAction) {
            super(errorTitle + "- Error Type: " + errorType);
            this.type = errorType;
            this.title = errorTitle;
            this.message = errorMessage;
            this.action = defaultAction;
        }

        public ImportException(ImportError errorType, String errorTitle, String errorMessage, String defaultAction, String additionalInfo) {
            this(errorType, errorTitle, errorMessage, defaultAction);
            this.message = this.message + "\n\nAdditional Information: " + additionalInfo;
        }
    }

    static class Junk {
        Junk() {
        }
    }
}

