/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.core.LogoList;

public final class Layouts {
    private Layouts() {
        throw new IllegalStateException();
    }

    public static void circle(World world, LogoList nodes, double radius) throws AgentException {
        int i = 0;
        int n = nodes.size();
        int midx = world.minPxcor() + (int)StrictMath.floor(world.worldWidth() / 2);
        int midy = world.minPycor() + (int)StrictMath.floor(world.worldHeight() / 2);
        Iterator<Object> it = nodes.javaIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Turtle) {
                Turtle t = (Turtle)obj;
                double heading = (double)i * 360.0 / (double)n;
                world.protractor().getPatchAtHeadingAndDistance(midx, midy, heading, radius);
                t.xandycor(midx, midy);
                t.heading(heading);
                t.jump(radius);
            }
            ++i;
        }
    }

    public static void circle(World world, AgentSet nodes, double radius, MersenneTwisterFast random) throws AgentException {
        int i = 0;
        int n = nodes.count();
        int midx = world.minPxcor() + (int)StrictMath.floor(world.worldWidth() / 2);
        int midy = world.minPycor() + (int)StrictMath.floor(world.worldHeight() / 2);
        AgentIterator it = nodes.shufflerator(random);
        while (it.hasNext()) {
            Turtle t = (Turtle)it.next();
            double heading = (double)i * 360.0 / (double)n;
            world.protractor().getPatchAtHeadingAndDistance(midx, midy, heading, radius);
            t.xandycor(midx, midy);
            t.heading(heading);
            t.jump(radius);
            ++i;
        }
    }

    public static void spring(World world, AgentSet nodeset, AgentSet linkset, double spr, double len, double rep, MersenneTwisterFast random) {
        if (world.program().dialect().is3D()) {
            Layouts.spring3D((World3D)world, nodeset, linkset, spr, len, rep, random);
        } else {
            Layouts.spring2D(world, nodeset, linkset, spr, len, rep, random);
        }
    }

    public static void spring2D(World world, AgentSet nodeset, AgentSet linkset, double spr, double len, double rep, MersenneTwisterFast random) {
        Link link;
        int nodeCount = nodeset.count();
        if (nodeCount == 0) {
            return;
        }
        double[] ax = new double[nodeCount];
        double[] ay = new double[nodeCount];
        int i = 0;
        HashMap<Turtle, Integer> tMap = new HashMap<Turtle, Integer>();
        int[] degCount = new int[nodeCount];
        Turtle[] agt = new Turtle[nodeCount];
        AgentIterator it = nodeset.shufflerator(random);
        while (it.hasNext()) {
            Turtle t;
            agt[i] = t = (Turtle)it.next();
            tMap.put(t, i);
            ax[i] = 0.0;
            ay[i] = 0.0;
            ++i;
        }
        it = linkset.iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            Turtle t1 = link.end1();
            Turtle t2 = link.end2();
            if (tMap.containsKey(t1)) {
                int t1Index;
                int n = t1Index = ((Integer)tMap.get(t1)).intValue();
                degCount[n] = degCount[n] + 1;
            }
            if (tMap.containsKey(t2)) {
                int t2Index;
                int n = t2Index = ((Integer)tMap.get(t2)).intValue();
                degCount[n] = degCount[n] + 1;
            }
            ++i;
        }
        it = linkset.iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            double dx = 0.0;
            double dy = 0.0;
            Turtle t1 = link.end1();
            Turtle t2 = link.end2();
            int t1Index = -1;
            int degCount1 = 0;
            if (tMap.containsKey(t1)) {
                t1Index = (Integer)tMap.get(t1);
                degCount1 = degCount[t1Index];
            }
            int t2Index = -1;
            int degCount2 = 0;
            if (tMap.containsKey(t2)) {
                t2Index = (Integer)tMap.get(t2);
                degCount2 = degCount[t2Index];
            }
            double dist = world.protractor().distance(t1, t2, false);
            double div = (double)(degCount1 + degCount2) / 2.0;
            div = StrictMath.max(div, 1.0);
            if (dist == 0.0) {
                dx += spr * len / div;
            } else {
                double f = spr * (dist - len) / div;
                dx += f * (t2.xcor() - t1.xcor()) / dist;
                dy += f * (t2.ycor() - t1.ycor()) / dist;
            }
            if (t1Index != -1) {
                int n = t1Index;
                ax[n] = ax[n] + dx;
                int n2 = t1Index;
                ay[n2] = ay[n2] + dy;
            }
            if (t2Index != -1) {
                int n = t2Index;
                ax[n] = ax[n] - dx;
                int n3 = t2Index;
                ay[n3] = ay[n3] - dy;
            }
            ++i;
        }
        for (i = 0; i < nodeCount; ++i) {
            Turtle t1 = agt[i];
            int j = i + 1;
            while (j < nodeCount) {
                Turtle t2 = agt[j];
                double dx = 0.0;
                double dy = 0.0;
                double div = (double)(degCount[i] + degCount[j]) / 2.0;
                div = StrictMath.max(div, 1.0);
                if (t2.xcor() == t1.xcor() && t2.ycor() == t1.ycor()) {
                    double ang = 360.0 * random.nextDouble();
                    dx = -(rep / div * StrictMath.sin(StrictMath.toRadians(ang)));
                    dy = -(rep / div * StrictMath.cos(StrictMath.toRadians(ang)));
                } else {
                    double dist = world.protractor().distance(t1, t2, false);
                    double f = rep / (dist * dist) / div;
                    dx = -(f * (t2.xcor() - t1.xcor()) / dist);
                    dy = -(f * (t2.ycor() - t1.ycor()) / dist);
                }
                int n = i;
                ax[n] = ax[n] + dx;
                int n4 = i;
                ay[n4] = ay[n4] + dy;
                int n5 = j;
                ax[n5] = ax[n5] - dx;
                int n6 = j++;
                ay[n6] = ay[n6] - dy;
            }
        }
        if (nodeCount > 1) {
            double perturbAmt = (double)(world.worldWidth() + world.worldHeight()) / 1.0E10;
            ax[0] = ax[0] + (random.nextDouble() * perturbAmt - perturbAmt / 2.0);
            ay[0] = ay[0] + (random.nextDouble() * perturbAmt - perturbAmt / 2.0);
        }
        double limit = (double)(world.worldWidth() + world.worldHeight()) / 50.0;
        for (i = 0; i < nodeCount; ++i) {
            Turtle t = agt[i];
            double fx = ax[i];
            double fy = ay[i];
            if (fx > limit) {
                fx = limit;
            } else if (fx < -limit) {
                fx = -limit;
            }
            if (fy > limit) {
                fy = limit;
            } else if (fy < -limit) {
                fy = -limit;
            }
            double newx = t.xcor() + fx;
            double newy = t.ycor() + fy;
            if (newx > (double)world.maxPxcor()) {
                newx = world.maxPxcor();
            } else if (newx < (double)world.minPxcor()) {
                newx = world.minPxcor();
            }
            if (newy > (double)world.maxPycor()) {
                newy = world.maxPycor();
            } else if (newy < (double)world.minPycor()) {
                newy = world.minPycor();
            }
            try {
                t.xandycor(newx, newy);
                continue;
            }
            catch (AgentException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public static void spring3D(World3D world, AgentSet nodeset, AgentSet linkset, double spr, double len, double rep, MersenneTwisterFast random) {
        Link link;
        int nodeCount = nodeset.count();
        if (nodeCount == 0) {
            return;
        }
        double[] ax = new double[nodeCount];
        double[] ay = new double[nodeCount];
        double[] az = new double[nodeCount];
        int i = 0;
        HashMap<Turtle3D, Integer> tMap = new HashMap<Turtle3D, Integer>();
        int[] degCount = new int[nodeCount];
        Turtle3D[] agt = new Turtle3D[nodeCount];
        AgentIterator it = nodeset.shufflerator(random);
        while (it.hasNext()) {
            Turtle3D t;
            agt[i] = t = (Turtle3D)it.next();
            tMap.put(t, i);
            ax[i] = 0.0;
            ay[i] = 0.0;
            az[i] = 0.0;
            ++i;
        }
        it = linkset.iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            Turtle t1 = link.end1();
            Turtle t2 = link.end2();
            if (tMap.containsKey(t1)) {
                int t1Index;
                int n = t1Index = ((Integer)tMap.get(t1)).intValue();
                degCount[n] = degCount[n] + 1;
            }
            if (tMap.containsKey(t2)) {
                int t2Index;
                int n = t2Index = ((Integer)tMap.get(t2)).intValue();
                degCount[n] = degCount[n] + 1;
            }
            ++i;
        }
        it = linkset.iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            double dx = 0.0;
            double dy = 0.0;
            double dz = 0.0;
            Turtle3D t1 = (Turtle3D)link.end1();
            Turtle3D t2 = (Turtle3D)link.end2();
            int t1Index = -1;
            int degCount1 = 0;
            if (tMap.containsKey(t1)) {
                t1Index = (Integer)tMap.get(t1);
                degCount1 = degCount[t1Index];
            }
            int t2Index = -1;
            int degCount2 = 0;
            if (tMap.containsKey(t2)) {
                t2Index = (Integer)tMap.get(t2);
                degCount2 = degCount[t2Index];
            }
            double dist = world.protractor().distance(t1, t2, false);
            double div = (double)(degCount1 + degCount2) / 2.0;
            div = StrictMath.max(div, 1.0);
            if (dist == 0.0) {
                dx += spr * len / div;
            } else {
                double f = spr * (dist - len) / div;
                dx += f * (t2.xcor() - t1.xcor()) / dist;
                dy += f * (t2.ycor() - t1.ycor()) / dist;
                dz += f * (t2.zcor() - t1.zcor()) / dist;
            }
            if (t1Index != -1) {
                int n = t1Index;
                ax[n] = ax[n] + dx;
                int n2 = t1Index;
                ay[n2] = ay[n2] + dy;
                int n3 = t1Index;
                az[n3] = az[n3] + dz;
            }
            if (t2Index != -1) {
                int n = t2Index;
                ax[n] = ax[n] - dx;
                int n4 = t2Index;
                ay[n4] = ay[n4] - dy;
                int n5 = t2Index;
                az[n5] = az[n5] - dz;
            }
            ++i;
        }
        for (i = 0; i < nodeCount; ++i) {
            Turtle3D t1 = agt[i];
            int j = i + 1;
            while (j < nodeCount) {
                Turtle3D t2 = agt[j];
                double dx = 0.0;
                double dy = 0.0;
                double dz = 0.0;
                double div = (double)(degCount[i] + degCount[j]) / 2.0;
                div = StrictMath.max(div, 1.0);
                if (t2.xcor() == t1.xcor() && t2.ycor() == t1.ycor() && t2.zcor() == t1.zcor()) {
                    double ang = 360.0 * random.nextDouble();
                    double zVal = rep * (2.0 * random.nextDouble() - 1.0);
                    double repFlat = StrictMath.sqrt(rep * rep - zVal * zVal);
                    dx = -(repFlat * StrictMath.sin(StrictMath.toRadians(ang)));
                    dy = -(repFlat * StrictMath.cos(StrictMath.toRadians(ang)));
                    dz = -zVal;
                } else {
                    double dist = world.protractor().distance(t1, t2, false);
                    double f = rep / (dist * dist) / div;
                    dx = -(f * (t2.xcor() - t1.xcor()) / dist);
                    dy = -(f * (t2.ycor() - t1.ycor()) / dist);
                    dz = -(f * (t2.zcor() - t1.zcor()) / dist);
                }
                int n = i;
                ax[n] = ax[n] + dx;
                int n6 = i;
                ay[n6] = ay[n6] + dy;
                int n7 = i;
                az[n7] = az[n7] + dz;
                int n8 = j;
                ax[n8] = ax[n8] - dx;
                int n9 = j;
                ay[n9] = ay[n9] - dy;
                int n10 = j++;
                az[n10] = az[n10] - dz;
            }
        }
        if (nodeCount > 1) {
            double perturbAmt = (double)(world.worldWidth() + world.worldHeight()) / 1.0E10;
            ax[0] = ax[0] + (random.nextDouble() * perturbAmt - perturbAmt / 2.0);
            ay[0] = ay[0] + (random.nextDouble() * perturbAmt - perturbAmt / 2.0);
            az[0] = az[0] + (random.nextDouble() * perturbAmt - perturbAmt / 2.0);
        }
        double limit = (double)(world.worldWidth() + world.worldHeight() + world.worldDepth()) / 75.0;
        for (i = 0; i < nodeCount; ++i) {
            Turtle3D t = agt[i];
            double fx = ax[i];
            double fy = ay[i];
            double fz = az[i];
            if (fx > limit) {
                fx = limit;
            } else if (fx < -limit) {
                fx = -limit;
            }
            if (fy > limit) {
                fy = limit;
            } else if (fy < -limit) {
                fy = -limit;
            }
            if (fz > limit) {
                fz = limit;
            } else if (fz < -limit) {
                fz = -limit;
            }
            double newx = t.xcor() + fx;
            double newy = t.ycor() + fy;
            double newz = t.zcor() + fz;
            if (newx > (double)world.maxPxcor()) {
                newx = world.maxPxcor();
            } else if (newx < (double)world.minPxcor()) {
                newx = world.minPxcor();
            }
            if (newy > (double)world.maxPycor()) {
                newy = world.maxPycor();
            } else if (newy < (double)world.minPycor()) {
                newy = world.minPycor();
            }
            if (newz > (double)world.maxPzcor()) {
                newz = world.maxPzcor();
            } else if (newz < (double)world.minPzcor()) {
                newz = world.minPzcor();
            }
            t.xyandzcor(newx, newy, newz);
        }
    }

    public static void tutte(World world, AgentSet nodeset, AgentSet linkset, double radius, MersenneTwisterFast random) throws AgentException {
        ArrayList<Turtle> anchors = new ArrayList<Turtle>();
        AgentIterator iter = linkset.iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            if (!nodeset.contains(link.end1()) && !anchors.contains(link.end1())) {
                anchors.add(link.end1());
            }
            if (nodeset.contains(link.end2()) || anchors.contains(link.end2())) continue;
            anchors.add(link.end2());
        }
        Layouts.circle(world, LogoList.fromJava(anchors), radius);
        int n = nodeset.count();
        Turtle[] agt = new Turtle[n];
        double[] ax = new double[n];
        double[] ay = new double[n];
        int ctr2 = 0;
        AgentIterator iter2 = nodeset.shufflerator(random);
        while (iter2.hasNext()) {
            agt[ctr2] = (Turtle)iter2.next();
            ++ctr2;
        }
        for (int i = 0; i < n; ++i) {
            Turtle t = agt[i];
            double fx = 0.0;
            double fy = 0.0;
            int degree = 0;
            AgentIterator it = world.links().shufflerator(random);
            while (it.hasNext()) {
                Link link = (Link)it.next();
                if (link.end1() != t && link.end2() != t || !linkset.contains(link)) continue;
                Turtle other = link.end1();
                if (t == link.end1()) {
                    other = link.end2();
                }
                fx += other.xcor();
                fy += other.ycor();
                ++degree;
            }
            fx /= (double)degree;
            fy /= (double)degree;
            fx -= t.xcor();
            fy -= t.ycor();
            double limit = 100.0;
            if (fx > limit) {
                fx = limit;
            } else if (fx < -limit) {
                fx = -limit;
            }
            if (fy > limit) {
                fy = limit;
            } else if (fy < -limit) {
                fy = -limit;
            }
            fx += t.xcor();
            fy += t.ycor();
            if (fx > (double)world.maxPxcor()) {
                fx = world.maxPxcor();
            } else if (fx < (double)world.minPxcor()) {
                fx = world.minPxcor();
            }
            if (fy > (double)world.maxPycor()) {
                fy = world.maxPycor();
            } else if (fy < (double)world.minPycor()) {
                fy = world.minPycor();
            }
            ax[i] = fx;
            ay[i] = fy;
        }
        Layouts.reposition(agt, ax, ay);
    }

    private static void reposition(Turtle[] agents, double[] x, double[] y) {
        try {
            for (int i = 0; i < agents.length; ++i) {
                agents[i].xandycor(x[i], y[i]);
            }
        }
        catch (AgentException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void radial(World world, AgentSet nodeset, AgentSet linkset, Turtle root) throws AgentException {
        double rootX = (double)(world.minPxcor() + world.maxPxcor()) / 2.0;
        double rootY = (double)(world.minPycor() + world.maxPycor()) / 2.0;
        LinkManager linkManager = world.linkManager();
        HashMap<Turtle, TreeNode> nodeTable = new HashMap<Turtle, TreeNode>(nodeset.count());
        ArrayList<TreeNode> queue = new ArrayList<TreeNode>(nodeset.count());
        TreeNode rootNode = new TreeNode(root, null);
        queue.add(rootNode);
        nodeTable.put(rootNode.val, rootNode);
        TreeNode lastNode = rootNode;
        HashSet<Turtle> allowedTurtles = null;
        if (!linkset.isBreedSet()) {
            allowedTurtles = new HashSet<Turtle>(linkset.count());
            AgentIterator it = linkset.iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                allowedTurtles.add(link.end1());
                allowedTurtles.add(link.end2());
            }
        }
        while (!queue.isEmpty()) {
            TreeNode node;
            lastNode = node = (TreeNode)queue.remove(0);
            for (Turtle t : linkManager.neighbors(node.val, linkset)) {
                if (!nodeset.contains(t) || nodeTable.containsKey(t) || allowedTurtles != null && !allowedTurtles.contains(t)) continue;
                TreeNode child = new TreeNode(t, node);
                node.children.add(child);
                nodeTable.put(t, child);
                queue.add(child);
            }
        }
        rootNode.layoutRadial(0.0, 360.0);
        double maxDepth = (double)lastNode.getDepth() + 0.2;
        if (maxDepth < 1.0) {
            maxDepth = 1.0;
        }
        double xDistToEdge = StrictMath.min((double)world.maxPxcor() - rootX, rootX - (double)world.minPxcor());
        double yDistToEdge = StrictMath.min((double)world.maxPycor() - rootY, rootY - (double)world.minPycor());
        double distToEdge = StrictMath.min(xDistToEdge, yDistToEdge);
        double layerGap = distToEdge / maxDepth;
        for (TreeNode node : nodeTable.values()) {
            Turtle t = node.val;
            t.heading(node.angle);
            t.xandycor(rootX, rootY);
            t.jump((double)node.getDepth() * layerGap);
        }
    }

    private static class TreeNode {
        public Turtle val;
        public TreeNode parent;
        public List<TreeNode> children = new ArrayList<TreeNode>(10);
        public double angle = 0.0;

        public TreeNode(Turtle val, TreeNode parent) {
            this.val = val;
            this.parent = parent;
        }

        public int getDepth() {
            int i = 0;
            TreeNode myParent = this.parent;
            while (myParent != null) {
                myParent = myParent.parent;
                ++i;
            }
            return i;
        }

        public double getWeight() {
            double myWeight = this.children.size() + 1;
            double maxChildWeight = 0.0;
            for (TreeNode child : this.children) {
                double cweight = child.getWeight();
                if (!(cweight > maxChildWeight)) continue;
                maxChildWeight = cweight;
            }
            return StrictMath.max(myWeight, maxChildWeight *= 0.8);
        }

        public void layoutRadial(double arcStart, double arcEnd) {
            this.angle = (arcStart + arcEnd) / 2.0;
            double weightSum = 0.0;
            for (TreeNode child : this.children) {
                weightSum += child.getWeight();
            }
            double childStart = arcStart;
            for (TreeNode child : this.children) {
                double childEnd = childStart + (arcEnd - arcStart) * child.getWeight() / weightSum;
                child.layoutRadial(childStart, childEnd);
                childStart = childEnd;
            }
        }
    }
}

