/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Iterator;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentColors;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.Breed;
import org.nlogo.core.I18N;
import org.nlogo.core.LogoList;
import org.nlogo.core.Program;
import org.nlogo.log.LogManager;
import scala.Option;

public class Link
extends Agent
implements org.nlogo.api.Link,
AgentColors {
    final Turtle _end1;
    final Turtle _end2;
    public static final int VAR_END1 = 0;
    public static final int VAR_END2 = 1;
    public static final int VAR_COLOR = 2;
    public static final int VAR_LABEL = 3;
    static final int VAR_LABELCOLOR = 4;
    static final int VAR_HIDDEN = 5;
    public static final int VAR_BREED = 6;
    public static final int VAR_THICKNESS = 7;
    public static final int VAR_SHAPE = 8;
    public static final int VAR_TIEMODE = 9;
    public int LAST_PREDEFINED_VAR = 9;
    public int NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
    public static final Double DEFAULT_COLOR = 5.0;
    public static final String MODE_NONE = "none";
    public static final String MODE_FREE = "free";
    public static final String MODE_FIXED = "fixed";
    public static final int BIT = 8;

    @Override
    public AgentKind kind() {
        return AgentKindJ.Link();
    }

    @Override
    public Turtle end1() {
        return this._end1;
    }

    @Override
    public Turtle end2() {
        return this._end2;
    }

    @Override
    public Object agentKey() {
        return this;
    }

    public Link(World world, Turtle end1, Turtle end2, int arraySize) {
        super(world);
        Object[] variables = new Object[arraySize];
        variables[0] = end1;
        variables[1] = end2;
        this._end1 = end1;
        this._end2 = end2;
        for (int i = 2; i < variables.length; ++i) {
            variables[i] = World.Zero();
        }
        this.setVariables(variables);
        this.colorDoubleUnchecked(DEFAULT_COLOR);
    }

    Link(World world, Turtle end1, Turtle end2, AgentSet breed) {
        super(world);
        Object[] variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)breed)];
        variables[2] = Color.BoxedBlack();
        variables[0] = end1;
        variables[1] = end2;
        variables[3] = "";
        variables[4] = Color.BoxedWhite();
        variables[5] = Boolean.FALSE;
        variables[7] = World.Zero();
        variables[8] = this._world.linkBreedShapes().breedShape(breed);
        variables[9] = MODE_NONE;
        this.setVariables(variables);
        this._end1 = end1;
        this._end2 = end2;
        variables[6] = breed;
        world.links().add(this);
        if (breed != world.links()) {
            ((TreeAgentSet)breed).add(this);
        }
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < variables.length; ++i) {
            variables[i] = World.Zero();
        }
        this.colorDoubleUnchecked(DEFAULT_COLOR);
    }

    public void die() {
        if (this._id == -1L) {
            return;
        }
        TreeAgentSet breed = this.getBreed();
        this._world.links().remove(this.agentKey());
        if (breed != this._world.links()) {
            breed.remove(this.agentKey());
        }
        this._world.linkManager().cleanupLink(this);
        Long oldId = this.id();
        this.setId(-1L);
        LogManager.linkRemoved(oldId, breed.printName(), this._end1.id(), this._end2.id());
    }

    @Override
    public Agent realloc(Program oldProgram, Program newProgram) {
        return this.realloc(oldProgram, newProgram, null);
    }

    Agent realloc(Program oldProgram, Program program, AgentSet oldBreed) {
        int oldpos;
        String name;
        int i;
        boolean compiling;
        boolean bl = compiling = oldProgram != null;
        if (compiling && this.getBreed() != this._world.links() && this._world.getLinkBreed(this.getBreed().printName()) == null) {
            return this;
        }
        Object[] oldvars = this.variables();
        Object[] variables = new Object[this._world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)this.getBreed())];
        int linksOwnSize = this._world.getVariablesArraySize((org.nlogo.api.Link)null, (org.nlogo.api.AgentSet)this._world.links());
        int numberToCopyDirectly = compiling ? this.NUMBER_PREDEFINED_VARS : linksOwnSize;
        System.arraycopy(oldvars, 0, variables, 0, numberToCopyDirectly);
        if (compiling) {
            for (i = this.NUMBER_PREDEFINED_VARS; i < linksOwnSize; ++i) {
                name = this._world.linksOwnNameAt(i);
                oldpos = oldProgram.linksOwn().indexOf((Object)name);
                if (oldpos == -1) {
                    variables[i] = World.Zero();
                    continue;
                }
                variables[i] = oldvars[oldpos];
                oldvars[oldpos] = null;
            }
        }
        for (i = linksOwnSize; i < variables.length; ++i) {
            name = this._world.linkBreedsOwnNameAt(this.getBreed(), i);
            int n = oldpos = compiling ? this.oldBreedsOwnIndexOf(oldProgram, this.getBreed(), name) : this._world.linkBreedsOwnIndexOf(oldBreed, name);
            if (oldpos == -1) {
                variables[i] = World.Zero();
                continue;
            }
            variables[i] = oldvars[oldpos];
            oldvars[oldpos] = null;
        }
        this.setVariables(variables);
        return null;
    }

    private int oldBreedsOwnIndexOf(Program oldProgram, AgentSet breed, String name) {
        Option found = oldProgram.linkBreeds().get((Object)breed.printName());
        if (found.isEmpty()) {
            return -1;
        }
        int result = ((Breed)found.get()).owns().indexOf((Object)name);
        if (result == -1) {
            return -1;
        }
        return oldProgram.linksOwn().size() + result;
    }

    @Override
    public Object getVariable(int vn) {
        return this.getLinkVariable(vn);
    }

    @Override
    public String variableName(int vn) {
        if (vn < this._world.program().linksOwn().size()) {
            return this._world.linksOwnNameAt(vn);
        }
        return this._world.linkBreedsOwnNameAt(this.getBreed(), vn);
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) {
        return this.getLinkVariable(this._world.program().linksOwn().indexOf((Object)varName));
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException {
        this.setLinkVariable(vn, value);
    }

    @Override
    public Object getLinkVariable(int vn) {
        return this.variables()[vn];
    }

    public double getLinkVariableDouble(int vn) {
        switch (vn) {
            case 7: {
                return this.lineThickness();
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        this.setLinkVariable(this._world.program().linksOwn().indexOf((Object)varName), value);
    }

    @Override
    public void setLinkVariable(int vn, double value) {
        switch (vn) {
            case 7: {
                this.lineThickness(value);
                break;
            }
            default: {
                throw new IllegalArgumentException(vn + " is not a double variable");
            }
        }
    }

    @Override
    public void setLinkVariable(int vn, Object value) throws AgentException {
        if (vn > this.LAST_PREDEFINED_VAR) {
            this.variables()[vn] = value;
        } else {
            switch (vn) {
                case 2: {
                    if (value instanceof Double) {
                        this.colorDouble((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.color((LogoList)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], Double.class, value);
                    break;
                }
                case 3: {
                    this.label(value);
                    break;
                }
                case 4: {
                    if (value instanceof Double) {
                        this.labelColor((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.labelColor((LogoList)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], Double.class, value);
                    break;
                }
                case 5: {
                    if (value instanceof Boolean) {
                        this.hidden((Boolean)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], Boolean.class, value);
                    break;
                }
                case 6: {
                    if (value instanceof AgentSet) {
                        AgentSet breed = (AgentSet)value;
                        if (breed != this._world.links() && !this._world.isLinkBreed(breed)) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Link.cantSetBreedToNonLinkBreedAgentSet"));
                        }
                        if (this._world.getLink(this._end1.agentKey(), this._end2.agentKey(), breed) != null) {
                            throw new AgentException("there is already a " + this._world.getLinkBreedSingular(breed) + " with endpoints " + this._end1.toString() + " and " + this._end2.toString());
                        }
                        if (!this._world.linkManager().checkBreededCompatibility(breed == this._world.links())) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Link.cantHaveBreededAndUnbreededLinks"));
                        }
                        this.setBreed(breed);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], AgentSet.class, value);
                    break;
                }
                case 7: {
                    if (value instanceof Double) {
                        this.lineThickness((Double)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], Double.class, value);
                    break;
                }
                case 8: {
                    if (value instanceof String) {
                        String newShape = this._world.checkLinkShapeName((String)value);
                        if (newShape == null) {
                            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.shapeUndefined", value));
                        }
                        this.shape(newShape);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], String.class, value);
                    break;
                }
                case 9: {
                    if (value instanceof String) {
                        this.mode((String)value);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitLinkVariables()[vn], String.class, value);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AgentException("you can't change a link's endpoints");
                }
            }
        }
        this._world.notifyWatchers(this, vn, value);
    }

    @Override
    public Object getTurtleVariable(int vn) throws AgentException {
        throw new AgentException("a link can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        throw new AgentException("a link can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        this.mustOwn(name);
        int vn = this._world.linkBreedsOwnIndexOf(this.getBreed(), name);
        return this.getLinkVariable(vn);
    }

    @Override
    public Object getPatchVariable(int vn) throws AgentException {
        throw new AgentException("a link can't access a patch variable without specifying which patch");
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setTurtleVariable(int vn, double value) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    public void setBreedVariable(int vn, double value) throws AgentException {
        throw new AgentException("a link can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        this.mustOwn(name);
        int vn = this._world.linkBreedsOwnIndexOf(this.getBreed(), name);
        this.setLinkVariable(vn, value);
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        throw new AgentException("a link can't set a patch variable without specifying which turtle");
    }

    @Override
    public void setPatchVariable(int vn, double value) throws AgentException {
        throw new AgentException("a link can't set a patch variable without specifying which turtle");
    }

    void mustOwn(String name) throws AgentException {
        if (name != null && !this._world.linkBreedOwns(this.getBreed(), name)) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.breedDoesNotOwnVariable", this.getBreed().printName(), name));
        }
    }

    @Override
    public double x1() {
        return this._end1.xcor();
    }

    @Override
    public double y1() {
        return this._end1.ycor();
    }

    @Override
    public double x2() {
        return this._world.topology().shortestPathX(this._end1.xcor(), this._end2.xcor());
    }

    @Override
    public double y2() {
        return this._world.topology().shortestPathY(this._end1.ycor(), this._end2.ycor());
    }

    @Override
    public double midpointX() {
        double x1 = this.x1();
        double x2 = this.x2();
        return Topology.wrap((x1 + x2) / 2.0, (double)this._world.minPxcor() - 0.5, (double)this._world.maxPxcor() + 0.5);
    }

    @Override
    public double midpointY() {
        double y1 = this.y1();
        double y2 = this.y2();
        return Topology.wrap((y1 + y2) / 2.0, (double)this._world.minPycor() - 0.5, (double)this._world.maxPycor() + 0.5);
    }

    @Override
    public double heading() {
        try {
            return this._world.protractor().towards(this._end1, this._end2, true);
        }
        catch (AgentException e) {
            return 0.0;
        }
    }

    @Override
    public double lineThickness() {
        return (Double)this.variables()[7];
    }

    public void lineThickness(Double value) {
        this.variables()[7] = value;
    }

    @Override
    public boolean isDirectedLink() {
        return ((AgentSet)this.variables()[6]).isDirected();
    }

    @Override
    public double linkDestinationSize() {
        return this._end2.size();
    }

    @Override
    public double size() {
        return this._world.protractor().distance(this._end1, this._end2, true);
    }

    @Override
    public String shape() {
        return (String)this.variables()[8];
    }

    public void shape(String shape) {
        this.variables()[8] = shape;
    }

    public String mode() {
        return (String)this.variables()[9];
    }

    public void mode(String mode) {
        this._world.tieManager().setTieMode(this, mode);
        this.variables()[9] = mode;
    }

    public boolean isTied() {
        return !this.variables()[9].equals(MODE_NONE);
    }

    public void untie() {
        this.mode(MODE_NONE);
    }

    @Override
    public Object color() {
        return this.variables()[2];
    }

    public void colorDouble(Double boxedColor) {
        double c = boxedColor;
        if (c < 0.0 || c >= (double)Color.MaxColor()) {
            c = Color.modulateDouble(c);
            boxedColor = c;
        }
        this.variables()[2] = boxedColor;
    }

    public void colorDoubleUnchecked(Double boxedColor) {
        this.variables()[2] = boxedColor;
    }

    public void color(LogoList rgb) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables()[2] = rgb;
        if (rgb.size() > 3) {
            this._world.mayHavePartiallyTransparentObjects(true);
        }
    }

    public AgentSet bothEnds() {
        return AgentSet.fromArray(AgentKindJ.Turtle(), new Turtle[]{this._end1, this._end2});
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        throw new AgentException("links can't access patches via relative coordinates");
    }

    public Object label() {
        return this.variables()[3];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables()[3]);
    }

    public void label(Object label) {
        this.variables()[3] = label;
    }

    @Override
    public boolean hidden() {
        return (Boolean)this.variables()[5];
    }

    public void hidden(boolean hidden) {
        this.variables()[5] = hidden ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public TreeAgentSet getBreed() {
        return (TreeAgentSet)this.variables()[6];
    }

    @Override
    public Object labelColor() {
        return this.variables()[4];
    }

    public void labelColor(double labelColor) {
        this.variables()[4] = Color.modulateDouble(labelColor);
    }

    public void labelColor(LogoList rgb) throws AgentException {
        this.validRGBList(rgb, true);
        this.variables()[4] = rgb;
    }

    public String toString() {
        return this._world.getLinkBreedSingular(this.getBreed()).toLowerCase() + " " + this._end1._id + " " + this._end2._id;
    }

    @Override
    public String classDisplayName() {
        return this._world.getLinkBreedSingular(this.getBreed()).toLowerCase();
    }

    @Override
    public int agentBit() {
        return 8;
    }

    public void setBreed(AgentSet breed) {
        AgentSet oldBreed = null;
        if (this.variables()[6] instanceof AgentSet) {
            this._world.linkManager().removeLink(this);
            oldBreed = (AgentSet)this.variables()[6];
            if (breed == oldBreed) {
                return;
            }
            if (oldBreed != this._world.links()) {
                ((TreeAgentSet)this.variables()[6]).remove(this.agentKey());
            }
        }
        if (breed != this._world.links()) {
            ((TreeAgentSet)breed).add(this);
        }
        this.variables()[6] = breed;
        if (oldBreed != null) {
            this._world.linkManager().addLink(this);
        }
        this.shape(this._world.linkBreedShapes().breedShape(breed));
        this.realloc(null, this._world.program(), oldBreed);
    }

    @Override
    public int getBreedIndex() {
        TreeAgentSet mybreed = this.getBreed();
        if (mybreed == this._world.links()) {
            return 0;
        }
        int j = 1;
        Iterator iter = this._world.linkBreeds().values().iterator();
        while (iter.hasNext()) {
            if (mybreed == iter.next()) {
                return j;
            }
            ++j;
        }
        return 0;
    }

    @Override
    public int compareTo(Agent a) {
        if (a == this) {
            return 0;
        }
        Link otherLink = (Link)a;
        if (this._end1._id < otherLink._end1._id) {
            return -1;
        }
        if (this._end1._id > otherLink._end1._id) {
            return 1;
        }
        if (this._end2._id < otherLink._end2._id) {
            return -1;
        }
        if (this._end2._id > otherLink._end2._id) {
            return 1;
        }
        if (this.getBreed() == otherLink.getBreed()) {
            return 0;
        }
        if (this.getBreed() == this._world.links()) {
            return -1;
        }
        if (otherLink.getBreed() == this._world.links()) {
            return 1;
        }
        return this._world.compareLinkBreeds(this.getBreed(), otherLink.getBreed());
    }

    @Override
    public int alpha() {
        return Color.getColor(this.color()).getAlpha();
    }

    public Turtle otherEnd(Turtle parent) {
        return this._end1 == parent ? this._end2 : this._end1;
    }
}

