/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Directedness;
import org.nlogo.agent.Directedness$Undetermined$;
import org.nlogo.agent.DummyLink;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkFactory;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.log.LogManager$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;

public class LinkManagerImpl<W extends World>
implements LinkManager {
    private final W world;
    private final LinkFactory<W> linkFactory;
    private int unbreededLinkCount;

    public LinkManagerImpl(W world, LinkFactory<W> linkFactory) {
        this.world = world;
        this.linkFactory = linkFactory;
        this.unbreededLinkCount = 0;
    }

    @Override
    public void reset() {
        ((World)this.world).links().agents().forEach(x$1 -> {
            org.nlogo.api.Agent agent = x$1;
            if (agent instanceof Link) {
                Link l = (Link)agent;
                l.end1().removeLink(l);
                l.end2().removeLink(l);
                return;
            }
        });
        this.world.tieManager().reset();
        this.unbreededLinkCount = 0;
        ((World)this.world).links().clearDirected();
    }

    @Override
    public boolean checkBreededCompatibility(boolean unbreeded) {
        AgentIterator it = ((World)this.world).links().iterator();
        return !it.hasNext() || unbreeded == (((Link)it.next()).getBreed() == ((World)this.world).links());
    }

    @Override
    public Link createLink(Turtle src, Turtle dest, AgentSet linkBreed) {
        Link link = this.linkFactory.apply(this.world, src, dest, linkBreed);
        this.addLink(link);
        LogManager$.MODULE$.linkCreated(link.id(), linkBreed.printName(), src.id(), dest.id());
        return link;
    }

    @Override
    public void addLink(Link link) {
        if (link.getBreed() == ((World)this.world).links()) {
            Directedness directedness = ((World)this.world).links().directed();
            Directedness$Undetermined$ directedness$Undetermined$ = Directedness$Undetermined$.MODULE$;
            if (!(directedness != null ? !directedness.equals(directedness$Undetermined$) : directedness$Undetermined$ != null)) {
                ((World)this.world).links().setDirected(false);
            }
            ++this.unbreededLinkCount;
        }
        link.end1().addLink(link);
        link.end2().addLink(link);
    }

    @Override
    public void removeLink(Link link) {
        link.end1().removeLink(link);
        link.end2().removeLink(link);
        if (link.getBreed() == ((World)this.world).links()) {
            --this.unbreededLinkCount;
            if (this.unbreededLinkCount == 0) {
                ((World)this.world).links().clearDirected();
                return;
            }
            return;
        }
    }

    @Override
    public void cleanupLink(Link link) {
        link.untie();
        this.removeLink(link);
    }

    @Override
    public void cleanupTurtle(Turtle turtle) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])turtle.links());
        ArrayOps$.MODULE$.foreach$extension(object, _$1 -> _$1.die());
    }

    @Override
    public Turtle[] outNeighbors(Turtle src, AgentSet linkBreed) {
        return this.otherEnds(src, this.outLinks(src, linkBreed), linkBreed);
    }

    @Override
    public Turtle[] inNeighbors(Turtle target, AgentSet linkBreed) {
        return this.otherEnds(target, this.inLinks(target, linkBreed), linkBreed);
    }

    @Override
    public Turtle[] neighbors(Turtle turtle, AgentSet linkSet) {
        return this.otherEnds(turtle, this.links(turtle, linkSet), linkSet);
    }

    @Override
    public Option<Link> getLink(Turtle src, Turtle dest, AgentSet linkBreed) {
        if (src == null || dest == null) {
            return None$.MODULE$;
        }
        Agent link = ((World)this.world).links().getAgent(new DummyLink((World)this.world, (Object)src, (Object)dest, linkBreed));
        if (link == null && linkBreed.isUndirected()) {
            link = ((World)this.world).links().getAgent(new DummyLink((World)this.world, (Object)dest, (Object)src, linkBreed));
        }
        return Option$.MODULE$.apply((Object)link);
    }

    @Override
    public boolean isLinkedWith(Turtle src, Turtle dest, AgentSet linkBreed) {
        return src.isLinkedWith(dest, linkBreed);
    }

    @Override
    public boolean isLinkedTo(Turtle src, Turtle dest, AgentSet linkBreed) {
        return src.isLinkedTo(dest, linkBreed);
    }

    @Override
    public Link[] linksWith(Turtle src, Turtle dest, AgentSet linkBreed) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.links(src, linkBreed));
        return (Link[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$2 -> {
            Turtle turtle = _$2.otherEnd(src);
            Turtle turtle2 = dest;
            return !(turtle != null ? !turtle.equals(turtle2) : turtle2 != null);
        });
    }

    @Override
    public Link[] linksTo(Turtle src, Turtle dest, AgentSet linkBreed) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.outLinks(src, linkBreed));
        return (Link[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$3 -> {
            Turtle turtle = _$3.otherEnd(src);
            Turtle turtle2 = dest;
            return !(turtle != null ? !turtle.equals(turtle2) : turtle2 != null);
        });
    }

    @Override
    public Link[] outLinks(Turtle src, AgentSet linkBreed) {
        return src.selectLinks(true, false, linkBreed);
    }

    @Override
    public Link[] inLinks(Turtle target, AgentSet linkBreed) {
        return target.selectLinks(false, true, linkBreed);
    }

    @Override
    public Link[] links(Turtle turtle, AgentSet linkSet) {
        return turtle.selectLinks(true, true, linkSet);
    }

    public Turtle[] otherEnds(Turtle turtle, Link[] links, AgentSet linkBreed) {
        Object[] result = new Turtle[links.length];
        for (int i = 0; i < links.length; ++i) {
            result[i] = links[i].otherEnd(turtle);
        }
        if (linkBreed == ((World)this.world).links() && ((World)this.world).linkBreeds().size() > 1) {
            Object object = Predef$.MODULE$.refArrayOps(result);
            return (Turtle[])ArrayOps$.MODULE$.distinct$extension(object);
        }
        return result;
    }

    @Override
    public DummyLink dummyLink(Object end1, Object end2, AgentSet breed) {
        return new DummyLink((World)this.world, end1, end2, breed);
    }
}

