/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import org.nlogo.agent.PenLineMaker;
import org.nlogo.agent.PenLineMaker$HelperContext$;
import org.nlogo.agent.Trail;
import org.nlogo.api.Numbers$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class PenLineMaker$
implements Serializable {
    private static final PenLineMaker$HelperContext$ HelperContext;
    public static final PenLineMaker$ MODULE$;

    private PenLineMaker$() {
    }

    static {
        MODULE$ = new PenLineMaker$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PenLineMaker$.class);
    }

    public Trail[] jumpLine(double x2, double y2, double heading, double jumpDist2, double minX, double maxX, double minY, double maxY) {
        if (jumpDist2 == 0.0) {
            return (Trail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Trail.class));
        }
        Function3 & Serializable makeTrailsBy = (Function3 & Serializable)(x, y, jumpDist) -> PenLineMaker$.MODULE$.makeTrails(heading, minX, maxX, minY, maxY, BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y), BoxesRunTime.unboxToDouble((Object)jumpDist));
        JFunction1.mcDD.sp & Serializable lazyWrapX = (JFunction1.mcDD.sp & Serializable)value -> MODULE$.lazyWrapValue(minX, maxX, value);
        JFunction1.mcDD.sp & Serializable lazyWrapY = (JFunction1.mcDD.sp & Serializable)value -> MODULE$.lazyWrapValue(minY, maxY, value);
        return (Trail[])this.helper(x2, y2, jumpDist2, PenLineMaker$HelperContext$.MODULE$.apply((Function3<Object, Object, Object, Seq<Trail>>)makeTrailsBy, (Function1<Object, Object>)lazyWrapX, (Function1<Object, Object>)lazyWrapY), this.helper$default$5()).toArray(ClassTag$.MODULE$.apply(Trail.class));
    }

    public Trail[] translate(double x0, double y0, double x1, double y1) {
        double dist = StrictMath.sqrt(StrictMath.pow(x0 - x1, 2.0) + StrictMath.pow(y0 - y1, 2.0));
        if (dist == 0.0) {
            return new Trail[0];
        }
        return new Trail[]{new Trail(x0, y0, x1, y1, dist)};
    }

    private Seq<Trail> helper(double x, double y, double jumpDist, PenLineMaker.HelperContext context, LinkedHashSet<Trail> acc) {
        while (true) {
            double nextJumpDist;
            PenLineMaker.HelperContext helperContext;
            if ((helperContext = context) == null) {
                throw new MatchError((Object)helperContext);
            }
            PenLineMaker.HelperContext helperContext2 = PenLineMaker$HelperContext$.MODULE$.unapply(helperContext);
            Function3<Object, Object, Object, Seq<Trail>> function3 = helperContext2._1();
            Function1<Object, Object> function1 = helperContext2._2();
            Function1<Object, Object> function12 = helperContext2._3();
            Function3<Object, Object, Object, Seq<Trail>> makeTrailsBy = function3;
            Function1<Object, Object> lazyWrapX = function1;
            Function1<Object, Object> lazyWrapY = function12;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(makeTrailsBy, lazyWrapX, lazyWrapY);
            Function3 makeTrailsBy2 = (Function3)tuple3._1();
            Function1 lazyWrapX2 = (Function1)tuple3._2();
            Function1 lazyWrapY2 = (Function1)tuple3._3();
            Seq trails = (Seq)makeTrailsBy2.apply((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)jumpDist));
            Trail trail = (Trail)trails.minBy((Function1 & Serializable)_$1 -> _$1.dist(), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
            LinkedHashSet newAcc = (LinkedHashSet)acc.clone();
            newAcc.add((Object)trail);
            double d = nextJumpDist = jumpDist >= 0.0 ? jumpDist - trail.dist() : jumpDist + trail.dist();
            if (nextJumpDist == 0.0 || newAcc.size() == acc.size()) {
                return newAcc.toSeq();
            }
            double newX = lazyWrapX2.apply$mcDD$sp(trail.x2());
            double newY = lazyWrapY2.apply$mcDD$sp(trail.y2());
            double d2 = newX;
            double d3 = newY;
            double d4 = nextJumpDist;
            LinkedHashSet linkedHashSet = newAcc;
            x = d2;
            y = d3;
            jumpDist = d4;
            acc = linkedHashSet;
        }
    }

    private LinkedHashSet<Trail> helper$default$5() {
        return (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Trail[0]));
    }

    private double lazyWrapValue(double min, double max, double value) {
        if (value <= min) {
            return max;
        }
        if (value >= max) {
            return min;
        }
        return value;
    }

    private double distanceFromLegs(double l1, double l2) {
        JFunction1.mcDD.sp & Serializable square = (JFunction1.mcDD.sp & Serializable)x -> StrictMath.pow(x, 2.0);
        return StrictMath.sqrt(square.apply$mcDD$sp(l1) + square.apply$mcDD$sp(l2));
    }

    private Seq<Trail> makeTrails(double heading, double minX, double maxX, double minY, double maxY, double x2, double y, double jumpDist) {
        None$ none$;
        None$ yInterceptTrails;
        None$ none$2;
        JFunction1.mcDD.sp & Serializable squash = (JFunction1.mcDD.sp & Serializable)x -> {
            if (StrictMath.abs(x) < Numbers$.MODULE$.Infinitesimal()) {
                return 0.0;
            }
            return x;
        };
        double xcomp = ((JFunction1.mcDD.sp & Serializable)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.toRadians(x$0)).andThen((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.sin(x$0)).andThen((Function1)squash).apply$mcDD$sp(heading);
        double ycomp = ((JFunction1.mcDD.sp & Serializable)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.toRadians(x$0)).andThen((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.cos(x$0)).andThen((Function1)squash).apply$mcDD$sp(heading);
        double tan = ((JFunction1.mcDD.sp & Serializable)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.toRadians(x$0)).andThen((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.tan(x$0)).andThen((Function1)squash).apply$mcDD$sp(heading);
        double rawX = x2 + xcomp * jumpDist;
        double rawY = y + ycomp * jumpDist;
        Option baseTrails = Option$.MODULE$.apply((Object)new Trail(x2, y, rawX, rawY, jumpDist < 0.0 ? jumpDist * (double)-1 : jumpDist));
        Function4 & Serializable makeTrailComponent = (Function4 & Serializable)(endX, endY, dx, dy) -> Option$.MODULE$.apply((Object)new Trail(x2, y, BoxesRunTime.unboxToDouble((Object)endX), BoxesRunTime.unboxToDouble((Object)endY), PenLineMaker$.MODULE$.distanceFromLegs(BoxesRunTime.unboxToDouble((Object)dx), BoxesRunTime.unboxToDouble((Object)dy))));
        if (rawX > maxX) {
            double dx2 = maxX - x2;
            double dy2 = dx2 / tan;
            double interceptY = y + dy2;
            none$2 = (Option)makeTrailComponent.apply((Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)interceptY), (Object)BoxesRunTime.boxToDouble((double)dx2), (Object)BoxesRunTime.boxToDouble((double)dy2));
        } else if (rawX < minX) {
            double dx3 = x2 - minX;
            double dy3 = dx3 / tan;
            double interceptY = y - dy3;
            none$2 = (Option)makeTrailComponent.apply((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)interceptY), (Object)BoxesRunTime.boxToDouble((double)dx3), (Object)BoxesRunTime.boxToDouble((double)dy3));
        } else {
            none$2 = yInterceptTrails = None$.MODULE$;
        }
        if (rawY > maxY) {
            double dy4 = maxY - y;
            double dx4 = dy4 * tan;
            double interceptX = x2 + dx4;
            none$ = (Option)makeTrailComponent.apply((Object)BoxesRunTime.boxToDouble((double)interceptX), (Object)BoxesRunTime.boxToDouble((double)maxY), (Object)BoxesRunTime.boxToDouble((double)dx4), (Object)BoxesRunTime.boxToDouble((double)dy4));
        } else if (rawY < minY) {
            double dy5 = y - minY;
            double dx5 = dy5 * tan;
            double interceptX = x2 - dx5;
            none$ = (Option)makeTrailComponent.apply((Object)BoxesRunTime.boxToDouble((double)interceptX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)dx5), (Object)BoxesRunTime.boxToDouble((double)dy5));
        } else {
            none$ = None$.MODULE$;
        }
        None$ xInterceptTrails = none$;
        return ((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(baseTrails).$plus$plus((IterableOnce)xInterceptTrails)).$plus$plus((IterableOnce)yInterceptTrails)).toSeq();
    }
}

