/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.Numbers$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.Exception$;

public class TieManager {
    private final TreeAgentSet links;
    private final LinkManager linkManager;
    private final Protractor protractor;
    private int tieCount;

    public TieManager(TreeAgentSet links, LinkManager linkManager, Protractor protractor) {
        this.links = links;
        this.linkManager = linkManager;
        this.protractor = protractor;
        this.tieCount = 0;
    }

    public boolean hasTies() {
        return this.tieCount > 0;
    }

    public void reset() {
        this.tieCount = 0;
    }

    public void setTieMode(Link link, String mode) {
        if (link.isTied()) {
            String string = mode;
            String string2 = "none";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                --this.tieCount;
                return;
            }
        }
        String string = mode;
        String string3 = "none";
        if (string == null ? string3 != null : !string.equals(string3)) {
            ++this.tieCount;
            return;
        }
    }

    public Seq<Turtle> tiedTurtles(Turtle root, Set<Turtle> seenTurtles) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.linkManager.outLinks(root, this.links));
        Object[] tiedTurtles = (Turtle[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(root){
            private final Turtle root$1;
            {
                this.root$1 = root$4;
            }

            public final boolean isDefinedAt(Link x) {
                Link link = x;
                Link link2 = link;
                return link2.isTied();
            }

            public final Object applyOrElse(Link x, Function1 function1) {
                Link link = x;
                Link link2 = link;
                if (link2.isTied()) {
                    return link2.otherEnd(this.root$1);
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(Turtle.class));
        Object object2 = Predef$.MODULE$.refArrayOps(tiedTurtles);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(object2, (Function1 & Serializable)t -> t.id() == -1L || seenTurtles.apply(t)));
        return (Seq)ArrayOps$.MODULE$.toSeq$extension(object3).distinct();
    }

    public void turtleMoved(Turtle root, double newX, double newY, double oldX, double oldY) {
        this.turtleMoved(root, newX, newY, oldX, oldY, (Set<Turtle>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Turtle[]{root}))));
    }

    public void turtleMoved(Turtle root, double newX, double newY, double oldX, double oldY, Set<Turtle> seenTurtles) {
        Seq<Turtle> turtles = this.tiedTurtles(root, seenTurtles);
        Set allSeenTurtles = (Set)seenTurtles.$plus$plus(turtles);
        turtles.foreach(t -> {
            double dx = newX - oldX;
            double dy = newY - oldY;
            Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{AgentException.class})).apply((Function0 & Serializable)() -> {
                TieManager.turtleMoved$$anonfun$1$$anonfun$1(t, dx, dy, allSeenTurtles);
                return BoxedUnit.UNIT;
            });
        });
    }

    public void turtleTurned(Turtle root, double newHeading, double oldHeading) {
        this.turtleTurned(root, newHeading, oldHeading, (Set<Turtle>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Turtle[]{root}))));
    }

    public void turtleTurned(Turtle root, double newHeading, double oldHeading, Set<Turtle> seenTurtles) {
        Function1 & Serializable isLinkedFixedly = (Function1 & Serializable)t -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.linkManager.linksTo(root, (Turtle)t, this.links));
            return ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$1 -> {
                String string = _$1.mode();
                String string2 = "fixed";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).nonEmpty();
        };
        Function1 & Serializable getCoords = (Function1 & Serializable)t -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)t.xcor()), (Object)BoxesRunTime.boxToDouble((double)t.ycor()));
        JFunction1.mcDD.sp & Serializable squash = (JFunction1.mcDD.sp & Serializable)x -> {
            if (StrictMath.abs(x) < Numbers$.MODULE$.Infinitesimal()) {
                return 0.0;
            }
            return x;
        };
        Function1 squashedSin = ((JFunction1.mcDD.sp & Serializable)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.toRadians(x$0)).andThen((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.sin(x$0)).andThen((Function1)squash);
        Function1 squashedCos = ((JFunction1.mcDD.sp & Serializable)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.toRadians(x$0)).andThen((Function1)(JFunction1.mcDD.sp & Serializable)x$0 -> StrictMath.cos(x$0)).andThen((Function1)squash);
        double dh = Turtle.subtractHeadings(newHeading, oldHeading);
        Tuple2 tuple2 = (Tuple2)getCoords.apply((Object)root);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double x2 = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x2, y);
        double x3 = sp2._1$mcD$sp();
        double y2 = sp2._2$mcD$sp();
        Seq<Turtle> turtles = this.tiedTurtles(root, seenTurtles);
        Set allSeenTurtles = (Set)seenTurtles.$plus$plus(turtles);
        turtles.foreach(t -> {
            boolean wentBoom;
            boolean bl;
            try {
                double r = this.protractor.distance(root, (Agent)t, true);
                if (r != 0.0) {
                    double theta = this.protractor.towards(root, (Agent)t, true) + dh;
                    double newX2 = x3 + r * squashedSin.apply$mcDD$sp(theta);
                    double newY2 = y2 + r * squashedCos.apply$mcDD$sp(theta);
                    t.xandycor(newX2, newY2, (Set<Turtle>)allSeenTurtles, false);
                }
                bl = false;
            }
            catch (AgentException agentException) {
                bl = wentBoom = true;
            }
            if (BoxesRunTime.unboxToBoolean((Object)isLinkedFixedly.apply(t)) && !wentBoom) {
                t.heading(t.heading + dh, (Set<Turtle>)allSeenTurtles);
                return;
            }
        });
    }

    private static final void turtleMoved$$anonfun$1$$anonfun$1(Turtle t$1, double dx$1, double dy$1, Set allSeenTurtles$2) {
        t$1.xandycor(t$1.xcor + dx$1, t$1.ycor + dy$1, (Set<Turtle>)allSeenTurtles$2, false);
    }
}

